/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.tools;

import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.UntypedParserContextFactory;
import io.jafar.parser.internal_api.ChunkHeader;
import io.jafar.parser.internal_api.ChunkParserListener;
import io.jafar.parser.internal_api.ParserContextFactory;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.StreamingChunkParser;
import io.jafar.parser.internal_api.TypeSkipper;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataField;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class Scrubber {
    private static final String SCRUBBING_INFO_KEY = "scrubbingInfo";

    public static void scrubFile(Path input, Path output, Function<String, ScrubField> scrubDefinition) throws Exception {
        TreeSet<SkipInfo> globalSkipInfo = new TreeSet<SkipInfo>(Comparator.comparingLong(o -> o.endPos));
        UntypedParserContextFactory contextFactory = new UntypedParserContextFactory();
        try (StreamingChunkParser parser = new StreamingChunkParser((ParserContextFactory)contextFactory);){
            parser.parse(input, (ChunkParserListener)new SkipInfoCollector(scrubDefinition, globalSkipInfo));
        }
        Scrubber.scrubFile(input, output, globalSkipInfo);
    }

    private static void scrubFile(Path input, Path output, Set<SkipInfo> skipRanges) throws Exception {
        int BUF_SIZE = 65536;
        ByteBuffer copyBuf = ByteBuffer.allocateDirect(65536);
        try (FileChannel in = FileChannel.open(input, StandardOpenOption.READ);
             FileChannel out = FileChannel.open(output, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            long pos = 0L;
            for (SkipInfo range : skipRanges) {
                long s;
                int payloadLen;
                long from = range.startPos;
                long to = range.endPos;
                long chunkSize = from - pos;
                if (chunkSize > 0L) {
                    Scrubber.copyRegion(in, out, pos, chunkSize, copyBuf);
                }
                if ((payloadLen = Scrubber.computeFittingPayloadLength((int)(s = to - from - 1L))) > 65536) {
                    throw new RuntimeException("Payload length exceeds buffer size: " + payloadLen + " > " + 65536 + " for skip range [" + from + ", " + to + ") (range size: " + (to - from) + ")");
                }
                copyBuf.clear();
                copyBuf.put((byte)4);
                Scrubber.writeVarint(copyBuf, payloadLen);
                for (int i = 0; i < payloadLen; ++i) {
                    copyBuf.put((byte)120);
                }
                copyBuf.flip();
                while (copyBuf.hasRemaining()) {
                    out.write(copyBuf);
                }
                in.position(to);
                pos = to;
            }
            long fileSize = in.size();
            if (pos < fileSize) {
                Scrubber.copyRegion(in, out, pos, fileSize - pos, copyBuf);
            }
        }
    }

    public static void writeVarint(ByteBuffer buf, int value) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            buf.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        buf.put((byte)value);
    }

    static int varintSize(int value) {
        int size = 0;
        do {
            ++size;
        } while ((value >>>= 7) != 0);
        return size;
    }

    static int computeFittingPayloadLength(int totalLen) {
        for (int len = totalLen; len >= 0; --len) {
            if (Scrubber.varintSize(len) + len != totalLen) continue;
            return len;
        }
        throw new IllegalArgumentException("Cannot compute fitting payload length for: " + totalLen);
    }

    static void copyRegion(FileChannel in, FileChannel out, long pos, long size, ByteBuffer buf) throws IOException {
        in.position(pos);
        long remaining = size;
        while (remaining > 0L) {
            buf.clear();
            int read = in.read(buf);
            if (read == -1) break;
            buf.flip();
            if ((long)read > remaining) {
                buf.limit((int)remaining);
                in.position(in.position() + remaining - (long)read);
            }
            while (buf.hasRemaining()) {
                int written = out.write(buf);
                remaining -= (long)written;
            }
        }
    }

    private static class SkipInfoCollector
    implements ChunkParserListener {
        private final Function<String, ScrubField> scrubDefinition;
        private final Set<SkipInfo> globalSkipInfo;

        public SkipInfoCollector(Function<String, ScrubField> scrubDefinition, Set<SkipInfo> globalSkipInfo) {
            this.scrubDefinition = scrubDefinition;
            this.globalSkipInfo = globalSkipInfo;
        }

        public boolean onChunkStart(ParserContext context, int chunkIndex, ChunkHeader header) {
            ScrubbingInfo info = new ScrubbingInfo();
            context.put(Scrubber.SCRUBBING_INFO_KEY, ScrubbingInfo.class, (Object)info);
            info.chunkOffset = header.offset;
            info.skipInfo = new TreeSet<SkipInfo>(Comparator.comparingLong(o -> o.startPos));
            info.targetClassMap = new HashMap<Long, TypeScrubbing>();
            return super.onChunkStart(context, chunkIndex, header);
        }

        public boolean onMetadata(ParserContext context, MetadataEvent metadata) {
            ScrubbingInfo info = (ScrubbingInfo)context.get(Scrubber.SCRUBBING_INFO_KEY, ScrubbingInfo.class);
            for (MetadataClass md : metadata.getClasses()) {
                ScrubField scrubField = this.scrubDefinition.apply(md.getName());
                if (scrubField == null) continue;
                info.targetClassMap.computeIfAbsent(md.getId(), id -> {
                    TypeSkipper skipper = TypeSkipper.createSkipper((MetadataClass)md);
                    int scrubFieldIndex = -1;
                    int guardFieldIndex = -1;
                    for (int i = 0; i < md.getFields().size(); ++i) {
                        MetadataField field = (MetadataField)md.getFields().get(i);
                        if (field.getName().equals(scrubField.scrubFieldName)) {
                            scrubFieldIndex = i;
                        } else if (field.getName().equals(scrubField.guardFieldName)) {
                            guardFieldIndex = i;
                        }
                        if (scrubFieldIndex != -1 && guardFieldIndex != -1) break;
                    }
                    if (scrubFieldIndex != -1) {
                        return new TypeScrubbing(md.getId(), skipper, scrubFieldIndex, guardFieldIndex, scrubField.guard);
                    }
                    return null;
                });
            }
            return super.onMetadata(context, metadata);
        }

        public boolean onEvent(ParserContext context, long typeId, long eventStartPos, long rawSize, long payloadSize) {
            ScrubbingInfo info = (ScrubbingInfo)context.get(Scrubber.SCRUBBING_INFO_KEY, ScrubbingInfo.class);
            if (info == null) {
                throw new IllegalStateException("invalid parser state, no scrubbing info found");
            }
            TypeScrubbing targetScrub = info.targetClassMap.get(typeId);
            if (targetScrub != null) {
                RecordingStream stream = (RecordingStream)context.get(RecordingStream.class);
                assert (stream != null);
                long chunkOffset = info.chunkOffset;
                try {
                    SkipInfo[] skipInfo = new SkipInfo[1];
                    String[] skipValue = new String[1];
                    String[] guardValue = new String[1];
                    targetScrub.skipper.skip(stream, (idx, from, to) -> {
                        long currentPos;
                        if (targetScrub.scrubFieldIndex == idx) {
                            skipInfo[0] = new SkipInfo(chunkOffset + from, chunkOffset + to);
                            if (targetScrub.scrubGuardIndex != -1) {
                                currentPos = stream.position();
                                stream.position(from);
                                try {
                                    skipValue[0] = stream.readUTF8();
                                }
                                catch (IOException e) {
                                    throw new RuntimeException("Failed to read scrub field value at " + from, e);
                                }
                                finally {
                                    stream.position(currentPos);
                                }
                            }
                        }
                        if (targetScrub.scrubGuardIndex == idx) {
                            currentPos = stream.position();
                            stream.position(from);
                            try {
                                guardValue[0] = stream.readUTF8();
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed to read guard field value at " + from, e);
                            }
                            finally {
                                stream.position(currentPos);
                            }
                        }
                    });
                    if (targetScrub.guard != null && guardValue[0] != null && skipValue[0] != null && !targetScrub.guard.apply(guardValue[0], skipValue[0]).booleanValue()) {
                        skipInfo[0] = null;
                    }
                    if (skipInfo[0] != null) {
                        info.skipInfo.add(skipInfo[0]);
                    }
                }
                catch (IOException ex) {
                    return false;
                }
            }
            return super.onEvent(context, typeId, eventStartPos, rawSize, payloadSize);
        }

        public boolean onChunkEnd(ParserContext context, int chunkIndex, boolean skipped) {
            ScrubbingInfo info = (ScrubbingInfo)context.get(Scrubber.SCRUBBING_INFO_KEY, ScrubbingInfo.class);
            this.globalSkipInfo.addAll(info.skipInfo);
            return true;
        }
    }

    private static class ScrubbingInfo {
        long chunkOffset;
        Set<SkipInfo> skipInfo;
        Map<Long, TypeScrubbing> targetClassMap;

        private ScrubbingInfo() {
        }
    }

    public static final class ScrubField {
        final String scrubFieldName;
        final String guardFieldName;
        final BiFunction<String, String, Boolean> guard;

        public ScrubField(String guardFieldName, String scrubFieldName, BiFunction<String, String, Boolean> guard) {
            this.scrubFieldName = scrubFieldName;
            this.guardFieldName = guardFieldName;
            this.guard = guard;
        }

        public String toString() {
            return "ScrubField{scrubFieldName='" + this.scrubFieldName + '\'' + ", guardFieldName='" + this.guardFieldName + '\'' + '}';
        }
    }

    static final class TypeScrubbing {
        final long typeId;
        final TypeSkipper skipper;
        final int scrubFieldIndex;
        final int scrubGuardIndex;
        final BiFunction<String, String, Boolean> guard;

        TypeScrubbing(long typeId, TypeSkipper skipper, int scrubFieldIndex, int scrubGuardIndex, BiFunction<String, String, Boolean> guard) {
            this.typeId = typeId;
            this.skipper = skipper;
            this.scrubFieldIndex = scrubFieldIndex;
            this.scrubGuardIndex = scrubGuardIndex;
            this.guard = guard;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeScrubbing that = (TypeScrubbing)o;
            return this.typeId == that.typeId;
        }

        public int hashCode() {
            return Objects.hashCode(this.typeId);
        }
    }

    static final class SkipInfo {
        final long startPos;
        final long endPos;

        SkipInfo(long startPos, long endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }
    }
}

