/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.TypedParserContext;
import io.jafar.parser.internal_api.DeserializerCache;
import io.jafar.parser.internal_api.GlobalHandlerCache;
import io.jafar.parser.internal_api.MutableConstantPools;
import io.jafar.parser.internal_api.MutableMetadataLookup;
import io.jafar.parser.internal_api.ParserContextFactory;
import io.jafar.parser.internal_api.metadata.MetadataFingerprint;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Set;

public final class TypedParserContextFactory
implements ParserContextFactory {
    private final Int2ObjectMap<MutableMetadataLookup> chunkMetadataLookup = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<MutableConstantPools> chunkConstantPools = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<MetadataFingerprint> chunkFingerprints = new Int2ObjectOpenHashMap();

    @Override
    public ParserContext newContext(ParserContext parent, int chunkIndex) {
        if (parent == null) {
            return new TypedParserContext(null);
        }
        MutableMetadataLookup metadataLookup = (MutableMetadataLookup)this.chunkMetadataLookup.computeIfAbsent(chunkIndex, k -> new MutableMetadataLookup());
        MutableConstantPools constantPools = (MutableConstantPools)this.chunkConstantPools.computeIfAbsent(chunkIndex, k -> new MutableConstantPools());
        assert (parent instanceof TypedParserContext);
        TypedParserContext lazyParent = (TypedParserContext)parent;
        return new TypedParserContext(lazyParent.getTypeFilter(), chunkIndex, metadataLookup, constantPools, null, this);
    }

    public void resolveDeserializerCache(int chunkIndex, MutableMetadataLookup metadata, TypedParserContext context) {
        Set<String> eventTypes = context.getTargetEventTypes();
        Set<Long> reachableTypes = MetadataFingerprint.computeReachableTypes(metadata, eventTypes);
        MetadataFingerprint fingerprint = MetadataFingerprint.compute(metadata, reachableTypes);
        this.chunkFingerprints.put(chunkIndex, (Object)fingerprint);
        DeserializerCache cache = GlobalHandlerCache.getInstance().getOrCreateCache(fingerprint);
        context.setDeserializerCache(cache);
    }

    public MetadataFingerprint getFingerprint(int chunkIndex) {
        return (MetadataFingerprint)this.chunkFingerprints.get(chunkIndex);
    }
}

