/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.TypeFilter;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.TypedParserContextFactory;
import io.jafar.parser.internal_api.DeserializerCache;
import io.jafar.parser.internal_api.MutableConstantPools;
import io.jafar.parser.internal_api.MutableMetadataLookup;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataField;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class TypedParserContext
extends ParserContext {
    private volatile TypeFilter typeFilter;
    private final Map<String, Class<?>> classTargetTypeMap = new ConcurrentHashMap();
    private Long2ObjectMap<Class<?>> classTypeMap = null;
    private volatile DeserializerCache globalDeserializerCache;
    private final TypedParserContextFactory factory;

    public TypedParserContext() {
        this(new DeserializerCache.Impl());
    }

    TypedParserContext(DeserializerCache deserializerCache) {
        super(0);
        this.globalDeserializerCache = deserializerCache != null ? deserializerCache : new DeserializerCache.Impl();
        this.factory = null;
        this.typeFilter = null;
        this.remove(TypeFilter.class);
        this.put(DeserializerCache.class, this.globalDeserializerCache);
    }

    TypedParserContext(TypeFilter typeFilter, int chunkIndex, MutableMetadataLookup metadataLookup, MutableConstantPools constantPools, DeserializerCache deserializerCache, TypedParserContextFactory factory) {
        super(chunkIndex, metadataLookup, constantPools);
        this.globalDeserializerCache = deserializerCache;
        this.factory = factory;
        this.typeFilter = typeFilter;
        if (typeFilter != null) {
            this.put(TypeFilter.class, typeFilter);
        }
        if (deserializerCache != null) {
            this.put(DeserializerCache.class, this.globalDeserializerCache);
        }
    }

    TypeFilter getTypeFilter() {
        return this.typeFilter;
    }

    public void setTypeFilter(TypeFilter typeFilter) {
        this.typeFilter = typeFilter;
        this.put(TypeFilter.class, typeFilter);
    }

    public void addTargetTypeMap(Map<String, Class<?>> map) {
        this.classTargetTypeMap.putAll(map);
    }

    public Class<?> getClassTargetType(String name) {
        return this.classTargetTypeMap.get(name);
    }

    void bindDeserializers() {
        this.metadataLookup.bindDeserializers();
    }

    public void setClassTypeMap(Long2ObjectMap<Class<?>> map) {
        this.classTypeMap = map;
    }

    public Long2ObjectMap<Class<?>> getClassTypeMap() {
        return this.classTypeMap;
    }

    public DeserializerCache getDeserializerCache() {
        return this.globalDeserializerCache;
    }

    void setDeserializerCache(DeserializerCache cache) {
        this.globalDeserializerCache = cache;
        this.put(DeserializerCache.class, cache);
    }

    public TypedParserContextFactory getFactory() {
        return this.factory;
    }

    public Set<String> getTargetEventTypes() {
        return this.classTargetTypeMap.keySet();
    }

    @Override
    public void onMetadataReady() {
        super.onMetadataReady();
        this.bindDeserializers();
    }

    @Override
    public void onConstantPoolsReady() {
        this.constantPools.setReady();
    }

    @Override
    public MutableMetadataLookup getMetadataLookup() {
        return (MutableMetadataLookup)super.getMetadataLookup();
    }

    public static class DeserializerKey {
        private final long id;
        private final String name;
        private final String superType;
        private final List<String> fieldNames;
        private final Class<?> targetClass;

        public DeserializerKey(MetadataClass clz, Class<?> targetClass) {
            this.id = clz.getId();
            this.name = clz.getName();
            this.superType = clz.getSuperType();
            this.fieldNames = new ArrayList<String>(clz.getFields().size());
            for (MetadataField field : clz.getFields()) {
                this.fieldNames.add(field.getType().getName() + ":" + field.getName());
            }
            this.targetClass = targetClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeserializerKey that = (DeserializerKey)o;
            return this.id == that.id && Objects.equals(this.name, that.name) && Objects.equals(this.superType, that.superType) && Objects.equals(this.fieldNames, that.fieldNames) && Objects.equals(this.targetClass, that.targetClass);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.superType, this.fieldNames, this.targetClass);
        }

        public String toString() {
            return "DeserializerKey{id=" + this.id + ", name='" + this.name + '\'' + ", superType='" + this.superType + '\'' + ", fieldNames=" + this.fieldNames + ", targetClass=" + this.targetClass + '}';
        }
    }
}

