/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.ParsingUtils;
import io.jafar.parser.api.ConstantPool;
import io.jafar.parser.api.ConstantPools;
import io.jafar.parser.api.JafarSerializationException;
import io.jafar.parser.api.JfrField;
import io.jafar.parser.api.JfrIgnore;
import io.jafar.parser.api.MetadataLookup;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.TypedParserContext;
import io.jafar.parser.internal_api.ClassDefiner;
import io.jafar.parser.internal_api.ClassDefiners;
import io.jafar.parser.internal_api.Deserializer;
import io.jafar.parser.internal_api.FieldMapping;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.TypeSkipper;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataField;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CodeGenerator {
    private static final boolean LOGS_ENABLED = false;
    private static final Logger log = LoggerFactory.getLogger(CodeGenerator.class);
    private static final AtomicLong CLASS_COUNTER = new AtomicLong(0L);

    CodeGenerator() {
    }

    private static void addLog(MethodVisitor mv, String msg) {
    }

    private static void addLogIntWithMsg(MethodVisitor mv, String msg) {
    }

    static void handleFieldRef(ClassVisitor cv, String clzName, long typeId, boolean isArray, Class<?> fldType, String fldName, FieldMapping mapping, boolean generateRefField, MetadataField originalField) {
        if (fldType == null && !mapping.raw()) {
            return;
        }
        clzName = clzName.replace('.', '/');
        String fldRefName = fldName + "_ref";
        if (generateRefField) {
            cv.visitField(18, fldRefName, (isArray ? "[" : "") + "J", null, null).visitEnd();
        }
        if (mapping.raw()) {
            assert (!isArray);
            MethodVisitor mv = cv.visitMethod(17, mapping.method(), "()J", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, clzName, fldRefName, "J");
            mv.visitInsn(173);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            return;
        }
        String fldCpName = fldName + "_cp";
        String mthdCpName = fldCpName + "$get";
        cv.visitField(2, fldCpName, Type.getDescriptor(ConstantPool.class), null, null).visitEnd();
        MethodVisitor mv = cv.visitMethod(2, mthdCpName, Type.getMethodDescriptor((Type)Type.getType(ConstantPool.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        Label l = new Label();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, clzName, fldCpName, Type.getDescriptor(ConstantPool.class));
        mv.visitInsn(89);
        mv.visitJumpInsn(199, l);
        mv.visitInsn(87);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, clzName, "context", Type.getDescriptor(TypedParserContext.class));
        mv.visitMethodInsn(182, Type.getInternalName(TypedParserContext.class), "getConstantPools", Type.getMethodDescriptor((Type)Type.getType(ConstantPools.class), (Type[])new Type[0]), false);
        mv.visitLdcInsn((Object)typeId);
        mv.visitMethodInsn(185, Type.getInternalName(ConstantPools.class), "getConstantPool", Type.getMethodDescriptor((Type)Type.getType(ConstantPool.class), (Type[])new Type[]{Type.LONG_TYPE}), true);
        mv.visitInsn(90);
        mv.visitFieldInsn(181, clzName, fldCpName, Type.getDescriptor(ConstantPool.class));
        mv.visitInsn(176);
        mv.visitLabel(l);
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        mv = cv.visitMethod(17, mapping.method(), "()" + (isArray ? "[" : "") + Type.getDescriptor(fldType), null, null);
        mv.visitCode();
        Label cpNonNull = new Label();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, clzName, mthdCpName, Type.getMethodDescriptor((Type)Type.getType(ConstantPool.class), (Type[])new Type[0]), false);
        mv.visitInsn(89);
        mv.visitVarInsn(58, 1);
        mv.visitJumpInsn(199, cpNonNull);
        if (isArray) {
            mv.visitLdcInsn((Object)0);
            mv.visitTypeInsn(189, Type.getInternalName(fldType));
        } else {
            mv.visitInsn(1);
        }
        mv.visitInsn(176);
        mv.visitLabel(cpNonNull);
        mv.visitVarInsn(25, 0);
        if (isArray) {
            mv.visitFieldInsn(180, clzName, fldRefName, "[" + Type.LONG_TYPE.getDescriptor());
            mv.visitInsn(89);
            mv.visitVarInsn(58, 2);
            mv.visitInsn(190);
            mv.visitInsn(89);
            mv.visitVarInsn(54, 3);
            mv.visitTypeInsn(189, Type.getInternalName(fldType));
            mv.visitLdcInsn((Object)0);
            mv.visitVarInsn(54, 4);
            Label l1 = new Label();
            Label l2 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(21, 3);
            mv.visitVarInsn(21, 4);
            mv.visitJumpInsn(159, l2);
            mv.visitInsn(89);
            mv.visitVarInsn(21, 4);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 1);
            mv.visitInsn(95);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(95);
            mv.visitInsn(47);
            mv.visitMethodInsn(185, Type.getInternalName(ConstantPool.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.LONG_TYPE}), true);
            mv.visitTypeInsn(192, Type.getInternalName(fldType));
            mv.visitInsn(83);
            mv.visitIincInsn(4, 1);
            mv.visitJumpInsn(167, l1);
            mv.visitLabel(l2);
        } else {
            mv.visitInsn(87);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, clzName, fldRefName, Type.LONG_TYPE.getDescriptor());
            mv.visitMethodInsn(185, Type.getInternalName(ConstantPool.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.LONG_TYPE}), true);
            mv.visitTypeInsn(192, Type.getInternalName(fldType));
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static void handleField(ClassVisitor cv, String clzName, boolean isArray, Class<?> fldType, String fieldName, String methodName) {
        if (fldType == null) {
            return;
        }
        String fldDescriptor = (isArray ? "[" : "") + Type.getDescriptor(fldType);
        cv.visitField(18, fieldName, fldDescriptor, null, null).visitEnd();
        MethodVisitor mv = cv.visitMethod(17, methodName, "()" + (isArray ? "[" : "") + Type.getDescriptor(fldType), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, clzName.replace('.', '/'), fieldName, fldDescriptor);
        if (isArray) {
            mv.visitInsn(176);
        } else {
            mv.visitInsn(Type.getType(fldType).getOpcode(172));
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static void addFieldSkipper(MethodVisitor mv, MetadataField fld, int streamIdx, VarIndexTracker varTracker) {
        if (fld.hasConstantPool()) {
            if (fld.getDimension() > 0) {
                CodeGenerator.skipArrayRef(varTracker, mv);
            } else {
                CodeGenerator.skipSimpleRef(mv);
            }
        } else if (fld.getDimension() > 0) {
            CodeGenerator.skipArrayField(fld, streamIdx, varTracker, mv);
        } else {
            CodeGenerator.skipSimpleField(fld.getType(), streamIdx, varTracker, false, mv);
        }
    }

    static void addFieldLoader(MethodVisitor mv, MetadataField fld, String className, int streamIdx, int metadataIdx, int lastVarIdx, TypedParserContext context) {
        if (fld.hasConstantPool()) {
            if (fld.getDimension() > 0) {
                CodeGenerator.handleArrayRef(fld, className, metadataIdx, mv);
            } else {
                CodeGenerator.handleSimpleRef(fld, className, mv);
            }
        } else if (fld.getDimension() > 0) {
            CodeGenerator.handleArrayField(fld, className, streamIdx, metadataIdx, lastVarIdx, context, mv);
        } else {
            CodeGenerator.handleSimpleField(fld, className, metadataIdx, lastVarIdx, context, mv);
        }
    }

    private static void skipArrayRef(VarIndexTracker varTracker, MethodVisitor mv) {
        int arraySizeIdx = varTracker.allocate();
        Label l1 = new Label();
        Label l2 = new Label();
        Label l3 = new Label();
        mv.visitInsn(89);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(136);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitJumpInsn(153, l2);
        mv.visitLabel(l1);
        mv.visitInsn(89);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(88);
        mv.visitVarInsn(21, arraySizeIdx);
        mv.visitLdcInsn((Object)1);
        mv.visitInsn(100);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitJumpInsn(154, l1);
        mv.visitInsn(87);
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(87);
        mv.visitLabel(l3);
    }

    private static void handleArrayRef(MetadataField fld, String className, int lastVarIdx, MethodVisitor mv) {
        int arrayCounterIdx = lastVarIdx + 1;
        int arraySizeIdx = arrayCounterIdx + 1;
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(136);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitIntInsn(188, 11);
        mv.visitLdcInsn((Object)0);
        mv.visitVarInsn(54, arrayCounterIdx);
        mv.visitLabel(l1);
        mv.visitVarInsn(21, arraySizeIdx);
        mv.visitVarInsn(21, arrayCounterIdx);
        mv.visitJumpInsn(159, l2);
        mv.visitInsn(89);
        mv.visitVarInsn(21, arrayCounterIdx);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(80);
        mv.visitIincInsn(arrayCounterIdx, 1);
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l2);
        mv.visitFieldInsn(181, className, fld.getName() + "_ref", "[" + Type.LONG_TYPE.getDescriptor());
    }

    private static void skipSimpleRef(MethodVisitor mv) {
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(88);
    }

    private static void handleSimpleRef(MetadataField fld, String className, MethodVisitor mv) {
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitFieldInsn(181, className, fld.getName() + "_ref", Type.LONG_TYPE.getDescriptor());
    }

    private static void skipArrayField(MetadataField fld, int streamIdx, VarIndexTracker varTracker, MethodVisitor mv) {
        String fldTypeName = fld.getType().getName();
        int arraySizeIdx = varTracker.allocate();
        Type fldType = null;
        Type dataType = null;
        switch (fldTypeName) {
            case "byte": 
            case "boolean": {
                fldType = fldTypeName.equals("byte") ? Type.BYTE_TYPE : Type.BOOLEAN_TYPE;
                dataType = Type.BYTE_TYPE;
                break;
            }
            case "short": 
            case "char": 
            case "int": 
            case "long": {
                dataType = Type.LONG_TYPE;
                switch (fldTypeName) {
                    case "short": {
                        fldType = Type.SHORT_TYPE;
                        break;
                    }
                    case "char": {
                        fldType = Type.CHAR_TYPE;
                        break;
                    }
                    case "int": {
                        fldType = Type.INT_TYPE;
                        break;
                    }
                    case "long": {
                        fldType = Type.LONG_TYPE;
                    }
                }
                break;
            }
            case "float": {
                dataType = Type.FLOAT_TYPE;
                fldType = Type.FLOAT_TYPE;
                break;
            }
            case "double": {
                dataType = Type.DOUBLE_TYPE;
                fldType = Type.DOUBLE_TYPE;
            }
        }
        if (fldType != null) {
            CodeGenerator.skipPrimitiveArray(dataType, arraySizeIdx, mv);
        } else if (fldTypeName.equals("java.lang.String")) {
            CodeGenerator.skipStringArray(arraySizeIdx, mv);
        } else {
            CodeGenerator.skipObjectArray(fld.getType(), arraySizeIdx, streamIdx, varTracker, false, mv);
        }
    }

    private static void skipPrimitiveArray(Type dataType, int arraySizeIdx, MethodVisitor mv) {
        String operation = CodeGenerator.getPrimitiveReadOperation(dataType);
        Label l1 = new Label();
        Label l2 = new Label();
        Label l3 = new Label();
        mv.visitInsn(89);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(136);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitJumpInsn(153, l2);
        mv.visitLabel(l1);
        mv.visitInsn(89);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), operation, Type.getMethodDescriptor((Type)dataType, (Type[])new Type[0]), false);
        mv.visitInsn(dataType.getSize() == 2 ? 88 : 87);
        mv.visitVarInsn(21, arraySizeIdx);
        mv.visitLdcInsn((Object)1);
        mv.visitInsn(100);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitJumpInsn(154, l1);
        mv.visitInsn(87);
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(87);
        mv.visitLabel(l3);
    }

    private static void skipStringArray(int arraySizeIdx, MethodVisitor mv) {
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitInsn(89);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(136);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitJumpInsn(153, l2);
        mv.visitLabel(l1);
        mv.visitInsn(89);
        mv.visitMethodInsn(184, Type.getInternalName(ParsingUtils.class), "skipUTF8", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(RecordingStream.class)}), false);
        mv.visitVarInsn(21, arraySizeIdx);
        mv.visitLdcInsn((Object)1);
        mv.visitInsn(100);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitJumpInsn(154, l1);
        mv.visitLabel(l2);
        mv.visitInsn(87);
    }

    private static void skipObjectArray(MetadataClass fldType, int arraySizeIdx, int streamIdx, VarIndexTracker varTracker, boolean keepStream, MethodVisitor mv) {
        Label l1 = new Label();
        Label l2 = new Label();
        Label l3 = new Label();
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(136);
        CodeGenerator.addLogIntWithMsg(mv, "Array size: ");
        mv.visitInsn(89);
        mv.visitJumpInsn(153, l2);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitVarInsn(25, streamIdx);
        mv.visitLabel(l1);
        CodeGenerator.skipSimpleField(fldType, streamIdx, varTracker, true, mv);
        mv.visitIincInsn(arraySizeIdx, -1);
        mv.visitVarInsn(21, arraySizeIdx);
        mv.visitJumpInsn(154, l1);
        if (!keepStream) {
            mv.visitInsn(87);
        }
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(87);
        mv.visitLabel(l3);
    }

    private static void skipSimpleField(MetadataClass fldType, int streamIdx, VarIndexTracker varTracker, boolean keepStream, MethodVisitor mv) {
        String fldTypeName = fldType.getName();
        switch (fldTypeName) {
            case "byte": 
            case "boolean": {
                if (keepStream) {
                    mv.visitInsn(89);
                }
                mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "read", Type.getMethodDescriptor((Type)Type.BYTE_TYPE, (Type[])new Type[0]), false);
                mv.visitInsn(87);
                return;
            }
            case "short": 
            case "char": 
            case "int": 
            case "long": {
                if (keepStream) {
                    mv.visitInsn(89);
                }
                mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
                mv.visitInsn(88);
                return;
            }
            case "float": {
                if (keepStream) {
                    mv.visitInsn(89);
                }
                mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readFloat", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[0]), false);
                mv.visitInsn(87);
                return;
            }
            case "double": {
                if (keepStream) {
                    mv.visitInsn(89);
                }
                mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readDouble", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[0]), false);
                mv.visitInsn(88);
                return;
            }
            case "java.lang.String": {
                if (keepStream) {
                    mv.visitInsn(89);
                }
                mv.visitMethodInsn(184, Type.getInternalName(ParsingUtils.class), "skipUTF8", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(RecordingStream.class)}), false);
                return;
            }
        }
        for (MetadataField fld : fldType.getFields()) {
            mv.visitInsn(89);
            CodeGenerator.addFieldSkipper(mv, fld, streamIdx, varTracker);
        }
        if (!keepStream) {
            mv.visitInsn(87);
        }
    }

    private static void handleArrayField(MetadataField fld, String className, int streamIdx, int metadataIdx, int lastVarIdx, TypedParserContext context, MethodVisitor mv) {
        int arraySizeIdx;
        int arrayCounterIdx = lastVarIdx + 1;
        lastVarIdx = arraySizeIdx = arrayCounterIdx + 1;
        String fldTypeName = fld.getType().getName();
        Type fldType = null;
        Type dataType = null;
        int arrayOpcode = 0;
        switch (fldTypeName) {
            case "byte": 
            case "boolean": {
                fldType = fldTypeName.equals("byte") ? Type.BYTE_TYPE : Type.BOOLEAN_TYPE;
                arrayOpcode = fldTypeName.equals("byte") ? 8 : 4;
                dataType = Type.BYTE_TYPE;
                break;
            }
            case "short": 
            case "char": 
            case "int": 
            case "long": {
                dataType = Type.LONG_TYPE;
                switch (fldTypeName) {
                    case "short": {
                        fldType = Type.SHORT_TYPE;
                        arrayOpcode = 9;
                        break;
                    }
                    case "char": {
                        fldType = Type.CHAR_TYPE;
                        arrayOpcode = 5;
                        break;
                    }
                    case "int": {
                        fldType = Type.INT_TYPE;
                        arrayOpcode = 10;
                        break;
                    }
                    case "long": {
                        fldType = Type.LONG_TYPE;
                        arrayOpcode = 11;
                    }
                }
                break;
            }
            case "float": {
                dataType = Type.FLOAT_TYPE;
                fldType = Type.FLOAT_TYPE;
                arrayOpcode = 6;
                break;
            }
            case "double": {
                dataType = Type.DOUBLE_TYPE;
                fldType = Type.DOUBLE_TYPE;
                arrayOpcode = 7;
            }
        }
        if (fldType != null) {
            CodeGenerator.readIntoPrimitiveArray(mv, className, fld.getName(), fldType, arrayOpcode, dataType, streamIdx, arraySizeIdx, arrayCounterIdx);
        } else if (fldTypeName.equals("java.lang.String")) {
            CodeGenerator.readIntoStringArray(className, fld.getName(), streamIdx, arraySizeIdx, arrayCounterIdx, mv);
        } else {
            Class<?> fldClz = context.getClassTargetType(fld.getType().getName());
            if (fldClz == null) {
                throw new RuntimeException("No class found for type: " + fld.getType().getName());
            }
            CodeGenerator.readIntoObjectArray(className, fld.getName(), fld.getType(), Type.getType(fldClz), fldClz, streamIdx, arraySizeIdx, arrayCounterIdx, metadataIdx, lastVarIdx, mv);
        }
    }

    private static void readIntoPrimitiveArray(MethodVisitor mv, String className, String fldName, Type fldType, int arrayType, Type dataType, int streamIdx, int arraySizeIdx, int arrayCounterIdx) {
        String operation = CodeGenerator.getPrimitiveReadOperation(fldType);
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(136);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitIntInsn(188, arrayType);
        mv.visitLdcInsn((Object)0);
        mv.visitVarInsn(54, arrayCounterIdx);
        mv.visitLabel(l1);
        mv.visitVarInsn(21, arraySizeIdx);
        mv.visitVarInsn(21, arrayCounterIdx);
        mv.visitJumpInsn(159, l2);
        mv.visitInsn(89);
        mv.visitVarInsn(21, arrayCounterIdx);
        mv.visitVarInsn(25, streamIdx);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), operation, Type.getMethodDescriptor((Type)dataType, (Type[])new Type[0]), false);
        if (dataType.getSort() == 7 && fldType.getSort() != 7) {
            mv.visitInsn(136);
        }
        mv.visitInsn(fldType.getOpcode(79));
        mv.visitIincInsn(arrayCounterIdx, 1);
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l2);
        mv.visitFieldInsn(181, className, fldName, "[" + fldType.getDescriptor());
    }

    private static void readIntoStringArray(String className, String fldName, int streamIdx, int arraySizeIdx, int arrayCounterIdx, MethodVisitor mv) {
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(136);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitTypeInsn(189, Type.getType(String.class).getInternalName());
        mv.visitLdcInsn((Object)0);
        mv.visitVarInsn(54, arrayCounterIdx);
        mv.visitLabel(l1);
        mv.visitVarInsn(21, arraySizeIdx);
        mv.visitVarInsn(21, arrayCounterIdx);
        mv.visitJumpInsn(159, l2);
        mv.visitInsn(89);
        mv.visitVarInsn(21, arrayCounterIdx);
        mv.visitVarInsn(25, streamIdx);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readUTF8", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
        mv.visitInsn(83);
        mv.visitIincInsn(arrayCounterIdx, 1);
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l2);
        mv.visitFieldInsn(181, className, fldName, "[" + Type.getType(String.class).getDescriptor());
    }

    private static void readIntoObjectArray(String className, String fldName, MetadataClass fldClassType, Type fldType, Class<?> fldClz, int streamIdx, int arraySizeIdx, int arrayCounterIdx, int metadataIdx, int lastVarIdx, MethodVisitor mv) {
        int deserializerIdx = lastVarIdx + 1;
        mv.visitVarInsn(25, metadataIdx);
        mv.visitLdcInsn((Object)fldClassType.getId());
        mv.visitMethodInsn(185, Type.getInternalName(MetadataLookup.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(MetadataClass.class), (Type[])new Type[]{Type.LONG_TYPE}), true);
        mv.visitMethodInsn(182, Type.getInternalName(MetadataClass.class), "getDeserializer", Type.getMethodDescriptor((Type)Type.getType(Deserializer.class), (Type[])new Type[0]), false);
        mv.visitVarInsn(58, deserializerIdx);
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(136);
        mv.visitInsn(89);
        mv.visitVarInsn(54, arraySizeIdx);
        mv.visitTypeInsn(189, fldType.getInternalName());
        mv.visitLdcInsn((Object)0);
        mv.visitVarInsn(54, arrayCounterIdx);
        mv.visitLabel(l1);
        mv.visitVarInsn(21, arraySizeIdx);
        mv.visitJumpInsn(153, l2);
        mv.visitInsn(89);
        mv.visitVarInsn(21, arrayCounterIdx);
        mv.visitVarInsn(25, deserializerIdx);
        mv.visitVarInsn(25, streamIdx);
        mv.visitMethodInsn(182, Type.getInternalName(Deserializer.class), "deserialize", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(RecordingStream.class)}), false);
        mv.visitTypeInsn(192, fldType.getInternalName());
        mv.visitInsn(83);
        mv.visitIincInsn(arrayCounterIdx, 1);
        mv.visitIincInsn(arraySizeIdx, -1);
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l2);
        mv.visitFieldInsn(181, className, fldName, "[" + fldType.getDescriptor());
    }

    private static String getPrimitiveReadOperation(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 3: {
                return "read";
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                return "readVarint";
            }
            case 6: {
                return "readFloat";
            }
            case 8: {
                return "readDouble";
            }
        }
        throw new RuntimeException("Unexpected type: " + type.getDescriptor());
    }

    private static void handleSimpleField(MetadataField fld, String className, int metadataIdx, int lastVarIdx, TypedParserContext context, MethodVisitor mv) {
        String fldTypeName;
        switch (fldTypeName = fld.getType().getName()) {
            case "byte": 
            case "boolean": {
                mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "read", Type.getMethodDescriptor((Type)Type.BYTE_TYPE, (Type[])new Type[0]), false);
                mv.visitFieldInsn(181, className, fld.getName(), fld.getType().getName().equals("byte") ? Type.BYTE_TYPE.getDescriptor() : Type.BOOLEAN_TYPE.getDescriptor());
                break;
            }
            case "short": 
            case "char": 
            case "int": 
            case "long": {
                mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
                switch (fldTypeName) {
                    case "short": {
                        mv.visitInsn(136);
                        mv.visitFieldInsn(181, className, fld.getName(), Type.SHORT_TYPE.getDescriptor());
                        break;
                    }
                    case "char": {
                        mv.visitInsn(136);
                        mv.visitFieldInsn(181, className, fld.getName(), Type.CHAR_TYPE.getDescriptor());
                        break;
                    }
                    case "int": {
                        mv.visitInsn(136);
                        mv.visitFieldInsn(181, className, fld.getName(), Type.INT_TYPE.getDescriptor());
                        break;
                    }
                    case "long": {
                        mv.visitFieldInsn(181, className, fld.getName(), Type.LONG_TYPE.getDescriptor());
                    }
                }
                break;
            }
            case "float": {
                mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readFloat", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[0]), false);
                mv.visitFieldInsn(181, className, fld.getName(), Type.FLOAT_TYPE.getDescriptor());
                break;
            }
            case "double": {
                mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readDouble", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[0]), false);
                mv.visitFieldInsn(181, className, fld.getName(), Type.DOUBLE_TYPE.getDescriptor());
                break;
            }
            case "java.lang.String": {
                mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readUTF8", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
                mv.visitFieldInsn(181, className, fld.getName(), Type.getType(String.class).getDescriptor());
                break;
            }
            default: {
                Class<?> fldClz = context.getClassTargetType(fldTypeName);
                mv.visitVarInsn(25, metadataIdx);
                mv.visitLdcInsn((Object)fld.getType().getId());
                mv.visitMethodInsn(185, Type.getInternalName(MetadataLookup.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(MetadataClass.class), (Type[])new Type[]{Type.LONG_TYPE}), true);
                mv.visitMethodInsn(182, Type.getInternalName(MetadataClass.class), "getDeserializer", Type.getMethodDescriptor((Type)Type.getType(Deserializer.class), (Type[])new Type[0]), false);
                mv.visitInsn(95);
                mv.visitMethodInsn(182, Type.getInternalName(Deserializer.class), "deserialize", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(RecordingStream.class)}), false);
                mv.visitTypeInsn(192, Type.getInternalName(fldClz));
                mv.visitFieldInsn(181, className, fld.getName(), Type.getDescriptor(fldClz));
            }
        }
    }

    static void prepareConstructor(ClassVisitor cv, String clzName, MetadataClass clz, List<MetadataField> allFields, Set<MetadataField> appliedFields, TypedParserContext context) {
        int metadataIdx;
        MethodVisitor mv = cv.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(RecordingStream.class)}), null, null);
        mv.visitCode();
        int contextIdx = 2;
        int lastVarIdx = metadataIdx = 3;
        VarIndexTracker varTracker = new VarIndexTracker(metadataIdx);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "getContext", Type.getMethodDescriptor((Type)Type.getType(ParserContext.class), (Type[])new Type[0]), false);
        mv.visitTypeInsn(192, Type.getInternalName(TypedParserContext.class));
        mv.visitInsn(89);
        mv.visitVarInsn(58, contextIdx);
        mv.visitInsn(89);
        mv.visitMethodInsn(182, Type.getInternalName(TypedParserContext.class), "getMetadataLookup", Type.getMethodDescriptor((Type)Type.getType(MetadataLookup.class), (Type[])new Type[0]), false);
        mv.visitVarInsn(58, metadataIdx);
        mv.visitFieldInsn(181, clzName.replace('.', '/'), "context", Type.getDescriptor(TypedParserContext.class));
        for (MetadataField fld : allFields) {
            if (!appliedFields.contains(fld)) {
                mv.visitVarInsn(25, 1);
                CodeGenerator.addFieldSkipper(mv, fld, 1, varTracker);
                continue;
            }
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            CodeGenerator.addFieldLoader(mv, fld, clzName.replace('.', '/'), 1, metadataIdx, lastVarIdx, context);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static void prepareFactory(ClassVisitor cv, String clzInternalName) {
        MethodVisitor mv = cv.visitMethod(9, "create", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(RecordingStream.class)}), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, clzInternalName);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, clzInternalName, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(RecordingStream.class)}), false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static void prepareSkipHandler(ClassVisitor cv, MetadataClass clz) {
        MethodVisitor mv = cv.visitMethod(25, "skip", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(RecordingStream.class)}), null, null);
        mv.visitCode();
        int streamIdx = 0;
        VarIndexTracker varTracker = new VarIndexTracker(streamIdx);
        for (MetadataField fld : clz.getFields()) {
            mv.visitVarInsn(25, streamIdx);
            CodeGenerator.addFieldSkipper(mv, fld, streamIdx, varTracker);
        }
        mv.visitInsn(177);
        try {
            mv.visitMaxs(0, 0);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        mv.visitEnd();
    }

    static void prepareEmptyMethod(Method m, ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(1, m.getName(), Type.getMethodDescriptor((Method)m), null, null);
        mv.visitCode();
        Type retType = Type.getReturnType((Method)m);
        if (retType.getDimensions() > 1) {
            mv.visitInsn(1);
            mv.visitInsn(176);
        } else {
            switch (retType.getSort()) {
                case 0: {
                    mv.visitInsn(177);
                    break;
                }
                case 10: {
                    mv.visitInsn(1);
                    mv.visitInsn(176);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mv.visitLdcInsn((Object)0);
                    mv.visitInsn(172);
                    break;
                }
                case 7: {
                    mv.visitLdcInsn((Object)0L);
                    mv.visitInsn(173);
                    break;
                }
                case 6: {
                    mv.visitLdcInsn((Object)Float.valueOf(0.0f));
                    mv.visitInsn(174);
                    break;
                }
                case 8: {
                    mv.visitLdcInsn((Object)0.0);
                    mv.visitInsn(175);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported type: " + retType);
                }
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static <T> Deserializer<T> generateSimpleTypeDeserializer(MetadataClass clz, MetadataField singleField) {
        MetadataClass fieldType = singleField.getType();
        final Deserializer<?> fieldDeserializer = Deserializer.forType(fieldType);
        return new Deserializer<Object>(){

            @Override
            public void skip(RecordingStream stream) throws Exception {
                fieldDeserializer.skip(stream);
            }

            @Override
            public Object deserialize(RecordingStream stream) throws Exception {
                return fieldDeserializer.deserialize(stream);
            }
        };
    }

    public static <T> Deserializer<T> generateDeserializer(MetadataClass clz) throws JafarSerializationException {
        String[] stringArray;
        ParserContext ctx = clz.getContext();
        if (!(ctx instanceof TypedParserContext)) {
            throw new JafarSerializationException("Invalid parser context type", clz.getName());
        }
        TypedParserContext context = (TypedParserContext)ctx;
        Class<?> target = context.getClassTargetType(clz.getName());
        if (target != null && !target.isInterface()) {
            throw new RuntimeException("Unsupported type: " + clz.getName());
        }
        if (target == null) {
            if (clz.isSimpleType() && clz.getFields().size() == 1) {
                MetadataField singleField = clz.getFields().get(0);
                return CodeGenerator.generateSimpleTypeDeserializer(clz, singleField);
            }
            return new Deserializer.Generated(null, null, TypeSkipper.createSkipper(clz));
        }
        String origClzName = target != null ? target.getName() : clz.getName();
        String origSimpleName = target != null ? target.getSimpleName() : clz.getSimpleName();
        String clzName = CodeGenerator.class.getPackage().getName() + "." + (target != null ? target.getSimpleName() : clz.getSimpleName()) + "$" + CLASS_COUNTER.incrementAndGet();
        ClassWriter cw = new ClassWriter(3);
        String string = clzName.replace('.', '/');
        if (target != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = origClzName.replace('.', '/');
        } else {
            stringArray = null;
        }
        cw.visit(52, 17, string, null, "java/lang/Object", stringArray);
        cw.visitField(18, "context", Type.getDescriptor(TypedParserContext.class), null, null).visitEnd();
        HashMap<String, Set<FieldMapping>> fieldMap = new HashMap<String, Set<FieldMapping>>();
        Set<String> usedAttributes = CodeGenerator.collectUsedAttributes(target, fieldMap);
        ArrayDeque<MetadataClass> stack = new ArrayDeque<MetadataClass>();
        stack.push(clz);
        ArrayList<MetadataField> allFields = new ArrayList<MetadataField>();
        HashSet<MetadataField> appliedFields = new HashSet<MetadataField>();
        HashSet<String> generatedMethods = new HashSet<String>();
        while (!stack.isEmpty()) {
            MetadataClass current = (MetadataClass)stack.pop();
            if (target != null) {
                for (MetadataField metadataField : current.getFields()) {
                    Class<Object> fldClz;
                    String fldTypeNameResolved;
                    String fieldName = metadataField.getName().replace('.', '_');
                    allFields.add(metadataField);
                    if (usedAttributes.contains(fieldName)) {
                        appliedFields.add(metadataField);
                    }
                    MetadataClass fldType = metadataField.getType();
                    while (fldType.isSimpleType()) {
                        List<MetadataField> fl = fldType.getFields();
                        fldType = fl.get(0).getType();
                    }
                    switch (fldTypeNameResolved = fldType.getName()) {
                        case "byte": {
                            fldClz = Byte.TYPE;
                            break;
                        }
                        case "boolean": {
                            fldClz = Boolean.TYPE;
                            break;
                        }
                        case "short": {
                            fldClz = Short.TYPE;
                            break;
                        }
                        case "char": {
                            fldClz = Character.TYPE;
                            break;
                        }
                        case "int": {
                            fldClz = Integer.TYPE;
                            break;
                        }
                        case "long": {
                            fldClz = Long.TYPE;
                            break;
                        }
                        case "float": {
                            fldClz = Float.TYPE;
                            break;
                        }
                        case "double": {
                            fldClz = Double.TYPE;
                            break;
                        }
                        case "java.lang.String": {
                            fldClz = String.class;
                            break;
                        }
                        default: {
                            fldClz = context.getClassTargetType(fldTypeNameResolved);
                        }
                    }
                    boolean withConstantPool = metadataField.hasConstantPool();
                    HashSet<FieldMapping> mappings = (HashSet<FieldMapping>)fieldMap.get(fieldName);
                    if (mappings == null) {
                        mappings = new HashSet<FieldMapping>();
                        mappings.add(new FieldMapping(fieldName, false));
                    }
                    boolean generateRefField = true;
                    for (FieldMapping mapping : mappings) {
                        if (withConstantPool) {
                            boolean isArray;
                            boolean bl = isArray = metadataField.getDimension() > 0;
                            if (mapping.raw() && isArray) {
                                throw new RuntimeException("CP identity is not supported for arrays");
                            }
                            CodeGenerator.handleFieldRef((ClassVisitor)cw, clzName, metadataField.getType().getId(), isArray, fldClz, fieldName, mapping, generateRefField, metadataField);
                            generateRefField = false;
                        } else {
                            if (mapping.raw()) {
                                throw new RuntimeException("Field " + fieldName + " is not a constant pool entry");
                            }
                            CodeGenerator.handleField((ClassVisitor)cw, clzName, metadataField.getDimension() > 0, fldClz, fieldName, mapping.method());
                        }
                        generatedMethods.add(mapping.method());
                    }
                }
                CodeGenerator.prepareConstructor((ClassVisitor)cw, clzName, current, allFields, appliedFields, context);
            }
            CodeGenerator.prepareSkipHandler((ClassVisitor)cw, current);
        }
        if (target != null) {
            ArrayDeque checkClasses = new ArrayDeque();
            checkClasses.push(target);
            Class checkClass = null;
            while ((checkClass = (Class)checkClasses.poll()) != null) {
                for (Method m : checkClass.getMethods()) {
                    if (generatedMethods.contains(m.getName())) continue;
                    CodeGenerator.prepareEmptyMethod(m, (ClassVisitor)cw);
                }
                checkClasses.addAll(Arrays.asList(checkClass.getInterfaces()));
            }
            CodeGenerator.prepareFactory((ClassVisitor)cw, clzName.replace('.', '/'));
            cw.visitEnd();
        }
        byte[] classData = cw.toByteArray();
        Path debugPath = null;
        if (log.isDebugEnabled()) {
            debugPath = Paths.get("/tmp/" + origSimpleName + ".class", new String[0]);
            try {
                Files.write(debugPath, classData, new OpenOption[0]);
            }
            catch (Exception exception) {
                log.warn("Failed to write debug bytecode to {}", (Object)debugPath, (Object)exception);
                debugPath = null;
            }
        }
        try {
            Class<?> clazz;
            try {
                ClassDefiner definer = ClassDefiners.best();
                if (log.isDebugEnabled()) {
                    log.debug("Generating typed class using definer: {}", (Object)definer.name());
                }
                clazz = definer.define(classData, CodeGenerator.class);
            }
            catch (Throwable t) {
                throw new Exception(t);
            }
            MethodHandle createHandle = null;
            if (target != null) {
                Method mCreate = clazz.getDeclaredMethod("create", RecordingStream.class);
                mCreate.setAccessible(true);
                createHandle = MethodHandles.lookup().unreflect(mCreate);
            }
            Method mSkip = clazz.getDeclaredMethod("skip", RecordingStream.class);
            mSkip.setAccessible(true);
            MethodHandle skipHandle = MethodHandles.lookup().unreflect(mSkip);
            return new Deserializer.Generated(createHandle, skipHandle, TypeSkipper.createSkipper(clz));
        }
        catch (Exception exception) {
            log.error("Failed to load generated handler class for {}, bytecode can be found at {}", new Object[]{clz, debugPath, exception});
            if (debugPath != null) {
                throw JafarSerializationException.bytecodeGenerationFailed(clz.getName(), debugPath, exception);
            }
            throw JafarSerializationException.bytecodeGenerationFailed(clz.getName(), exception);
        }
    }

    private static Set<String> collectUsedAttributes(Class<?> clz, Map<String, Set<FieldMapping>> fieldToMethodMap) {
        HashSet<String> usedAttributes = new HashSet<String>();
        Class<?> c = clz;
        while (c != null) {
            usedAttributes.addAll(Arrays.stream(c.getMethods()).filter(m -> m.getAnnotation(JfrIgnore.class) == null).map(m -> {
                String name = m.getName();
                JfrField fieldAnnotation = m.getAnnotation(JfrField.class);
                if (fieldAnnotation != null) {
                    name = fieldAnnotation.value();
                    fieldToMethodMap.computeIfAbsent(name, k -> new HashSet()).add(new FieldMapping(m.getName(), fieldAnnotation.raw()));
                } else {
                    fieldToMethodMap.computeIfAbsent(name, k -> new HashSet()).add(new FieldMapping(m.getName(), false));
                }
                return name;
            }).collect(Collectors.toSet()));
            Class<?> superClz = c.getSuperclass();
            if (superClz != null && superClz.isInterface()) {
                c = superClz;
                continue;
            }
            c = null;
        }
        return usedAttributes;
    }

    private static final class VarIndexTracker {
        private int nextVarIdx;

        VarIndexTracker(int initialIdx) {
            this.nextVarIdx = initialIdx;
        }

        int allocate() {
            return ++this.nextVarIdx;
        }

        int current() {
            return this.nextVarIdx;
        }
    }
}

