/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.TypedParserContext;
import io.jafar.parser.internal_api.ChunkHeader;
import io.jafar.parser.internal_api.DeserializerCache;
import io.jafar.parser.internal_api.GlobalHandlerCache;
import io.jafar.parser.internal_api.MutableConstantPools;
import io.jafar.parser.internal_api.MutableMetadataLookup;
import io.jafar.parser.internal_api.ParserContextFactory;
import io.jafar.parser.internal_api.collections.IntObjectArrayMap;
import io.jafar.parser.internal_api.metadata.MetadataFingerprint;
import java.util.Set;

public final class TypedParserContextFactory
implements ParserContextFactory {
    private final IntObjectArrayMap<MutableMetadataLookup> chunkMetadataLookup = new IntObjectArrayMap();
    private final IntObjectArrayMap<MutableConstantPools> chunkConstantPools = new IntObjectArrayMap();
    private final IntObjectArrayMap<MetadataFingerprint> chunkFingerprints = new IntObjectArrayMap();

    @Override
    public ParserContext newContext(ParserContext parent, int chunkIndex) {
        if (parent == null) {
            return new TypedParserContext(null);
        }
        MutableMetadataLookup metadataLookup = this.chunkMetadataLookup.computeIfAbsent(chunkIndex, k -> new MutableMetadataLookup());
        MutableConstantPools constantPools = this.chunkConstantPools.computeIfAbsent(chunkIndex, k -> new MutableConstantPools());
        assert (parent instanceof TypedParserContext);
        TypedParserContext lazyParent = (TypedParserContext)parent;
        return new TypedParserContext(lazyParent.getTypeFilter(), chunkIndex, metadataLookup, constantPools, null, this);
    }

    @Override
    public void onChunkMetadata(ParserContext context, ChunkHeader header) {
        TypedParserContext typedCtx;
        if (context instanceof TypedParserContext && (typedCtx = (TypedParserContext)context).getDeserializerCache() == null) {
            this.resolveDeserializerCache(header.order, typedCtx.getMetadataLookup(), typedCtx);
        }
    }

    public void resolveDeserializerCache(int chunkIndex, MutableMetadataLookup metadata, TypedParserContext context) {
        Set<String> eventTypes = context.getTargetEventTypes();
        Set<Long> reachableTypes = MetadataFingerprint.computeReachableTypes(metadata, eventTypes);
        MetadataFingerprint fingerprint = MetadataFingerprint.compute(metadata, reachableTypes);
        this.chunkFingerprints.put(chunkIndex, fingerprint);
        DeserializerCache cache = GlobalHandlerCache.getInstance().getOrCreateCache(fingerprint);
        context.setDeserializerCache(cache);
    }

    public MetadataFingerprint getFingerprint(int chunkIndex) {
        return this.chunkFingerprints.get(chunkIndex);
    }
}

