/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.api;

import io.jafar.parser.api.ConstantPools;
import io.jafar.parser.api.MetadataLookup;
import io.jafar.parser.internal_api.MutableConstantPools;
import io.jafar.parser.internal_api.MutableMetadataLookup;
import io.jafar.utils.CachedStringParser;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ParserContext {
    private final ConcurrentMap<String, Object> storage = new ConcurrentHashMap<String, Object>();
    protected final MutableMetadataLookup metadataLookup;
    protected final MutableConstantPools constantPools;
    private long stringTypeId = -1L;
    private final int chunkIndex;
    public final byte[] byteBuffer = new byte[4096];
    public final char[] charBuffer = new char[4096];
    public final CachedStringParser.ByteArrayParser utf8Parser = CachedStringParser.byteParser();
    public final CachedStringParser.CharArrayParser charParser = CachedStringParser.charParser();

    public ParserContext(int chunkIndex) {
        this.chunkIndex = chunkIndex;
        this.metadataLookup = new MutableMetadataLookup();
        this.constantPools = new MutableConstantPools();
    }

    protected ParserContext(int chunkIndex, MutableMetadataLookup metadataLookup, MutableConstantPools constantPools) {
        this.chunkIndex = chunkIndex;
        this.metadataLookup = metadataLookup;
        this.constantPools = constantPools;
    }

    public final <T> T remove(Class<T> clz) {
        return clz.cast(this.storage.remove(clz.getName()));
    }

    public final <T> T remove(String key, Class<T> clz) {
        return clz.cast(this.storage.remove(key));
    }

    public final <T> void put(Class<T> clz, T value) {
        this.storage.put(clz.getName(), value);
    }

    public final <T> T get(Class<T> clz) {
        return clz.cast(this.storage.get(clz.getName()));
    }

    public final <T> void put(String key, Class<T> clz, T value) {
        this.storage.put(key, value);
    }

    public final <T> T get(String key, Class<T> clz) {
        return clz.cast(this.storage.get(key));
    }

    public void clear() {
        this.storage.clear();
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public long getStringTypeId() {
        return this.stringTypeId;
    }

    public void onMetadataReady() {
        this.stringTypeId = this.metadataLookup.getClass("java.lang.String").getId();
    }

    public abstract void onConstantPoolsReady();

    public MetadataLookup getMetadataLookup() {
        return this.metadataLookup;
    }

    public ConstantPools getConstantPools() {
        return this.constantPools;
    }
}

