/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn.calico;

import clocker.docker.entity.DockerHost;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.SdnProviderImpl;
import clocker.docker.networking.entity.sdn.calico.CalicoNetwork;
import clocker.docker.networking.entity.sdn.calico.CalicoNode;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.net.domain.IpPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalicoNetworkImpl
extends SdnProviderImpl
implements CalicoNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(CalicoNetwork.class);

    @Override
    public void init() {
        LOG.info("Starting Calico network id {}", (Object)this.getId());
        super.init();
        EntitySpec agentSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get((ConfigKey.HasConfigKey)CALICO_NODE_SPEC)));
        String calicoVersion = (String)this.config().get(CALICO_VERSION);
        if (Strings.isNonBlank((CharSequence)calicoVersion)) {
            agentSpec.configure(SoftwareProcess.SUGGESTED_VERSION, (Object)calicoVersion);
        }
        this.sensors().set((AttributeSensor)SDN_AGENT_SPEC, (Object)agentSpec);
    }

    public String getIconUrl() {
        return "classpath://calico-logo.png";
    }

    @Override
    public Collection<IpPermission> getIpPermissions(String source) {
        MutableList permissions = MutableList.of();
        return permissions;
    }

    @Override
    public InetAddress getNextAgentAddress(String agentId) {
        Entity agent = this.getManagementContext().getEntityManager().getEntity(agentId);
        String address = (String)((DockerHost)agent.sensors().get((AttributeSensor)CalicoNode.DOCKER_HOST)).sensors().get(Attributes.SUBNET_ADDRESS);
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException uhe) {
            throw Exceptions.propagate((Throwable)uhe);
        }
    }

    @Override
    public void addHost(DockerHost host) {
        SshMachineLocation machine = ((DockerHostLocation)host.getDynamicLocation()).getMachine();
        EntitySpec spec = (EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create((EntitySpec)((EntitySpec)this.sensors().get((AttributeSensor)SDN_AGENT_SPEC))).configure((ConfigKey.HasConfigKey)CalicoNode.SDN_PROVIDER, (Object)this)).configure((ConfigKey.HasConfigKey)CalicoNode.DOCKER_HOST, (Object)host)).configure(CalicoNode.ETCD_NODE, host.sensors().get(DockerHost.ETCD_NODE));
        CalicoNode agent = (CalicoNode)this.getAgents().addChild(spec);
        this.getAgents().addMember((Entity)agent);
        agent.start((Collection)ImmutableList.of((Object)machine));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added calico plugin {}", (Object)this, (Object)agent);
        }
    }

    @Override
    public void removeHost(DockerHost host) {
        SdnAgent agent = (SdnAgent)host.sensors().get(SdnAgent.SDN_AGENT);
        if (agent == null) {
            LOG.warn("{} cannot find calico service: {}", (Object)this, (Object)host);
            return;
        }
        agent.stop();
        this.getAgents().removeMember((Entity)agent);
        Entities.unmanage((Entity)agent);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} removed calico plugin {}", (Object)this, (Object)agent);
        }
    }
}

