/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.util.DockerCallbacks;
import clocker.docker.entity.util.DockerUtils;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.networking.entity.sdn.util.SdnAttributes;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.location.HasSubnetHostname;
import org.apache.brooklyn.core.location.SupportsPortForwarding;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.location.dynamic.DynamicLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsUtil;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.net.Protocol;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.ssh.IptablesCommands;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerLocation
extends SshMachineLocation
implements SupportsPortForwarding,
HasSubnetHostname,
DynamicLocation<DockerContainer, DockerContainerLocation> {
    private static final long serialVersionUID = 610389734596906782L;
    private static final Logger LOG = LoggerFactory.getLogger(DockerContainerLocation.class);
    @SetFromFlag(value="entity")
    private Entity entity;
    @SetFromFlag(value="machine")
    private JcloudsSshMachineLocation machine;
    @SetFromFlag(value="owner")
    private DockerContainer dockerContainer;
    private SshMachineLocation hostMachine;

    public void init() {
        super.init();
        this.hostMachine = ((DockerHostLocation)this.getOwner().getDockerHost().getDynamicLocation()).getMachine();
    }

    public LocationDefinition register() {
        throw new UnsupportedOperationException("Docker container location type definition cannot be persisted");
    }

    public void deregister() {
    }

    public DockerContainer getOwner() {
        return this.dockerContainer;
    }

    public JcloudsSshMachineLocation getMachine() {
        return this.machine;
    }

    private void addIptablesRule(Integer port) {
        if (((Boolean)this.getOwner().config().get(DockerHost.OPEN_IPTABLES)).booleanValue()) {
            LOG.debug("Using iptables to add access for TCP/{} to {}", (Object)port, (Object)this.hostMachine);
            ImmutableList commands = ImmutableList.of((Object)BashCommands.sudo((String)("iptables -L INPUT -nv | grep -q 'tcp dpt:" + port + "'")), (Object)String.format("if [ $? -eq 0 ]; then ( %s ); else ( %s ); fi", BashCommands.sudo((String)("iptables -C INPUT -s 0/0 -p tcp --dport " + port + " -j ACCEPT")), IptablesCommands.insertIptablesRule((IptablesCommands.Chain)IptablesCommands.Chain.INPUT, (Protocol)Protocol.TCP, (int)port, (IptablesCommands.Policy)IptablesCommands.Policy.ACCEPT)));
            int result = this.hostMachine.execCommands(String.format("Open iptables TCP/%d", port), (List)commands);
            if (result != 0) {
                String msg = String.format("Error running iptables update for TCP/%d on %s", port, this.hostMachine);
                LOG.error(msg);
                throw new RuntimeException(msg);
            }
        }
    }

    public int getMappedPort(int portNumber) {
        String containerId = this.getOwner().getContainerId();
        Map mapping = JcloudsUtil.dockerPortMappingsFor((JcloudsLocation)this.getOwner().getDockerHost().getJcloudsLocation(), (String)containerId);
        Integer publicPort = (Integer)mapping.get(portNumber);
        if (publicPort == null) {
            LOG.warn("Unable to map port {} for Container {}. Mappings: {}", new Object[]{portNumber, containerId, Joiner.on((String)", ").withKeyValueSeparator("=").join(mapping)});
            publicPort = -1;
        } else {
            LOG.debug("Docker mapped port {} to {} for Container {}", new Object[]{portNumber, publicPort, containerId});
        }
        return publicPort;
    }

    public boolean obtainSpecificPort(int portNumber) {
        boolean result = this.machine.obtainSpecificPort(portNumber);
        if (result) {
            int targetPort = this.getMappedPort(portNumber);
            this.mapPort(targetPort, portNumber);
            this.addIptablesRule(targetPort);
        }
        return result;
    }

    public int obtainPort(PortRange range) {
        int portNumber = this.machine.obtainPort(range);
        int targetPort = this.getMappedPort(portNumber);
        this.mapPort(targetPort, portNumber);
        this.addIptablesRule(targetPort);
        return portNumber;
    }

    private void mapPort(int hostPort, int containerPort) {
        String dockerHost = this.getAddress().getHostAddress();
        PortForwardManager portForwardManager = this.getOwner().getDockerHost().getSubnetTier().getPortForwardManager();
        portForwardManager.associate(dockerHost, HostAndPort.fromParts((String)dockerHost, (int)hostPort), (Location)this, containerPort);
    }

    public HostAndPort getSocketEndpointFor(Cidr accessor, int privatePort) {
        String dockerHost = this.getAddress().getHostAddress();
        int hostPort = this.getMappedPort(privatePort);
        return HostAndPort.fromParts((String)dockerHost, (int)hostPort);
    }

    public int execScript(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        Iterable filtered = Iterables.filter(commands, DockerCallbacks.FILTER);
        for (String commandString : filtered) {
            this.parseDockerCallback(commandString);
        }
        boolean entitySsh = Boolean.TRUE.equals(this.entity.config().get(DockerContainer.DOCKER_USE_SSH));
        boolean dockerSsh = Boolean.TRUE.equals(this.getOwner().config().get(DockerContainer.DOCKER_USE_SSH));
        if (entitySsh && dockerSsh) {
            return super.execScript(props, summaryForLogging, commands, env);
        }
        Map nonPortProps = Maps.filterKeys(props, (Predicate)Predicates.not((Predicate)Predicates.containsPattern((String)"port")));
        return this.hostMachine.execCommands(nonPortProps, summaryForLogging, this.getDockerExecCommand(commands, env));
    }

    public int execCommands(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        Iterable filtered = Iterables.filter(commands, DockerCallbacks.FILTER);
        for (String commandString : filtered) {
            this.parseDockerCallback(commandString);
        }
        boolean entitySsh = Boolean.TRUE.equals(this.entity.config().get(DockerContainer.DOCKER_USE_SSH));
        boolean dockerSsh = Boolean.TRUE.equals(this.getOwner().config().get(DockerContainer.DOCKER_USE_SSH));
        if (entitySsh && dockerSsh) {
            return super.execCommands(props, summaryForLogging, commands, env);
        }
        Map nonPortProps = Maps.filterKeys(props, (Predicate)Predicates.not((Predicate)Predicates.containsPattern((String)"port")));
        return this.hostMachine.execCommands(nonPortProps, summaryForLogging, this.getDockerExecCommand(commands, env));
    }

    private List<String> getDockerExecCommand(List<String> commands, Map<String, ?> env) {
        StringBuilder target = new StringBuilder("docker exec ").append(this.dockerContainer.getContainerId()).append(" /bin/bash -c '");
        Joiner.on((String)";").appendTo(target, Iterables.concat(this.getEnvironemnt(env), (Iterable)Iterables.transform(commands, (Function)StringFunctions.trim())));
        target.append("'");
        return ImmutableList.of((Object)target.toString());
    }

    private List<String> getEnvironemnt(Map<String, ?> env) {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, ?> entry : env.entrySet()) {
            String escaped = StringEscapes.BashStringEscapes.escapeLiteralForDoubleQuotedBash((String)entry.getValue().toString());
            result.add("export " + entry.getKey() + "=\"" + escaped + "\"");
        }
        return result;
    }

    private void parseDockerCallback(String commandString) {
        List tokens = DockerCallbacks.PARSER.splitToList((CharSequence)commandString);
        int callback = Iterables.indexOf((Iterable)tokens, (Predicate)Predicates.equalTo((Object)"docker-host-callback"));
        if (callback == -1) {
            LOG.warn("Could not find callback token: {}", (Object)commandString);
            throw new IllegalStateException("Cannot find callback token in command line");
        }
        String command = (String)tokens.get(callback + 1);
        LOG.info("Executing callback for {}: {}", (Object)this.getOwner(), (Object)command);
        if ("commit".equalsIgnoreCase(command)) {
            String containerId = this.getOwner().getContainerId();
            String imageName = (String)this.getOwner().sensors().get(DockerContainer.DOCKER_IMAGE_NAME);
            String output = this.getOwner().getDockerHost().runDockerCommandTimeout(String.format("commit %s %s", containerId, imageName), Duration.minutes((Number)20));
            String imageId = DockerUtils.checkId(output);
            this.getOwner().getRunningEntity().sensors().set(DockerContainer.DOCKER_IMAGE_ID, (Object)imageId);
            this.getOwner().sensors().set(DockerContainer.DOCKER_IMAGE_ID, (Object)imageId);
            ((DockerHostLocation)this.getOwner().getDockerHost().getDynamicLocation()).markImage(imageName);
        } else if ("push".equalsIgnoreCase(command)) {
            String imageName = (String)this.getOwner().sensors().get(DockerContainer.DOCKER_IMAGE_NAME);
            this.getOwner().getDockerHost().runDockerCommand(String.format("push %s", imageName));
        } else {
            LOG.warn("Unknown Docker host command: {}", (Object)command);
        }
    }

    public int copyTo(Map<String, ?> props, InputStream src, long filesize, String destination) {
        Map nonPortProps = Maps.filterKeys(props, (Predicate)Predicates.not((Predicate)Predicates.containsPattern((String)"port")));
        boolean entitySsh = Boolean.TRUE.equals(this.entity.config().get(DockerContainer.DOCKER_USE_SSH));
        boolean dockerSsh = Boolean.TRUE.equals(this.getOwner().config().get(DockerContainer.DOCKER_USE_SSH));
        if (entitySsh && dockerSsh) {
            return super.copyTo(nonPortProps, src, filesize, destination);
        }
        return this.copyTo(props, src, destination);
    }

    public int copyTo(Map<String, ?> props, InputStream src, String destination) {
        Map nonPortProps = Maps.filterKeys(props, (Predicate)Predicates.not((Predicate)Predicates.containsPattern((String)"port")));
        boolean entitySsh = Boolean.TRUE.equals(this.entity.config().get(DockerContainer.DOCKER_USE_SSH));
        boolean dockerSsh = Boolean.TRUE.equals(this.getOwner().config().get(DockerContainer.DOCKER_USE_SSH));
        if (entitySsh && dockerSsh) {
            return super.copyTo(nonPortProps, src, destination);
        }
        try {
            String tmp = Os.mergePaths((String[])new String[]{"/tmp", Joiner.on((char)'-').join((Object)this.dockerContainer.getId(), (Object)Urls.getBasename((String)destination), new Object[]{Strings.makeRandomId((int)4)})});
            this.hostMachine.copyTo(nonPortProps, src, tmp);
            this.copyFile(tmp, destination);
            src.close();
            return 0;
        }
        catch (IOException ioe) {
            throw Exceptions.propagate((Throwable)ioe);
        }
    }

    public int copyTo(Map<String, ?> props, File src, String destination) {
        Map nonPortProps = Maps.filterKeys(props, (Predicate)Predicates.not((Predicate)Predicates.containsPattern((String)"port")));
        boolean entitySsh = Boolean.TRUE.equals(this.entity.config().get(DockerContainer.DOCKER_USE_SSH));
        boolean dockerSsh = Boolean.TRUE.equals(this.getOwner().config().get(DockerContainer.DOCKER_USE_SSH));
        if (entitySsh && dockerSsh) {
            return super.copyTo(nonPortProps, src, destination);
        }
        String tmp = Os.mergePaths((String[])new String[]{"/tmp", Joiner.on((char)'-').join((Object)this.dockerContainer.getId(), (Object)Urls.getBasename((String)destination), new Object[]{Strings.makeRandomId((int)4)})});
        this.hostMachine.copyTo(nonPortProps, src, tmp);
        this.copyFile(tmp, destination);
        return 0;
    }

    private void copyFile(String src, String dst) {
        String cp = String.format("cp %s %s:%s", src, this.dockerContainer.getContainerId(), dst);
        String output = this.getOwner().getDockerHost().runDockerCommand(cp);
        LOG.info("Copied to {}:{} - result: {}", new Object[]{this.dockerContainer.getContainerId(), dst, output});
    }

    public int copyFrom(Map<String, ?> props, String remote, String local) {
        Map nonPortProps = Maps.filterKeys(props, (Predicate)Predicates.not((Predicate)Predicates.containsPattern((String)"port")));
        boolean entitySsh = Boolean.TRUE.equals(this.entity.config().get(DockerContainer.DOCKER_USE_SSH));
        boolean dockerSsh = Boolean.TRUE.equals(this.getOwner().config().get(DockerContainer.DOCKER_USE_SSH));
        if (entitySsh && dockerSsh) {
            return super.copyFrom(nonPortProps, remote, local);
        }
        String tmp = Os.mergePaths((String[])new String[]{"/tmp", Joiner.on((char)'-').join((Object)this.dockerContainer.getId(), (Object)Urls.getBasename((String)local), new Object[]{Strings.makeRandomId((int)4)})});
        String cp = String.format("cp %s:%s %s", this.dockerContainer.getContainerId(), remote, tmp);
        String output = this.getOwner().getDockerHost().runDockerCommand(cp);
        this.hostMachine.copyFrom(nonPortProps, tmp, local);
        LOG.info("Copying from {}:{} to {} - result: {}", new Object[]{this.dockerContainer.getContainerId(), remote, local, output});
        return 0;
    }

    public void releasePort(int portNumber) {
        this.machine.releasePort(portNumber);
    }

    public InetAddress getAddress() {
        return this.hostMachine.getAddress();
    }

    public void close() throws IOException {
        LOG.debug("Close called on Docker container {}: {}", (Object)this.machine, (Object)this);
        try {
            this.machine.close();
            if (((Boolean)this.dockerContainer.sensors().get(DockerContainer.SERVICE_UP)).booleanValue()) {
                LOG.info("Stopping Docker container entity for {}: {}", (Object)this, (Object)this.dockerContainer);
                this.dockerContainer.stop();
            }
            LOG.info("Docker container closed: {}", (Object)this);
        }
        catch (Exception e) {
            LOG.warn("Error closing Docker container {}: {}", (Object)this, (Object)e.getMessage());
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Objects.ToStringHelper string() {
        return super.string().add("entity", (Object)this.entity).add("machine", (Object)this.machine).add("owner", (Object)this.dockerContainer);
    }

    public String getSubnetHostname() {
        return this.dockerContainer.getHostname();
    }

    public Set<String> getPrivateAddresses() {
        if (((Boolean)this.dockerContainer.config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
            return ImmutableSet.copyOf((Collection)((Collection)this.dockerContainer.sensors().get(DockerContainer.CONTAINER_ADDRESSES)));
        }
        return ImmutableSet.of((Object)this.getSubnetIp());
    }

    public String getSubnetIp() {
        String containerAddress = (String)this.dockerContainer.sensors().get(Attributes.SUBNET_ADDRESS);
        if (Strings.isEmpty((CharSequence)containerAddress)) {
            String containerId = (String)Preconditions.checkNotNull((Object)this.dockerContainer.getContainerId(), (Object)"containerId");
            containerAddress = this.dockerContainer.getDockerHost().runDockerCommand("inspect --format={{.NetworkSettings.IPAddress}} " + containerId).trim();
        }
        return containerAddress;
    }
}

