/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.container;

import brooklyn.networking.portforwarding.subnet.JcloudsPortforwardingSubnetLocation;
import brooklyn.networking.subnet.SubnetTier;
import clocker.docker.entity.DockerHost;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.entity.util.DockerUtils;
import clocker.docker.location.DockerContainerLocation;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.networking.entity.VirtualNetwork;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.SdnProvider;
import clocker.docker.networking.entity.sdn.util.SdnAttributes;
import clocker.docker.networking.entity.sdn.util.SdnUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.mgmt.LocationManager;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.location.dynamic.DynamicLocation;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.stock.BasicStartableImpl;
import org.apache.brooklyn.entity.stock.DelegateEntity;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.templates.PortableTemplateBuilder;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.docker.compute.options.DockerTemplateOptions;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerImpl
extends BasicStartableImpl
implements DockerContainer {
    private static final Logger LOG = LoggerFactory.getLogger(DockerContainer.class);
    private transient FunctionFeed status;

    public void init() {
        LOG.info("Starting Docker container id {}", (Object)this.getId());
        super.init();
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_CONTAINER_NAME);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_INFRASTRUCTURE);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_HOST);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)ENTITY);
    }

    public String getIconUrl() {
        return "classpath://container.png";
    }

    public String getDisplayName() {
        return String.format("Container (%s)", DockerUtils.getUniqueContainerName((Entity)this));
    }

    protected void connectSensors() {
        this.status = FunctionFeed.builder().entity((EntityLocal)this).period(Duration.seconds((Number)15)).poll((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig((AttributeSensor)DOCKER_CONTAINER_NAME).period(Duration.minutes((Number)1))).callable((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String containerId = DockerContainerImpl.this.getContainerId();
                if (containerId == null) {
                    return "";
                }
                String name = DockerContainerImpl.this.getDockerHost().runDockerCommand("inspect -f {{.Name}} " + containerId);
                return Strings.removeFromStart((String)name, (String)"/");
            }
        }).onFailureOrException(Functions.constant((Object)""))).poll((FunctionPollConfig)new FunctionPollConfig(SERVICE_UP).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String containerId = DockerContainerImpl.this.getContainerId();
                if (containerId == null) {
                    return false;
                }
                return Strings.isNonBlank((CharSequence)DockerContainerImpl.this.getDockerHost().runDockerCommand("inspect -f {{.Id}} " + containerId));
            }
        }).onFailureOrException(Functions.constant((Object)Boolean.FALSE))).poll((FunctionPollConfig)new FunctionPollConfig(CONTAINER_RUNNING).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String containerId = DockerContainerImpl.this.getContainerId();
                if (containerId == null) {
                    return false;
                }
                String running = DockerContainerImpl.this.getDockerHost().runDockerCommand("inspect -f {{.State.Running}} " + containerId);
                return Strings.isNonBlank((CharSequence)running) && Boolean.parseBoolean(Strings.trim((String)running));
            }
        }).onFailureOrException(Functions.constant((Object)Boolean.FALSE))).poll((FunctionPollConfig)new FunctionPollConfig(CONTAINER_PAUSED).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String containerId = DockerContainerImpl.this.getContainerId();
                if (containerId == null) {
                    return false;
                }
                String running = DockerContainerImpl.this.getDockerHost().runDockerCommand("inspect -f {{.State.Paused}} " + containerId);
                return Strings.isNonBlank((CharSequence)running) && Boolean.parseBoolean(Strings.trim((String)running));
            }
        }).onFailureOrException(Functions.constant((Object)Boolean.FALSE))).build();
    }

    public void disconnectSensors() {
        if (this.status != null) {
            this.status.destroy();
        }
    }

    @Override
    public Entity getRunningEntity() {
        return (Entity)this.sensors().get((AttributeSensor)ENTITY);
    }

    @Override
    public void setRunningEntity(Entity entity) {
        this.sensors().set((AttributeSensor)ENTITY, (Object)entity);
    }

    @Override
    public String getDockerContainerName() {
        return (String)this.sensors().get((AttributeSensor)DOCKER_CONTAINER_NAME);
    }

    @Override
    public String getContainerId() {
        return (String)this.sensors().get(DOCKER_CONTAINER_ID);
    }

    @Override
    public SshMachineLocation getMachine() {
        return (SshMachineLocation)this.sensors().get(SSH_MACHINE_LOCATION);
    }

    @Override
    public DockerHost getDockerHost() {
        return (DockerHost)this.config().get((ConfigKey.HasConfigKey)DOCKER_HOST);
    }

    public String getShortName() {
        return "Docker Container";
    }

    public DockerContainerLocation getDynamicLocation() {
        return (DockerContainerLocation)((Object)this.sensors().get(DYNAMIC_LOCATION));
    }

    public boolean isLocationAvailable() {
        return this.getDynamicLocation() != null;
    }

    @Override
    public void shutDown() {
        String dockerContainerName = (String)this.sensors().get(DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Stopping {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("kill " + this.getContainerId());
    }

    @Override
    public void pause() {
        String dockerContainerName = (String)this.sensors().get(DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Pausing {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("stop " + this.getContainerId());
    }

    @Override
    public void resume() {
        String dockerContainerName = (String)this.sensors().get(DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Resuming {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("start " + this.getContainerId());
    }

    private void removeContainer() {
        String dockerContainerName = (String)this.sensors().get(DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Removing {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("rm " + this.getContainerId());
    }

    private DockerTemplateOptions getDockerTemplateOptions() {
        List commands;
        MutableMap bindings;
        List exports;
        Integer memory;
        Entity entity = this.getRunningEntity();
        MutableMap entityFlags = MutableMap.copyOf((Map)((Map)entity.config().get((ConfigKey)SoftwareProcess.PROVISIONING_PROPERTIES)));
        DockerTemplateOptions options = new DockerTemplateOptions();
        Boolean useHostDns = (Boolean)Objects.firstNonNull((Object)entity.config().get(DOCKER_USE_HOST_DNS_NAME), (Object)Boolean.FALSE);
        String hostname = (String)this.getDockerHost().sensors().get(Attributes.HOSTNAME);
        String address = (String)this.getDockerHost().sensors().get(Attributes.ADDRESS);
        String container = DockerUtils.getUniqueContainerName(entity);
        String name = useHostDns == false || hostname.equalsIgnoreCase(address) ? container : hostname;
        options.hostname(name);
        options.nodeNames((Iterable)ImmutableList.of((Object)name));
        this.sensors().set((AttributeSensor)DOCKER_CONTAINER_NAME, (Object)name);
        entity.sensors().set((AttributeSensor)DOCKER_CONTAINER_NAME, (Object)name);
        LOG.debug("Container name set to {} for {}", (Object)name, (Object)entity);
        Integer cpuShares = (Integer)entity.config().get(DOCKER_CPU_SHARES);
        if (cpuShares == null) {
            cpuShares = (Integer)this.config().get(DOCKER_CPU_SHARES);
        }
        if (cpuShares != null) {
            TemplateBuilder template;
            Integer hostCores = ((DockerHostLocation)this.getDockerHost().getDynamicLocation()).getMachine().getMachineDetails().getHardwareDetails().getCpuCount();
            Integer minCores = (Integer)entity.config().get(JcloudsLocationConfig.MIN_CORES);
            if (minCores == null) {
                minCores = (Integer)entityFlags.get(JcloudsLocationConfig.MIN_CORES.getName());
            }
            if (minCores == null && (template = (TemplateBuilder)entityFlags.get(JcloudsLocationConfig.TEMPLATE_BUILDER.getName())) != null) {
                minCores = 0;
                for (Processor cpu : template.build().getHardware().getProcessors()) {
                    minCores = minCores + (int)cpu.getCores();
                }
            }
            if (minCores != null) {
                double ratio = (double)minCores.intValue() / (double)(hostCores != null ? hostCores : 1);
                LOG.debug("Cores: host {}, min {}, ratio {}", new Object[]{hostCores, minCores, ratio});
            }
        }
        if (cpuShares != null) {
            options.cpuShares(cpuShares);
        }
        if ((memory = (Integer)entity.config().get(DOCKER_MEMORY)) == null) {
            memory = (Integer)this.config().get(DOCKER_MEMORY);
        }
        if (memory != null) {
            TemplateBuilder template;
            Integer hostRam = ((DockerHostLocation)this.getDockerHost().getDynamicLocation()).getMachine().getMachineDetails().getHardwareDetails().getRam();
            Integer minRam = (Integer)entity.config().get(JcloudsLocationConfig.MIN_RAM);
            if (minRam == null) {
                minRam = (Integer)entityFlags.get(JcloudsLocationConfig.MIN_RAM.getName());
            }
            if (minRam == null && (template = (TemplateBuilder)entityFlags.get(JcloudsLocationConfig.TEMPLATE_BUILDER.getName())) != null) {
                minRam = template.build().getHardware().getRam();
            }
            if (minRam != null) {
                double ratio = (double)minRam.intValue() / (double)hostRam.intValue();
                LOG.debug("Memory: host {}, min {}, ratio {}", new Object[]{hostRam, minRam, ratio});
            }
        }
        if (memory != null) {
            options.memory(memory);
        }
        MutableMap volumes = MutableMap.copyOf((Map)((Map)this.getDockerHost().sensors().get(DockerHost.DOCKER_HOST_VOLUME_MAPPING)));
        Map mapping = (Map)entity.config().get(DockerHost.DOCKER_HOST_VOLUME_MAPPING);
        if (mapping != null) {
            for (String source : mapping.keySet()) {
                if (Urls.isUrlWithProtocol((String)source)) {
                    String path = this.getDockerHost().deployArchive(source);
                    volumes.put(path, mapping.get(source));
                    continue;
                }
                volumes.put(source, mapping.get(source));
            }
        }
        if ((exports = (List)entity.config().get(DockerContainer.DOCKER_CONTAINER_VOLUME_EXPORT)) != null) {
            for (String dir : exports) {
                volumes.put(dir, dir);
            }
        }
        this.sensors().set(DockerAttributes.DOCKER_VOLUME_MAPPING, (Object)volumes);
        entity.sensors().set(DockerAttributes.DOCKER_VOLUME_MAPPING, (Object)volumes);
        options.volumes((Map)volumes);
        List imports = (List)entity.config().get(DockerContainer.DOCKER_CONTAINER_VOLUMES_FROM);
        if (imports != null) {
            options.volumesFrom((Iterable)imports);
        }
        if ((bindings = MutableMap.copyOf((Map)((Map)entity.config().get(DockerAttributes.DOCKER_PORT_BINDINGS)))) == null || bindings.isEmpty()) {
            List entityPorts;
            bindings = MutableMap.of();
            List entityPortConfig = (List)entity.config().get(DockerAttributes.DOCKER_DIRECT_PORT_CONFIG);
            if (entityPortConfig != null) {
                for (PortAttributeSensorAndConfigKey key : entityPortConfig) {
                    Integer port;
                    PortRange range = (PortRange)entity.config().get((ConfigKey.HasConfigKey)key);
                    if (range == null || range.isEmpty() || (port = (Integer)range.iterator().next()) == null) continue;
                    bindings.put(port, port);
                }
            }
            if ((entityPorts = (List)entity.config().get(DockerAttributes.DOCKER_DIRECT_PORTS)) != null) {
                for (Integer port : entityPorts) {
                    bindings.put(port, port);
                }
            }
        }
        this.sensors().set(DockerAttributes.DOCKER_CONTAINER_PORT_BINDINGS, (Object)bindings);
        entity.sensors().set(DockerAttributes.DOCKER_CONTAINER_PORT_BINDINGS, (Object)bindings);
        if (bindings.size() > 0) {
            options.portBindings((Map)bindings);
        }
        MutableSet entityOpenPorts = MutableSet.copyOf(DockerUtils.getContainerPorts(entity));
        entityOpenPorts.addAll(DockerUtils.getOpenPorts(entity));
        options.inboundPorts(Ints.toArray((Collection)entityOpenPorts));
        if (!((Boolean)this.config().get(DockerContainer.DOCKER_USE_SSH)).booleanValue()) {
            entityOpenPorts.remove(22);
        }
        this.sensors().set(DockerAttributes.DOCKER_CONTAINER_OPEN_PORTS, (Object)ImmutableList.copyOf((Collection)entityOpenPorts));
        entity.sensors().set(DockerAttributes.DOCKER_CONTAINER_OPEN_PORTS, (Object)ImmutableList.copyOf((Collection)entityOpenPorts));
        MutableMap environment = MutableMap.of();
        environment.add((Map)this.config().get(DockerContainer.DOCKER_CONTAINER_ENVIRONMENT));
        environment.add((Map)entity.config().get(DockerContainer.DOCKER_CONTAINER_ENVIRONMENT));
        Map links = (Map)entity.config().get(DockerAttributes.DOCKER_LINKS);
        if (links != null && links.size() > 0) {
            LOG.debug("Found links: {}", (Object)links);
            MutableMap extraHosts = MutableMap.of();
            for (Map.Entry linked : links.entrySet()) {
                Map<String, Object> linkVars = DockerUtils.generateLinks(this.getRunningEntity(), (Entity)linked.getValue(), (String)linked.getKey());
                environment.add(linkVars);
                String targetAddress = DockerUtils.getTargetAddress(this.getRunningEntity(), (Entity)linked.getValue());
                extraHosts.put(linked.getKey(), targetAddress);
            }
            options.extraHosts((Map)extraHosts);
        }
        this.sensors().set(DockerContainer.DOCKER_CONTAINER_ENVIRONMENT, (Object)environment);
        entity.sensors().set(DockerContainer.DOCKER_CONTAINER_ENVIRONMENT, (Object)environment);
        MutableList env = MutableList.of();
        if (environment != null && !environment.isEmpty()) {
            for (Map.Entry entry : environment.entrySet()) {
                env.add((String)entry.getKey() + "=" + entry.getValue());
            }
        }
        options.env((Iterable)env);
        List entrypoint = (List)entity.config().get(DockerContainer.DOCKER_IMAGE_ENTRYPOINT);
        if (entrypoint != null && entrypoint.size() > 0) {
            options.entrypoint((Iterable)entrypoint);
            this.sensors().set(DockerAttributes.DOCKER_IMAGE_ENTRYPOINT, (Object)entrypoint);
            entity.sensors().set(DockerAttributes.DOCKER_IMAGE_ENTRYPOINT, (Object)entrypoint);
        }
        if ((commands = (List)entity.config().get(DockerContainer.DOCKER_IMAGE_COMMANDS)) != null && commands.size() > 0) {
            options.commands((Iterable)commands);
            this.sensors().set(DockerAttributes.DOCKER_IMAGE_COMMANDS, (Object)commands);
            entity.sensors().set(DockerAttributes.DOCKER_IMAGE_COMMANDS, (Object)commands);
        }
        Boolean privileged = (Boolean)entity.config().get(DockerContainer.PRIVILEGED);
        options.privileged(privileged.booleanValue());
        Boolean openStdin = (Boolean)entity.config().get(DockerContainer.INTERACTIVE);
        options.openStdin(openStdin.booleanValue());
        LOG.debug("Docker options for {}: {}", (Object)entity, (Object)options);
        options.overrideLoginPassword(this.getDockerHost().getLoginPassword());
        return options;
    }

    private InetAddress getSshHostAddress() {
        String address;
        DockerHost dockerHost = this.getDockerHost();
        OsDetails osDetails = ((DockerHostLocation)dockerHost.getDynamicLocation()).getMachine().getMachineDetails().getOsDetails();
        if (osDetails.isMac() && Strings.isNonBlank((CharSequence)(address = dockerHost.execCommand("boot2docker ip")))) {
            LOG.debug("The boot2docker IP address is {}", (Object)Strings.trim((String)address));
            try {
                return InetAddress.getByName(Strings.trim((String)address));
            }
            catch (UnknownHostException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        return ((DockerHostLocation)dockerHost.getDynamicLocation()).getMachine().getAddress();
    }

    public void configurePortBindings(DockerHost host, Entity entity) {
        Collection<IpPermission> ipPermissions = this.getIpPermissions(entity);
        if (ipPermissions.size() > 0) {
            LOG.debug("Adding security group entries for forwarded ports on {}: {}", (Object)entity, (Object)Iterables.toString(ipPermissions));
            host.addIpPermissions(ipPermissions);
        }
    }

    public void removePortBindings(DockerHost host, Entity entity) {
        Collection<IpPermission> ipPermissions = this.getIpPermissions(entity);
        if (ipPermissions.size() > 0) {
            LOG.debug("Removing security group entries for forwarded ports on {}: {}", (Object)entity, (Object)Iterables.toString(ipPermissions));
            host.removeIpPermissions(ipPermissions);
        }
    }

    public Collection<IpPermission> getIpPermissions(Entity entity) {
        Map bindings = (Map)entity.sensors().get(DockerAttributes.DOCKER_CONTAINER_PORT_BINDINGS);
        if (bindings.size() == 0) {
            return ImmutableList.of();
        }
        MutableList permissions = MutableList.of();
        for (Integer hostPort : bindings.keySet()) {
            IpPermission portAccess = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(hostPort.intValue()).toPort(hostPort.intValue()).cidrBlock(Cidr.UNIVERSAL.toString()).build();
            permissions.add(portAccess);
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerContainerLocation createLocation(Map flags) {
        DockerHost dockerHost = this.getDockerHost();
        DockerHostLocation host = (DockerHostLocation)dockerHost.getDynamicLocation();
        SubnetTier subnetTier = dockerHost.getSubnetTier();
        Entity entity = this.getRunningEntity();
        DockerTemplateOptions options = this.getDockerTemplateOptions();
        boolean useSsh = Boolean.TRUE.equals(this.config().get(DOCKER_USE_SSH)) && Boolean.TRUE.equals(entity.config().get(DOCKER_USE_SSH));
        MutableMap dockerFlags = MutableMap.builder().putAll(flags).put((Object)JcloudsLocationConfig.TEMPLATE_BUILDER, (Object)new PortableTemplateBuilder().options((TemplateOptions)options)).put((Object)JcloudsLocationConfig.IMAGE_ID, this.config().get((ConfigKey.HasConfigKey)DOCKER_IMAGE_ID)).put((Object)JcloudsLocationConfig.HARDWARE_ID, this.config().get((ConfigKey.HasConfigKey)DOCKER_HARDWARE_ID)).put((Object)JcloudsLocationConfig.LOGIN_USER, (Object)"root").put((Object)JcloudsLocationConfig.LOGIN_USER_PASSWORD, this.config().get(DOCKER_LOGIN_PASSWORD)).put((Object)CloudLocationConfig.WAIT_FOR_SSHABLE, (Object)useSsh).put((Object)JcloudsLocationConfig.INBOUND_PORTS, (Object)options.getInboundPorts()).put((Object)JcloudsLocation.USE_PORT_FORWARDING, (Object)true).put((Object)JcloudsLocation.PORT_FORWARDER, (Object)subnetTier.getPortForwarderExtension()).put((Object)JcloudsLocation.PORT_FORWARDING_MANAGER, (Object)subnetTier.getPortForwardManager()).put((Object)JcloudsPortforwardingSubnetLocation.PORT_FORWARDER, (Object)subnetTier.getPortForwarder()).put((Object)SubnetTier.SUBNET_CIDR, (Object)Cidr.CLASS_B).build();
        if (Boolean.TRUE.equals(entity.config().get(DockerAttributes.AUTO_CHECKPOINT_DOCKER_IMAGE_POST_INSTALL))) {
            dockerFlags.put(JcloudsLocationConfig.USER, "root");
            dockerFlags.put(JcloudsLocationConfig.PASSWORD, this.config().get(DOCKER_LOGIN_PASSWORD));
        }
        try {
            Object networks;
            if (((Boolean)this.config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
                networks = MutableList.of();
                Collection extra = (Collection)entity.config().get(SdnAttributes.NETWORK_LIST);
                if (((Boolean)entity.config().get(SdnAttributes.CREATE_APPLICATION_NETWORK)).booleanValue()) {
                    networks.add(entity.getApplicationId());
                }
                if (extra != null && extra.size() > 0) {
                    networks.addAll(extra);
                }
                if (networks.isEmpty()) {
                    throw new IllegalStateException("No networks configured for container");
                }
                networks = Lists.transform((List)networks, (Function)StringFunctions.toLowerCase());
                this.sensors().set(SdnAttributes.INITIAL_ATTACHED_NETWORK, networks.get(0));
                entity.sensors().set(SdnAttributes.INITIAL_ATTACHED_NETWORK, networks.get(0));
                this.sensors().set(SdnAttributes.ATTACHED_NETWORKS, networks);
                entity.sensors().set(SdnAttributes.ATTACHED_NETWORKS, networks);
            }
            networks = this.getDockerHost().getHostMutex();
            synchronized (networks) {
                String bridgeNetwork = String.format("%s_%s", entity.getApplicationId(), "bridge").toLowerCase();
                if (!this.getDockerHost().runDockerCommand("network ls").contains(bridgeNetwork)) {
                    this.getDockerHost().runDockerCommand(String.format("network create --driver bridge -o com.docker.network.bridge.enable_ip_masquerade=true -o com.docker.network.bridge.host_binding_ipv4=0.0.0.0 %s", bridgeNetwork));
                }
                this.sensors().set(SdnAttributes.BRIDGE_NETWORK_ID, (Object)bridgeNetwork);
                entity.sensors().set(SdnAttributes.BRIDGE_NETWORK_ID, (Object)bridgeNetwork);
                options.networkMode(bridgeNetwork);
            }
            JcloudsSshMachineLocation container = (JcloudsSshMachineLocation)host.getJcloudsLocation().obtain((Map)dockerFlags);
            String containerId = container.getJcloudsId();
            this.sensors().set(DOCKER_CONTAINER_ID, (Object)containerId);
            this.configurePortBindings(dockerHost, entity);
            entity.sensors().set(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)dockerHost.getInfrastructure());
            entity.sensors().set(DockerContainer.DOCKER_HOST, (Object)dockerHost);
            entity.sensors().set(DockerContainer.CONTAINER, (Object)this);
            entity.sensors().set(DockerContainer.DOCKER_CONTAINER_ID, (Object)containerId);
            this.relations().add(DockerContainer.RUNNING, (BrooklynObject)entity);
            entity.relations().add(DockerContainer.RUNNING.getInverseRelationshipType(), (BrooklynObject)this);
            if (((Boolean)this.config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
                SdnAgent agent = (SdnAgent)Entities.attributeSupplierWhenReady((Entity)dockerHost, SdnAgent.SDN_AGENT).get();
                List networks2 = (List)this.sensors().get(SdnAttributes.ATTACHED_NETWORKS);
                HashSet addresses = Sets.newHashSet();
                for (String networkId : networks2) {
                    VirtualNetwork vlan = agent.createNetwork(networkId);
                    InetAddress address = agent.attachNetwork(containerId, networkId);
                    addresses.add(address.getHostAddress());
                    agent.connect(this, vlan);
                }
                this.sensors().set(CONTAINER_ADDRESSES, (Object)addresses);
                entity.sensors().set(CONTAINER_ADDRESSES, (Object)addresses);
            }
            LocationSpec spec = LocationSpec.create(DockerContainerLocation.class);
            ((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)spec.configure(flags)).configure(DynamicLocation.OWNER, (Object)this)).configure((CharSequence)"entity", (Object)entity)).configure((CharSequence)"machine", (Object)container)).configure(container.config().getBag().getAllConfig())).configure((CharSequence)"address", (Object)this.getSshHostAddress())).configure(SshMachineLocation.SSH_HOST, (Object)this.getSshHostAddress().getHostName())).configure(SshTool.PROP_HOST, (Object)this.getSshHostAddress().getHostName())).configure(SshTool.PROP_PORT, (Object)container.getSshHostAndPort().getPort());
            DockerContainerLocation location = (DockerContainerLocation)this.getManagementContext().getLocationManager().createLocation(spec);
            this.sensors().set(DYNAMIC_LOCATION, (Object)location);
            this.sensors().set((AttributeSensor)LOCATION_NAME, (Object)location.getId());
            DockerUtils.addExtraPublicKeys(entity, location);
            DockerUtils.configurePortMappings(entity);
            DockerUtils.configureEnrichers(subnetTier, entity);
            LOG.info("New Docker container location {} created", (Object)location);
            return location;
        }
        catch (NoMachinesAvailableException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void deleteLocation() {
        DockerContainerLocation location = this.getDynamicLocation();
        if (location != null) {
            try {
                location.close();
            }
            catch (IOException ioe) {
                LOG.debug("Error closing container location", (Throwable)ioe);
            }
            LocationManager mgr = this.getManagementContext().getLocationManager();
            if (mgr.isManaged((Location)location)) {
                mgr.unmanage((Location)location);
            }
        }
        this.sensors().set(DYNAMIC_LOCATION, null);
        this.sensors().set((AttributeSensor)LOCATION_NAME, null);
    }

    public void start(Collection<? extends Location> locs) {
        this.addLocations(locs);
        MutableList locations = MutableList.copyOf((Iterable)Locations.getLocationsCheckingAncestors(locs, (Entity)this));
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        try {
            Boolean started = (Boolean)this.config().get(SoftwareProcess.ENTITY_STARTED);
            Boolean managed = (Boolean)this.config().get(DockerContainer.MANAGED);
            if (Boolean.TRUE.equals(started) || !managed.booleanValue()) {
                DockerHost dockerHost = this.getDockerHost();
                DockerHostLocation host = (DockerHostLocation)dockerHost.getDynamicLocation();
                this.sensors().set((AttributeSensor)DOCKER_IMAGE_ID, this.config().get((ConfigKey.HasConfigKey)DOCKER_IMAGE_ID));
                this.sensors().set((AttributeSensor)DOCKER_IMAGE_NAME, this.config().get((ConfigKey.HasConfigKey)DOCKER_IMAGE_NAME));
                this.sensors().set(SSH_MACHINE_LOCATION, (Object)host.getMachine());
            } else {
                MutableMap flags = MutableMap.copyOf((Map)((Map)this.config().get(LOCATION_FLAGS)));
                DockerContainerLocation location = this.createLocation((Map)flags);
                this.sensors().set(SSH_MACHINE_LOCATION, (Object)location.getMachine());
            }
            this.connectSensors();
            super.start((Collection)locations);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
    }

    public void rebind() {
        super.rebind();
        if (this.status == null) {
            this.connectSensors();
        }
    }

    public void restart() {
        this.stop();
        this.start(this.getLocations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Lifecycle state = (Lifecycle)this.sensors().get(SERVICE_STATE_ACTUAL);
        if (Lifecycle.STOPPING.equals((Object)state) || Lifecycle.STOPPED.equals((Object)state)) {
            LOG.debug("Ignoring request to stop {} when it is already {}", (Object)this, (Object)state);
            LOG.trace("Duplicate stop came from: \n" + Joiner.on((String)"\n").join((Object[])Thread.getAllStackTraces().get(Thread.currentThread())));
            return;
        }
        LOG.info("Stopping {} when its state is {}", (Object)this, this.sensors().get(SERVICE_STATE_ACTUAL));
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPING);
        this.disconnectSensors();
        Entity entity = this.getRunningEntity();
        if (entity != null) {
            this.removePortBindings(this.getDockerHost(), entity);
        }
        if (this.getContainerId() != null) {
            this.shutDown();
        }
        this.removeContainer();
        Boolean managed = (Boolean)this.config().get(DockerContainer.MANAGED);
        if (managed.booleanValue()) {
            Object object = this.getDockerHost().getHostMutex();
            synchronized (object) {
                String bridgeNetwork = (String)this.sensors().get(SdnAttributes.BRIDGE_NETWORK_ID);
                try {
                    int attached = Integer.parseInt(this.getDockerHost().runDockerCommand(String.format("network inspect --format=\"{{ len .Containers }}\" %s", bridgeNetwork)));
                    if (attached == 0) {
                        this.getDockerHost().runDockerCommand(String.format("network rm %s", bridgeNetwork));
                    }
                }
                catch (IllegalStateException ise) {
                    LOG.warn("Error trying to remove bridge network {}: {}", (Object)bridgeNetwork, (Object)ise);
                }
            }
            if (((Boolean)this.config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
                SdnProvider provider = (SdnProvider)this.getDockerHost().getInfrastructure().sensors().get(SdnAttributes.SDN_PROVIDER);
                SdnAgent agent = (SdnAgent)this.getDockerHost().sensors().get(SdnAgent.SDN_AGENT);
                List networks = (List)this.sensors().get(SdnAttributes.ATTACHED_NETWORKS);
                for (String networkId : networks) {
                    Object object2 = this.getDockerHost().getInfrastructure().getInfrastructureMutex();
                    synchronized (object2) {
                        VirtualNetwork vlan = SdnUtils.lookupNetwork(provider, networkId);
                        agent.disconnect(this, vlan);
                        Optional<Integer> attached = SdnUtils.countAttached(this.getDockerHost(), networkId);
                        LOG.debug("Found {} containers attached to {} when stopping {}", new Object[]{attached.or((Object)-1), networkId, this.getContainerId()});
                        if (attached.isPresent() && (Integer)attached.get() == 0) {
                            Entities.invokeEffector((Entity)this.getDockerHost(), (Entity)vlan, (Effector)Startable.STOP).getUnchecked();
                            Entities.unmanage((Entity)vlan);
                        }
                    }
                }
            }
            this.sensors().set(SSH_MACHINE_LOCATION, null);
            Boolean started = (Boolean)this.config().get(SoftwareProcess.ENTITY_STARTED);
            if (!started.booleanValue()) {
                this.deleteLocation();
            }
        }
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPED);
    }

    public String getHostname() {
        String containerName = this.getDockerContainerName();
        if (((Boolean)this.config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
            String initialNetwork = (String)this.sensors().get(SdnAttributes.INITIAL_ATTACHED_NETWORK);
            return String.format("%s.%s", containerName, initialNetwork);
        }
        return containerName;
    }

    public Set<String> getPublicAddresses() {
        return Sets.newHashSet((Object[])new String[]{(String)this.sensors().get(SoftwareProcess.SUBNET_ADDRESS)});
    }

    public Set<String> getPrivateAddresses() {
        return (Set)this.sensors().get(CONTAINER_ADDRESSES);
    }

    static {
        RendererHints.register((AttributeSensor)DOCKER_HOST, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)ENTITY, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)CONTAINER, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
    }
}

