/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.DockerInfrastructureImpl;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.location.DockerLocation;
import clocker.docker.location.strategy.DockerAwarePlacementStrategy;
import clocker.docker.location.strategy.affinity.AffinityRules;
import clocker.docker.location.strategy.basic.DepthFirstPlacementStrategy;
import clocker.docker.networking.entity.sdn.util.SdnAttributes;
import com.google.common.reflect.TypeToken;
import io.brooklyn.entity.nosql.etcd.EtcdCluster;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.entity.trait.Resizable;
import org.apache.brooklyn.core.location.dynamic.LocationOwner;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@ImplementedBy(value=DockerInfrastructureImpl.class)
public interface DockerInfrastructure
extends StartableApplication,
Resizable,
LocationOwner<DockerLocation, DockerInfrastructure> {
    @CatalogConfig(label="Location Name", priority=90.0)
    @SetFromFlag(value="locationName")
    public static final BasicAttributeSensorAndConfigKey<String> LOCATION_NAME = LocationOwner.LOCATION_NAME;
    @CatalogConfig(label="Docker Version", priority=10.0)
    @SetFromFlag(value="dockerVersion")
    public static final ConfigKey<String> DOCKER_VERSION = ConfigKeys.newStringConfigKey((String)"docker.version", (String)"The Docker Engine version number", (String)"1.10.3");
    @SetFromFlag(value="securityGroup")
    public static final ConfigKey<String> SECURITY_GROUP = ConfigKeys.newStringConfigKey((String)"docker.host.securityGroup", (String)"Set a network security group for cloud servers to use; (null to use default configuration)");
    @CatalogConfig(label="Docker Cluster Size", priority=50.0)
    @SetFromFlag(value="minHost")
    public static final ConfigKey<Integer> DOCKER_HOST_CLUSTER_MIN_SIZE = ConfigKeys.newConfigKeyWithPrefix((String)"docker.host.", (ConfigKey)DynamicCluster.INITIAL_SIZE);
    @SetFromFlag(value="strategies")
    public static final ConfigKey<List<DockerAwarePlacementStrategy>> PLACEMENT_STRATEGIES = ConfigKeys.newConfigKeyWithDefault(DockerAttributes.PLACEMENT_STRATEGIES, (Object)MutableList.of((Object)new DepthFirstPlacementStrategy()));
    @SetFromFlag(value="highAvailabilty")
    public static final ConfigKey<Boolean> HA_POLICY_ENABLE = ConfigKeys.newBooleanConfigKey((String)"docker.policy.ha.enable", (String)"Enable high-availability and resilience/restart policies", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="removeEmptyHosts")
    public static final ConfigKey<Boolean> REMOVE_EMPTY_DOCKER_HOSTS = ConfigKeys.newBooleanConfigKey((String)"docker.host.removeEmpty", (String)"Remove empty Docker Hosts with no containers", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="enableSdn")
    public static final ConfigKey<Boolean> SDN_ENABLE = SdnAttributes.SDN_ENABLE;
    @SetFromFlag(value="sdnProviderSpec")
    public static final ConfigKey<EntitySpec> SDN_PROVIDER_SPEC = SdnAttributes.SDN_PROVIDER_SPEC;
    @SetFromFlag(value="hostSpec")
    public static final AttributeSensorAndConfigKey<EntitySpec, EntitySpec> DOCKER_HOST_SPEC = ConfigKeys.newSensorAndConfigKey(EntitySpec.class, (String)"docker.host.spec", (String)"Specification to use when creating child Docker Hosts", (Object)EntitySpec.create(DockerHost.class));
    @SetFromFlag(value="generateCerts")
    public static final ConfigKey<Boolean> DOCKER_GENERATE_TLS_CERTIFICATES = ConfigKeys.newBooleanConfigKey((String)"docker.tls.generate", (String)"Generate the TLS required TLS certificate and keys for each host", (Boolean)Boolean.TRUE);
    public static final ConfigKey<String> DOCKER_CA_CERTIFICATE_PATH = ConfigKeys.newStringConfigKey((String)"docker.tls.caCert", (String)"The Docker Engine TLS CA certificate PEM file path", (String)"ca-cert.pem");
    public static final ConfigKey<String> DOCKER_CA_KEY_PATH = ConfigKeys.newStringConfigKey((String)"docker.tls.caKey", (String)"The Docker Engine TLS CA certificate PEM file path", (String)"ca-key.pem");
    public static final ConfigKey<String> DOCKER_SERVER_CERTIFICATE_PATH = ConfigKeys.newStringConfigKey((String)"docker.tls.serverCert", (String)"The Docker Engine TLS Server certificate PEM file path");
    public static final ConfigKey<String> DOCKER_SERVER_KEY_PATH = ConfigKeys.newStringConfigKey((String)"docker.tls.serverKey", (String)"The Docker Engine TLS Server key PEM file path");
    public static final ConfigKey<String> DOCKER_CLIENT_CERTIFICATE_PATH = ConfigKeys.newStringConfigKey((String)"docker.tls.clientCert", (String)"The Docker Engine TLS Client certificate PEM file path");
    public static final ConfigKey<String> DOCKER_CLIENT_KEY_PATH = ConfigKeys.newStringConfigKey((String)"docker.tls.clientKey", (String)"The Docker Engine TLS Client key PEM file path");
    @SetFromFlag(value="dockerfileUrl")
    public static final ConfigKey<String> DOCKERFILE_URL = ConfigKeys.newConfigKeyWithDefault(DockerAttributes.DOCKERFILE_URL, (Object)"classpath://clocker/docker/entity/container/ubuntu/Dockerfile");
    @SetFromFlag(value="dockerfileName")
    public static final ConfigKey<String> DOCKERFILE_NAME = ConfigKeys.newConfigKeyWithDefault(DockerAttributes.DOCKERFILE_NAME, (Object)"ubuntu");
    @SetFromFlag(value="imageId")
    public static final ConfigKey<String> DOCKER_IMAGE_ID = DockerAttributes.DOCKER_IMAGE_ID.getConfigKey();
    @SetFromFlag(value="hardwareId")
    public static final ConfigKey<String> DOCKER_HARDWARE_ID = DockerAttributes.DOCKER_HARDWARE_ID.getConfigKey();
    @SetFromFlag(value="affinityRules")
    public static final ConfigKey<List<String>> DOCKER_HOST_AFFINITY_RULES = AffinityRules.AFFINITY_RULES;
    @SetFromFlag(value="shutdownTimeout")
    public static final ConfigKey<Duration> SHUTDOWN_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"docker.timeout.shutdown", (String)"Timeout to wait for children when shutting down", (Duration)Duration.FIVE_MINUTES);
    @SetFromFlag(value="substitutions")
    public static final ConfigKey<Map<String, Object>> DOCKERFILE_SUBSTITUTIONS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, Object>>(){}, (String)"docker.dockerfile.substitutions", (String)"Dockerfile template substitutions", (Object)MutableMap.of());
    @CatalogConfig(label="Start Registry", priority=50.0)
    @SetFromFlag(value="registryStart")
    public static final ConfigKey<Boolean> DOCKER_SHOULD_START_REGISTRY = ConfigKeys.newBooleanConfigKey((String)"docker.registry.start", (String)"Setup a docker registry and use it for pulls", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="registryPort")
    public static final ConfigKey<Integer> DOCKER_REGISTRY_PORT = ConfigKeys.newIntegerConfigKey((String)"docker.registry.port", (String)"", (Integer)5000);
    @SetFromFlag(value="registryWriteable")
    public static final ConfigKey<Boolean> DOCKER_IMAGE_REGISTRY_WRITEABLE = ConfigKeys.newBooleanConfigKey((String)"docker.registry.writeable", (String)"Use the configured docker registry for pushes", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="registryUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_REGISTRY_URL = DockerAttributes.DOCKER_IMAGE_REGISTRY_URL;
    @SetFromFlag(value="registryUsername")
    public static final ConfigKey<String> DOCKER_IMAGE_REGISTRY_USERNAME = ConfigKeys.newStringConfigKey((String)"docker.registry.username", (String)"Username for docker registry access");
    @SetFromFlag(value="registryPassword")
    public static final ConfigKey<String> DOCKER_IMAGE_REGISTRY_PASSWORD = ConfigKeys.newStringConfigKey((String)"docker.registry.password", (String)"Password for docker registry access");
    public static final AttributeSensor<Entity> DOCKER_IMAGE_REGISTRY = DockerAttributes.DOCKER_IMAGE_REGISTRY;
    public static final ConfigKey<Boolean> USE_JCLOUDS_HOSTNAME_CUSTOMIZER = ConfigKeys.newBooleanConfigKey((String)"docker.hostname.customizer", (String)"Fix issues with hostname in some clouds", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="etcdVersion")
    public static final ConfigKey<String> ETCD_VERSION = ConfigKeys.newStringConfigKey((String)"etcd.version", (String)"The Etcd version number", (String)"2.3.1");
    public static final ConfigKey<Boolean> EXTERNAL_ETCD_CLUSTER = ConfigKeys.newBooleanConfigKey((String)"etcd.external", (String)"Whether to use an external Etcd cluster", (Boolean)Boolean.FALSE);
    public static final ConfigKey<Integer> EXTERNAL_ETCD_INITIAL_SIZE = ConfigKeys.newIntegerConfigKey((String)"etcd.external.initialSize", (String)"The initial size of the external Etcd cluster");
    public static final AttributeSensorAndConfigKey<String, String> EXTERNAL_ETCD_URL = ConfigKeys.newStringSensorAndConfigKey((String)"etcd.external.url", (String)"The URL for the external Etcd cluster (if configured, no cluster will be provisioned)");
    public static final AttributeSensor<EtcdCluster> ETCD_CLUSTER = Sensors.newSensor(EtcdCluster.class, (String)"etcd.cluster", (String)"The EtcdCluster entity for storing state");
    public static final AttributeSensor<DynamicCluster> DOCKER_HOST_CLUSTER = Sensors.newSensor(DynamicCluster.class, (String)"docker.hosts", (String)"Docker host cluster");
    public static final AttributeSensor<DynamicGroup> DOCKER_CONTAINER_FABRIC = Sensors.newSensor(DynamicGroup.class, (String)"docker.fabric", (String)"Docker container fabric");
    public static final AttributeSensor<Entity> SDN_PROVIDER = SdnAttributes.SDN_PROVIDER;
    public static final AttributeSensor<AtomicInteger> DOCKER_HOST_COUNTER = Sensors.newSensor(AtomicInteger.class, (String)"docker.hosts.counter", (String)"Docker host counter");
    public static final AttributeSensor<AtomicInteger> DOCKER_CONTAINER_COUNTER = Sensors.newSensor(AtomicInteger.class, (String)"docker.containers.counter", (String)"Docker container counter");
    public static final AttributeSensor<Integer> DOCKER_HOST_COUNT = DockerAttributes.DOCKER_HOST_COUNT;
    public static final AttributeSensor<Integer> DOCKER_CONTAINER_COUNT = DockerAttributes.DOCKER_CONTAINER_COUNT;

    public List<Entity> getDockerHostList();

    public DynamicCluster getDockerHostCluster();

    public List<Entity> getDockerContainerList();

    public DynamicGroup getContainerFabric();

    public Object getInfrastructureMutex();
}

