/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.DockerHostDriver;
import clocker.docker.entity.DockerHostImpl;
import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.entity.util.DockerUtils;
import clocker.docker.entity.util.JcloudsHostnameCustomizer;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import io.brooklyn.entity.nosql.etcd.EtcdCluster;
import io.brooklyn.entity.nosql.etcd.EtcdNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.file.ArchiveUtils;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.VersionComparator;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;

public class DockerHostSshDriver
extends AbstractSoftwareProcessSshDriver
implements DockerHostDriver {
    public DockerHostSshDriver(DockerHostImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    @Override
    public Integer getDockerPort() {
        return (Integer)this.getEntity().sensors().get((AttributeSensor)DockerHost.DOCKER_SSL_PORT);
    }

    @Override
    public String buildImage(String dockerfile, Optional<String> entrypoint, Optional<String> contextArchive, String name, boolean useSsh, Map<String, Object> substitutions) {
        String imageId;
        String imageDir = Os.mergePaths((String[])new String[]{this.getRunDir(), name});
        if (!ArchiveUtils.ArchiveType.UNKNOWN.equals((Object)ArchiveUtils.ArchiveType.of((String)dockerfile)) || Urls.isDirectory((String)dockerfile)) {
            ArchiveUtils.deploy((String)dockerfile, (SshMachineLocation)this.getMachine(), (String)imageDir);
            imageId = this.buildDockerfileDirectory(name);
            log.info("Created base Dockerfile image with ID {}", (Object)imageId);
        } else {
            if (contextArchive.isPresent()) {
                ArchiveUtils.deploy((String)((String)contextArchive.get()), (SshMachineLocation)this.getMachine(), (String)imageDir);
            } else {
                ProcessTaskWrapper task = ((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{String.format("mkdir -p %s", imageDir)}).machine(this.getMachine())).newTask();
                DynamicTasks.queueIfPossible((TaskAdaptable)task).executionContext((Entity)this.getEntity()).orSubmitAndBlock();
                int result = (Integer)task.get();
                if (result != 0) {
                    throw new IllegalStateException("Error creating image directory: " + name);
                }
            }
            this.copyTemplate(dockerfile, Os.mergePaths((String[])new String[]{name, "Dockerfile"}), false, substitutions);
            if (entrypoint.isPresent()) {
                this.copyResource((String)entrypoint.get(), Os.mergePaths((String[])new String[]{name, "entrypoint.sh"}));
            }
            imageId = this.buildDockerfileDirectory(name);
            log.info("Created Dockerfile image with ID {}", (Object)imageId);
        }
        if (useSsh) {
            this.copyTemplate("classpath://clocker/docker/entity/container/SshdDockerfile", Os.mergePaths((String[])new String[]{name, "SshdDockerfile"}), false, substitutions);
            imageId = this.buildDockerfile("SshdDockerfile", name);
            log.info("Created SSHable Dockerfile image with ID {}", (Object)imageId);
        }
        return imageId;
    }

    @Override
    public String layerSshableImageOn(String fullyQualifiedImageName) {
        Preconditions.checkNotNull((Object)fullyQualifiedImageName, (Object)"fullyQualifiedImageName");
        this.copyTemplate("classpath://clocker/docker/entity/container/SshdDockerfile", Os.mergePaths((String[])new String[]{fullyQualifiedImageName, "SshdDockerfile"}), true, (Map)ImmutableMap.of((Object)"fullyQualifiedImageName", (Object)fullyQualifiedImageName));
        String sshdImageId = this.buildDockerfile("SshdDockerfile", fullyQualifiedImageName);
        log.info("Created SSH-based image from {} with ID {}", (Object)fullyQualifiedImageName, (Object)sshdImageId);
        return sshdImageId;
    }

    private String buildDockerfileDirectory(String name) {
        String build = String.format("build --rm -t %s %s", name, Os.mergePaths((String[])new String[]{this.getRunDir(), name}));
        String stdout = ((DockerHost)this.getEntity()).runDockerCommandTimeout(build, Duration.minutes((Number)20));
        String prefix = Strings.getFirstWordAfter((String)stdout, (String)"Successfully built");
        return this.getImageId(prefix, name);
    }

    private String buildDockerfile(String dockerfile, String name) {
        String build = String.format("build --rm -t %s - < %s", name, Os.mergePaths((String[])new String[]{this.getRunDir(), name, dockerfile}));
        String stdout = ((DockerHost)this.getEntity()).runDockerCommandTimeout(build, Duration.minutes((Number)20));
        String prefix = Strings.getFirstWordAfter((String)stdout, (String)"Successfully built");
        return this.getImageId(prefix, name);
    }

    private String getImageId(String prefix, String name) {
        String inspect = String.format("inspect --format={{.Id}} %s", prefix);
        String imageId = ((DockerHost)this.getEntity()).runDockerCommand(inspect);
        return DockerUtils.checkId(imageId);
    }

    public String getEpelRelease() {
        return (String)this.getEntity().config().get(DockerHost.EPEL_RELEASE);
    }

    @Override
    public String deployArchive(String url) {
        String volumeId = Identifiers.makeIdFromHash((long)url.hashCode());
        String path = Os.mergePaths((String[])new String[]{this.getRunDir(), volumeId});
        ArchiveUtils.deploy((String)url, (SshMachineLocation)this.getMachine(), (String)path);
        return path;
    }

    public void install() {
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        String osVersion = osDetails.getVersion();
        String arch = osDetails.getArch();
        if (!osDetails.is64bit()) {
            throw new IllegalStateException("Docker supports only 64bit OS");
        }
        if (osDetails.isWindows() || osDetails.isMac()) {
            throw new IllegalStateException("Clocker does not support Windows or OSX currently");
        }
        log.debug("Installing Docker on {} version {}", (Object)osDetails.getName(), (Object)osVersion);
        if (osDetails.isLinux()) {
            String storage = Strings.toLowerCase((String)((String)this.entity.config().get(DockerHost.DOCKER_STORAGE_DRIVER)));
            if (!"devicemapper".equals(storage)) {
                int present = ((DockerHost)this.getEntity()).execCommandStatus(BashCommands.sudo((String)("modprobe " + storage)));
                ScriptHelper uname = this.newScript((String)"check-kernel-version").body.append((CharSequence)"uname -r").failOnNonZeroResultCode().uniqueSshConnection().gatherOutput().noExtraOutput();
                uname.execute();
                String kernelVersion = Strings.getFirstWord((String)uname.getResultStdout());
                if (VersionComparator.getInstance().compare("3.19", kernelVersion) > 0 || present != 0) {
                    MutableList commands = MutableList.of();
                    if ("ubuntu".equalsIgnoreCase(osDetails.getName())) {
                        commands.add(BashCommands.installPackage((String)"software-properties-common linux-generic-lts-vivid"));
                        this.executeKernelInstallation((List<String>)commands);
                    }
                    if ("centos".equalsIgnoreCase(osDetails.getName())) {
                        commands.add(BashCommands.sudo((String)"yum -y --nogpgcheck upgrade kernel"));
                        this.executeKernelInstallation((List<String>)commands);
                    }
                }
            }
            EtcdCluster etcd = (EtcdCluster)((DockerHost)this.getEntity()).getInfrastructure().sensors().get(DockerInfrastructure.ETCD_CLUSTER);
            EtcdNode node = (EtcdNode)etcd.addNode((Location)this.getMachine(), (Map)Maps.newHashMap());
            node.start((Collection)ImmutableList.of((Object)this.getMachine()));
            this.getEntity().sensors().set(DockerHost.ETCD_NODE, (Object)node);
            Entities.waitForServiceUp((Entity)node);
        }
        ArrayList commands = Lists.newArrayList();
        if (osDetails.isLinux()) {
            commands.add(BashCommands.INSTALL_CURL);
            if ("ubuntu".equalsIgnoreCase(osDetails.getName())) {
                commands.add(this.installDockerOnUbuntu());
            } else if ("centos".equalsIgnoreCase(osDetails.getName())) {
                commands.add(BashCommands.ifExecutableElse1((String)"yum", (String)this.useYum(osVersion, arch, this.getEpelRelease())));
                commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"docker-io"), null));
                commands.add(BashCommands.sudo((String)String.format("curl https://get.docker.com/builds/Linux/x86_64/docker-%s -o /usr/bin/docker", this.getVersion())));
            } else {
                commands.add(this.installDockerFallback());
            }
        }
        this.newScript((String)"installing").body.append((Collection)commands).failOnNonZeroResultCode().execute();
    }

    private void executeKernelInstallation(List<String> commands) {
        this.newScript((String)"installing-kernel").body.append(commands).body.append((CharSequence)BashCommands.sudo((String)"reboot")).execute();
        Stopwatch stopwatchForReboot = Stopwatch.createStarted();
        Time.sleep((Duration)Duration.seconds((Number)30));
        Task sshable = TaskBuilder.builder().displayName("Waiting until host is SSHable").body((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Repeater.create().every(Duration.TEN_SECONDS).until((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return DockerHostSshDriver.this.getLocation().isSshable();
                    }
                }).limitTimeTo(Duration.minutes((Number)15)).run();
            }
        }).build();
        Boolean result = (Boolean)DynamicTasks.queueIfPossible((TaskAdaptable)sshable).orSubmitAndBlock().andWaitForSuccess();
        if (!result.booleanValue()) {
            throw new IllegalStateException(String.format("The entity %s is not sshable after reboot (waited %s)", this.entity, Time.makeTimeStringRounded((Stopwatch)stopwatchForReboot)));
        }
        if (((Boolean)this.entity.config().get(JcloudsLocationConfig.MAP_DEV_RANDOM_TO_DEV_URANDOM)).booleanValue()) {
            this.newScript((String)"installing-urandom").body.append(new CharSequence[]{BashCommands.sudo((String)"mv /dev/random /dev/random-real"), BashCommands.sudo((String)"ln -s /dev/urandom /dev/random")}).execute();
        }
        MachineProvisioningLocation provisioner = (MachineProvisioningLocation)this.getEntity().sensors().get(SoftwareProcess.PROVISIONING_LOCATION);
        if (((Boolean)this.getEntity().config().get(DockerInfrastructure.USE_JCLOUDS_HOSTNAME_CUSTOMIZER)).booleanValue()) {
            JcloudsHostnameCustomizer.instanceOf().customize((JcloudsLocation)provisioner, null, (JcloudsMachineLocation)this.location);
        }
    }

    private String useYum(String osVersion, String arch, String epelRelease) {
        String osMajorVersion = osVersion.substring(0, osVersion.lastIndexOf("."));
        return BashCommands.chainGroup((String[])new String[]{BashCommands.alternatives((String[])new String[]{BashCommands.sudo((String)"rpm -qa | grep epel-release"), BashCommands.sudo((String)String.format("rpm -Uvh http://dl.fedoraproject.org/pub/epel/%s/%s/epel-release-%s.noarch.rpm", osMajorVersion, arch, epelRelease))})});
    }

    public String getVersion() {
        String version = super.getVersion();
        if (version.matches("^[0-9]+\\.[0-9]+$")) {
            version = version + ".0";
        }
        return version;
    }

    private String installDockerOnUbuntu() {
        String repositoryVersionName;
        String dockerRepoName;
        String ubuntuVersion;
        String dockerVersion = this.getVersion();
        switch (ubuntuVersion = this.getMachine().getMachineDetails().getOsDetails().getVersion()) {
            case "12.04": {
                dockerRepoName = "ubuntu-precise";
                repositoryVersionName = dockerVersion + "-0~precise";
                break;
            }
            case "14.04": {
                dockerRepoName = "ubuntu-trusty";
                repositoryVersionName = dockerVersion + "-0~trusty";
                break;
            }
            case "15.04": 
            case "15.10": {
                dockerRepoName = "ubuntu-wily";
                repositoryVersionName = dockerVersion + "-0~wily";
                break;
            }
            case "16.04": {
                dockerRepoName = "ubuntu-xenial";
                repositoryVersionName = dockerVersion + "-0~xenial";
                break;
            }
            default: {
                throw new IllegalArgumentException("No docker repo found for ubuntu version: " + ubuntuVersion);
            }
        }
        log.debug("Installing Docker version {} on Ubuntu {} with docker repo name {} and repository version {}", new Object[]{dockerVersion, ubuntuVersion, dockerRepoName, repositoryVersionName});
        return BashCommands.chainGroup((String[])new String[]{BashCommands.installPackage((String)"apt-transport-https"), "echo 'deb https://apt.dockerproject.org/repo " + dockerRepoName + " main' | " + BashCommands.sudo((String)"tee -a /etc/apt/sources.list.d/docker.list"), BashCommands.sudo((String)"apt-key adv --keyserver hkp://p80.pool.sks-keyservers.net:80 --recv-keys 58118E89F3A912897C070ADBF76221572C52609D"), BashCommands.installPackage((String)("docker-engine=" + repositoryVersionName))});
    }

    private String installDockerFallback() {
        return "curl -s https://get.docker.com/ | " + BashCommands.sudo((String)"sh");
    }

    private String getDockerRegistryOpts() {
        String registryUrl = (String)this.entity.config().get(DockerInfrastructure.DOCKER_IMAGE_REGISTRY_URL);
        if (Strings.isNonBlank((CharSequence)registryUrl)) {
            return String.format("--insecure-registry %s", registryUrl);
        }
        if (((Boolean)this.entity.config().get(DockerInfrastructure.DOCKER_SHOULD_START_REGISTRY)).booleanValue()) {
            String firstHostname = (String)((Entity)this.entity.sensors().get(DynamicGroup.FIRST)).sensors().get(Attributes.HOSTNAME);
            Integer registryPort = (Integer)this.entity.config().get(DockerInfrastructure.DOCKER_REGISTRY_PORT);
            return String.format("--insecure-registry %s:%d", firstHostname, registryPort);
        }
        return null;
    }

    private String getStorageOpts() {
        String driver = (String)this.getEntity().config().get(DockerHost.DOCKER_STORAGE_DRIVER);
        if (Strings.isBlank((CharSequence)driver)) {
            return null;
        }
        return "-s " + Strings.toLowerCase((String)driver);
    }

    public void customize() {
        if (this.isRunning()) {
            log.info("Stopping running Docker instance at {} before customising", (Object)this.getMachine());
            this.stop();
        }
        String os = this.getMachine().getMachineDetails().getOsDetails().getName();
        boolean centos = "centos".equalsIgnoreCase(os);
        boolean ubuntu = "ubuntu".equalsIgnoreCase(os);
        if (((Boolean)this.entity.config().get(DockerInfrastructure.DOCKER_GENERATE_TLS_CERTIFICATES)).booleanValue()) {
            this.newScript((Map)ImmutableMap.of((Object)"nonStandardLayout", (Object)"true"), (String)"customizing").body.append(new CharSequence[]{String.format("cp ca-cert.pem %s/ca.pem", this.getRunDir()), String.format("cp server-cert.pem %s/cert.pem", this.getRunDir()), String.format("cp server-key.pem %s/key.pem", this.getRunDir())}).failOnNonZeroResultCode().execute();
        }
        String firstHost = (String)((Entity)this.entity.sensors().get(AbstractGroup.FIRST)).sensors().get(Attributes.HOSTNAME);
        String certsPath = "/etc/docker/certs.d/" + firstHost + ":" + this.entity.config().get(DockerInfrastructure.DOCKER_REGISTRY_PORT);
        this.newScript((String)"customizing").body.append((CharSequence)BashCommands.chainGroup((String[])new String[]{BashCommands.sudo((String)("mkdir -p " + certsPath)), BashCommands.sudo((String)("cp ca.pem " + certsPath + "/ca.crt"))})).failOnNonZeroResultCode().execute();
        EtcdNode etcdNode = (EtcdNode)this.getEntity().sensors().get(DockerHost.ETCD_NODE);
        HostAndPort etcdAuthority = HostAndPort.fromParts((String)((String)etcdNode.sensors().get(Attributes.SUBNET_ADDRESS)), (int)((Integer)etcdNode.sensors().get((AttributeSensor)EtcdNode.ETCD_CLIENT_PORT)));
        MutableList args = MutableList.of((Object)(centos ? "--selinux-enabled" : null), (Object)"--userland-proxy=false", (Object[])new String[]{String.format("-H tcp://0.0.0.0:%d", this.getDockerPort()), "-H unix:///var/run/docker.sock", String.format("--cluster-store=etcd://%s", etcdAuthority.toString()), String.format("--cluster-advertise=%s:%d", this.getEntity().sensors().get(Attributes.SUBNET_ADDRESS), this.getDockerPort()), this.getStorageOpts(), this.getDockerRegistryOpts(), "--tlsverify", "--tls", String.format("--tlscert=%s/cert.pem", this.getRunDir()), String.format("--tlskey=%s/key.pem", this.getRunDir()), String.format("--tlscacert=%s/ca.pem", this.getRunDir())});
        String argv = Joiner.on((String)" ").skipNulls().join((Iterable)args);
        log.debug("Docker daemon args: {}", (Object)argv);
        if (ubuntu) {
            this.newScript((String)"customizing-upstart").body.append(new CharSequence[]{BashCommands.chain((String[])new String[]{BashCommands.sudo((String)"mkdir -p /etc/default"), String.format("echo 'DOCKER_OPTS=\"%s\"' | ", argv) + BashCommands.sudo((String)"tee -a /etc/default/docker")}), BashCommands.sudo((String)"groupadd -f docker"), BashCommands.sudo((String)String.format("gpasswd -a %s docker", this.getMachine().getUser())), BashCommands.sudo((String)"newgrp docker")}).failOnNonZeroResultCode().execute();
        }
        if (centos) {
            this.newScript((String)"customizing-sysconfig").body.append((CharSequence)BashCommands.chain((String[])new String[]{BashCommands.sudo((String)"mkdir -p /etc/sysconfig"), String.format("echo 'other_args=\"%s\"' | ", argv) + BashCommands.sudo((String)"tee -a /etc/sysconfig/docker")})).failOnNonZeroResultCode().execute();
        }
        boolean dockerTen = VersionComparator.getInstance().compare(this.getVersion(), "1.10") >= 0;
        String service = Os.mergePaths((String[])new String[]{this.getInstallDir(), "docker.service"});
        this.copyTemplate("classpath://clocker/docker/entity/docker.service", service, true, (Map)ImmutableMap.of((Object)"args", (Object)argv, (Object)"daemon", (Object)(dockerTen ? "daemon" : "-d")));
        this.newScript((String)"customizing-systemd").body.append((CharSequence)BashCommands.chain((String[])new String[]{BashCommands.sudo((String)"mkdir -p /etc/systemd/system"), BashCommands.sudo((String)String.format("cp %s %s", service, "/etc/systemd/system/docker.service")), BashCommands.ifExecutableElse0((String)"systemctl", (String)BashCommands.sudo((String)"systemctl daemon-reload"))})).failOnNonZeroResultCode().execute();
        MutableMap mapping = MutableMap.of();
        Map volumes = (Map)this.getEntity().config().get(DockerHost.DOCKER_HOST_VOLUME_MAPPING);
        if (volumes != null) {
            for (String source : volumes.keySet()) {
                if (Urls.isUrlWithProtocol((String)source)) {
                    String path = this.deployArchive(source);
                    mapping.put(path, volumes.get(source));
                    continue;
                }
                mapping.put(source, volumes.get(source));
            }
        }
        this.getEntity().sensors().set(DockerHost.DOCKER_HOST_VOLUME_MAPPING, (Object)mapping);
    }

    public boolean isRunning() {
        return this.newScript((String)"check-running").body.append((CharSequence)BashCommands.sudo((String)"docker version")).failOnNonZeroResultCode().uniqueSshConnection().execute() == 0;
    }

    public void stop() {
        this.newScript((String)"stopping").body.append((CharSequence)BashCommands.sudo((String)"service docker stop")).failOnNonZeroResultCode().uniqueSshConnection().execute();
    }

    public void launch() {
        this.newScript((String)"launching").body.append((CharSequence)BashCommands.sudo((String)"service docker start")).failOnNonZeroResultCode().uniqueSshConnection().execute();
    }
}

