/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location;

import brooklyn.networking.common.subnet.PortForwarder;
import brooklyn.networking.subnet.SubnetTier;
import clocker.docker.entity.DockerHost;
import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.entity.util.DockerCallbacks;
import clocker.docker.entity.util.DockerUtils;
import clocker.docker.location.DockerContainerLocation;
import clocker.docker.location.DockerLocation;
import clocker.docker.location.DockerVirtualLocation;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.SdnProvider;
import clocker.docker.networking.entity.sdn.util.SdnAttributes;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.BasicLocationDefinition;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.dynamic.DynamicLocation;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHostLocation
extends AbstractLocation
implements MachineProvisioningLocation<DockerContainerLocation>,
DockerVirtualLocation,
DynamicLocation<DockerHost, DockerHostLocation>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DockerHostLocation.class);
    public static final String CONTAINER_MUTEX = "container";
    public static final ConfigKey<String> LOCATION_NAME = ConfigKeys.newStringConfigKey((String)"locationName");
    public static final ConfigKey<SshMachineLocation> MACHINE = ConfigKeys.newConfigKey(SshMachineLocation.class, (String)"machine");
    public static final ConfigKey<PortForwarder> PORT_FORWARDER = ConfigKeys.newConfigKey(PortForwarder.class, (String)"portForwarder");
    public static final ConfigKey<JcloudsLocation> JCLOUDS_LOCATION = ConfigKeys.newConfigKey(JcloudsLocation.class, (String)"jcloudsLocation");
    @SetFromFlag(value="locationRegistrationId")
    private String locationRegistrationId;
    private transient ReadWriteLock lock = new ReentrantReadWriteLock();
    private transient DockerHost dockerHost;
    private transient SshMachineLocation machine;
    private transient PortForwarder portForwarder;
    private transient JcloudsLocation jcloudsLocation;
    private final ConcurrentMap<String, CountDownLatch> imageLatches = Maps.newConcurrentMap();

    public DockerHostLocation() {
        this(Maps.newLinkedHashMap());
    }

    public DockerHostLocation(Map properties) {
        super(properties);
        if (this.isLegacyConstruction()) {
            this.init();
        }
    }

    public void init() {
        super.init();
        if (this.isRebinding()) {
            this.dockerHost = (DockerHost)this.config().get(OWNER);
            this.machine = (SshMachineLocation)this.config().get(MACHINE);
            this.portForwarder = (PortForwarder)this.config().get(PORT_FORWARDER);
            this.jcloudsLocation = (JcloudsLocation)this.config().get(JCLOUDS_LOCATION);
        } else {
            this.dockerHost = (DockerHost)Preconditions.checkNotNull((Object)this.config().get(OWNER), (Object)"owner");
            this.machine = (SshMachineLocation)Preconditions.checkNotNull((Object)this.config().get(MACHINE), (Object)"machine");
            this.portForwarder = (PortForwarder)this.config().get(PORT_FORWARDER);
            this.jcloudsLocation = (JcloudsLocation)this.config().get(JCLOUDS_LOCATION);
        }
    }

    public void rebind() {
        super.rebind();
        this.dockerHost = (DockerHost)this.config().get(OWNER);
        this.machine = (SshMachineLocation)this.config().get(MACHINE);
        this.portForwarder = (PortForwarder)this.config().get(PORT_FORWARDER);
        this.jcloudsLocation = (JcloudsLocation)this.config().get(JCLOUDS_LOCATION);
        if (this.dockerHost != null && this.getConfig(LOCATION_NAME) != null) {
            this.register();
        }
    }

    public LocationDefinition register() {
        String locationName = (String)Preconditions.checkNotNull((Object)this.config().get(LOCATION_NAME), (String)"config %s", (Object[])new Object[]{LOCATION_NAME.getName()});
        LocationDefinition check = this.getManagementContext().getLocationRegistry().getDefinedLocationByName(locationName);
        if (check != null) {
            throw new IllegalStateException("Location " + locationName + " is already defined: " + check);
        }
        String hostLocId = this.getId();
        String infraLocId = this.getParent() != null ? this.getParent().getId() : "";
        String locationSpec = String.format("docker:%s:%s", infraLocId, hostLocId) + String.format(":(name=\"%s\")", locationName);
        BasicLocationDefinition definition = new BasicLocationDefinition(locationName, locationSpec, (Map)ImmutableMap.of());
        this.getManagementContext().getLocationRegistry().updateDefinedLocation((LocationDefinition)definition);
        this.locationRegistrationId = definition.getId();
        this.requestPersist();
        return definition;
    }

    public void deregister() {
        if (this.locationRegistrationId != null) {
            this.getManagementContext().getLocationRegistry().removeDefinedLocation(this.locationRegistrationId);
            this.locationRegistrationId = null;
            this.requestPersist();
        }
    }

    public DockerContainerLocation obtain() throws NoMachinesAvailableException {
        return this.obtain(Maps.newLinkedHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerContainerLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        this.lock.readLock().lock();
        try {
            String imageName;
            Object context = flags.get(LocationConfigKeys.CALLER_CONTEXT.getName());
            if (context == null || !(context instanceof Entity)) {
                throw new IllegalStateException("Invalid location context: " + context);
            }
            Entity entity = (Entity)context;
            boolean useSsh = (Boolean)entity.config().get(DockerContainer.DOCKER_USE_SSH) != false && (Boolean)this.dockerHost.config().get(DockerContainer.DOCKER_USE_SSH) != false;
            LOG.info("Configuring entity {} via subnet {}", (Object)entity, (Object)this.dockerHost.getSubnetTier());
            entity.config().set(SubnetTier.PORT_FORWARDING_MANAGER, (Object)this.dockerHost.getSubnetTier().getPortForwardManager());
            entity.config().set(SubnetTier.PORT_FORWARDER, (Object)this.portForwarder);
            if (((Boolean)this.getOwner().config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
                SdnAgent agent = (SdnAgent)this.getOwner().sensors().get(SdnAgent.SDN_AGENT);
                if (agent == null) {
                    throw new IllegalStateException("SDN agent entity on " + this.getOwner() + " is null");
                }
                Map networks = (Map)((SdnProvider)agent.sensors().get(SdnAgent.SDN_PROVIDER)).sensors().get(SdnProvider.SUBNETS);
                entity.config().set(SubnetTier.SUBNET_CIDR, networks.get(entity.getApplicationId()));
            } else {
                entity.config().set(SubnetTier.SUBNET_CIDR, (Object)Cidr.UNIVERSAL);
            }
            String dockerfile = (String)entity.config().get(DockerAttributes.DOCKERFILE_URL);
            String entrypoint = (String)entity.config().get(DockerAttributes.DOCKERFILE_ENTRYPOINT_URL);
            String contextArchive = (String)entity.config().get(DockerAttributes.DOCKERFILE_CONTEXT_URL);
            String imageId = (String)entity.config().get(DockerAttributes.DOCKER_IMAGE_ID);
            Optional baseImage = Optional.fromNullable((Object)entity.config().get(DockerAttributes.DOCKER_IMAGE_NAME));
            String imageTag = (String)Optional.fromNullable((Object)entity.config().get(DockerAttributes.DOCKER_IMAGE_TAG)).or((Object)"latest");
            boolean autoCheckpointImagePostInstall = Boolean.TRUE.equals(entity.config().get(DockerAttributes.AUTO_CHECKPOINT_DOCKER_IMAGE_POST_INSTALL));
            if (autoCheckpointImagePostInstall) {
                imageName = DockerUtils.imageName(entity, dockerfile);
            } else {
                boolean collision;
                do {
                    if (!(collision = this.dockerHost.getImageNamed(imageName = DockerUtils.randomImageName(), imageTag).isPresent())) continue;
                    LOG.info("Random image name collision '{}' on host {}; generating new id", (Object)imageName, (Object)this.getOwner());
                } while (collision);
            }
            LOG.info("ImageName ({}) for entity {}: {}", new Object[]{autoCheckpointImagePostInstall ? "hash" : "random", entity, imageName});
            if (this.dockerHost.getImageNamed(imageName, imageTag).isPresent()) {
                assert (autoCheckpointImagePostInstall) : "random imageName " + imageName + " collision on host " + this.getOwner();
                this.waitForImage(imageName);
                imageId = (String)this.dockerHost.getImageNamed(imageName, imageTag).get();
                LOG.info("Found image {} for entity: {}", (Object)imageName, (Object)imageId);
                entity.config().set(SoftwareProcess.SKIP_INSTALLATION, (Object)true);
            } else if (baseImage.isPresent()) {
                Optional imageRepo = Optional.fromNullable((Object)entity.config().get(DockerAttributes.DOCKER_IMAGE_REGISTRY_URL));
                Optional localRepo = Optional.absent();
                if (((Boolean)this.config().get(DockerInfrastructure.DOCKER_SHOULD_START_REGISTRY)).booleanValue() || ((Boolean)this.config().get(DockerInfrastructure.DOCKER_IMAGE_REGISTRY_WRITEABLE)).booleanValue()) {
                    localRepo = Optional.fromNullable((Object)this.getDockerInfrastructure().sensors().get(DockerAttributes.DOCKER_IMAGE_REGISTRY_URL));
                }
                imageName = Joiner.on((char)'/').join(Optional.presentInstances((Iterable)ImmutableList.of((Object)imageRepo.or(localRepo), (Object)baseImage)));
                String fullyQualifiedName = imageName + ":" + imageTag;
                if (useSsh) {
                    imageId = this.dockerHost.layerSshableImageOnFullyQualified(fullyQualifiedName);
                    LOG.info("Created SSHable image from {}: {}", (Object)fullyQualifiedName, (Object)imageId);
                } else {
                    try {
                        this.dockerHost.runDockerCommand(String.format("pull %s", fullyQualifiedName));
                    }
                    catch (Exception e) {
                        LOG.debug("Caught exception pulling {}: {}", (Object)fullyQualifiedName, (Object)e.getMessage());
                    }
                    imageId = (String)this.dockerHost.getImageNamed(imageName, imageTag).orNull();
                }
                entity.config().set(SoftwareProcess.SKIP_INSTALLATION, (Object)true);
            } else {
                if (autoCheckpointImagePostInstall) {
                    if (((Boolean)this.getDockerInfrastructure().config().get(DockerInfrastructure.DOCKER_IMAGE_REGISTRY_WRITEABLE)).booleanValue() && (((Boolean)this.getDockerInfrastructure().config().get(DockerInfrastructure.DOCKER_SHOULD_START_REGISTRY)).booleanValue() || Strings.isNonBlank((CharSequence)((CharSequence)this.getDockerInfrastructure().sensors().get(DockerInfrastructure.DOCKER_IMAGE_REGISTRY_URL))))) {
                        this.insertCallback(entity, (ConfigKey<String>)SoftwareProcess.POST_INSTALL_COMMAND, DockerCallbacks.push());
                    } else {
                        this.insertCallback(entity, (ConfigKey<String>)SoftwareProcess.POST_INSTALL_COMMAND, DockerCallbacks.commit());
                    }
                }
                if (Strings.isNonBlank((CharSequence)dockerfile)) {
                    if (imageId != null) {
                        LOG.warn("Ignoring container imageId {} as dockerfile URL is set: {}", (Object)imageId, (Object)dockerfile);
                    }
                    Map<String, Object> substitutions = this.getExtraTemplateSubstitutions(imageName, entity);
                    imageId = this.dockerHost.buildImage(dockerfile, entrypoint, contextArchive, imageName, useSsh, substitutions);
                }
                if (Strings.isBlank((CharSequence)imageId)) {
                    imageId = (String)this.getOwner().sensors().get(DockerHost.DOCKER_IMAGE_ID);
                }
                this.imageLatches.putIfAbsent(imageName, new CountDownLatch(1));
                this.dockerHost.runDockerCommand(String.format("tag -f %s %s:latest", imageId, imageName));
            }
            String hardwareId = (String)entity.config().get(DockerAttributes.DOCKER_HARDWARE_ID);
            if (Strings.isEmpty((CharSequence)hardwareId)) {
                hardwareId = (String)this.getOwner().config().get(DockerAttributes.DOCKER_HARDWARE_ID);
            }
            this.insertCallback(entity, (ConfigKey<String>)SoftwareProcess.PRE_INSTALL_COMMAND, "if [ ! -e /dev/random ] ; then ln -s /dev/urandom /dev/random ; fi");
            LOG.info("Starting container with imageId {} and hardwareId {} at {}", new Object[]{imageId, hardwareId, this.machine});
            MutableMap containerFlags = MutableMap.builder().putAll(flags).put((Object)"useSsh", (Object)useSsh).put((Object)"entity", (Object)entity).putIfNotNull((Object)"imageId", (Object)imageId).putIfNotNull((Object)"imageName", (Object)(imageId == null ? imageName : null)).putIfNotNull((Object)"imageTag", (Object)(imageId == null ? imageTag : null)).putIfNotNull((Object)"hardwareId", (Object)hardwareId).build();
            Group cluster = this.dockerHost.getDockerContainerCluster();
            EntitySpec spec = EntitySpec.create((EntitySpec)((EntitySpec)this.getOwner().sensors().get(DockerHost.DOCKER_CONTAINER_SPEC)));
            spec.configure((Map)containerFlags);
            Entity added = cluster.addMemberChild(spec);
            if (added == null) {
                throw new NoMachinesAvailableException(String.format("Failed to create container at %s", this.dockerHost));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting container {} at {}, config {}", new Object[]{added, this.machine, Sanitizer.sanitize((ConfigBag)((EntityInternal)added).config().getBag())});
            }
            Entities.invokeEffector((Entity)entity, (Entity)added, (Effector)Startable.START, (Map)MutableMap.of((Object)"locations", (Object)ImmutableList.of((Object)this.machine))).getUnchecked();
            DockerContainer dockerContainer = (DockerContainer)added;
            dockerContainer.sensors().set(DockerContainer.DOCKER_IMAGE_ID, (Object)imageId);
            dockerContainer.sensors().set(DockerContainer.DOCKER_IMAGE_NAME, (Object)imageName);
            dockerContainer.sensors().set(DockerContainer.DOCKER_HARDWARE_ID, (Object)hardwareId);
            if (((Boolean)this.getOwner().config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
                SdnAgent agent = (SdnAgent)this.getOwner().sensors().get(SdnAgent.SDN_AGENT);
                Cidr applicationCidr = ((SdnProvider)agent.sensors().get(SdnAgent.SDN_PROVIDER)).getSubnetCidr(entity.getApplicationId());
                entity.sensors().set(SdnProvider.APPLICATION_CIDR, (Object)applicationCidr);
                dockerContainer.sensors().set(SdnProvider.APPLICATION_CIDR, (Object)applicationCidr);
            }
            DockerContainerLocation dockerContainerLocation = (DockerContainerLocation)dockerContainer.getDynamicLocation();
            return dockerContainerLocation;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Map<String, Object> getExtraTemplateSubstitutions(String imageName, Entity context) {
        MutableMap templateSubstitutions = MutableMap.of((Object)"fullyQualifiedImageName", (Object)imageName);
        templateSubstitutions.putAll((Map)this.getOwner().config().get(DockerInfrastructure.DOCKERFILE_SUBSTITUTIONS));
        if (context != null) {
            templateSubstitutions.putAll((Map)context.config().get(DockerInfrastructure.DOCKERFILE_SUBSTITUTIONS));
        }
        return templateSubstitutions;
    }

    private void insertCallback(Entity entity, ConfigKey<String> commandKey, String callback) {
        String command = (String)entity.config().get(commandKey);
        command = Strings.isNonBlank((CharSequence)command) ? BashCommands.chain((String[])new String[]{String.format("( %s )", command), callback}) : callback;
        entity.config().set(commandKey, (Object)command);
    }

    public void waitForImage(String imageName) {
        try {
            CountDownLatch latch = (CountDownLatch)this.imageLatches.get(imageName);
            if (latch != null) {
                latch.await(15L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException ie) {
            throw Exceptions.propagate((Throwable)ie);
        }
    }

    public void markImage(String imageName) {
        CountDownLatch latch = (CountDownLatch)this.imageLatches.get(imageName);
        if (latch != null) {
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DockerContainerLocation machine) {
        this.lock.readLock().lock();
        try {
            LOG.info("Releasing {}", (Object)machine);
            Group cluster = this.dockerHost.getDockerContainerCluster();
            DockerContainer container = machine.getOwner();
            if (cluster.removeMember((Entity)container)) {
                LOG.info("Docker Host {}: member {} released", (Object)this.dockerHost, (Object)machine);
            } else {
                LOG.warn("Docker Host {}: member {} not found for release", (Object)this.dockerHost, (Object)machine);
            }
            try {
                container.stop();
                machine.close();
            }
            catch (Exception e) {
                LOG.warn("Error stopping container: " + container, (Throwable)e);
                Exceptions.propagateIfFatal((Throwable)e);
            }
            finally {
                Entities.unmanage((Entity)container);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return MutableMap.of();
    }

    public DockerHost getOwner() {
        return this.dockerHost;
    }

    public SshMachineLocation getMachine() {
        return this.machine;
    }

    public JcloudsLocation getJcloudsLocation() {
        return this.jcloudsLocation;
    }

    public PortForwarder getPortForwarder() {
        return this.portForwarder;
    }

    public int getCurrentSize() {
        return this.dockerHost.getCurrentSize();
    }

    public MachineProvisioningLocation<DockerContainerLocation> newSubLocation(Map<?, ?> newFlags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Entity> getDockerContainerList() {
        return this.dockerHost.getDockerContainerList();
    }

    @Override
    public List<Entity> getDockerHostList() {
        return Lists.newArrayList((Object[])new Entity[]{this.dockerHost});
    }

    @Override
    public DockerInfrastructure getDockerInfrastructure() {
        return ((DockerLocation)this.getParent()).getDockerInfrastructure();
    }

    @Override
    public void close() throws IOException {
        LOG.info("Close called on Docker host {}: {}", (Object)this.machine, (Object)this);
        try {
            this.machine.close();
        }
        catch (Exception e) {
            LOG.info("{}: Closing Docker host: {}", (Object)e.getMessage(), (Object)this);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            LOG.info("Docker host closed: {}", (Object)this);
        }
    }

    public Lock getLock() {
        return this.lock.writeLock();
    }

    public Objects.ToStringHelper string() {
        return super.string().add("machine", (Object)this.machine).add("jcloudsLocation", (Object)this.jcloudsLocation).add("dockerHost", (Object)this.dockerHost);
    }
}

