/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.util;

import brooklyn.networking.subnet.SubnetTier;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.location.DockerContainerLocation;
import clocker.docker.networking.entity.sdn.util.SdnAttributes;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityAndAttribute;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.messaging.MessageBroker;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseCluster;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseNode;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.VanillaSoftwareProcess;
import org.apache.brooklyn.entity.webapp.WebAppServiceConstants;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DockerUtils.class);
    public static final String BRIDGE_NETWORK = "bridge";
    public static final String DOCKERFILE = "Dockerfile";
    public static final String ENTRYPOINT = "entrypoint.sh";
    public static final String MAPPED = "mapped";
    public static final String ENDPOINT = "endpoint";
    public static final String PORT = "port";
    public static final String SHA_256 = "sha256:";
    public static final Set<String> URL_SENSOR_NAMES = ImmutableSet.of((Object)WebAppServiceConstants.ROOT_URL.getName(), (Object)DatastoreMixins.DATASTORE_URL.getName(), (Object)CouchbaseNode.COUCHBASE_WEB_ADMIN_URL.getName(), (Object)MessageBroker.BROKER_URL.getName());
    public static final Set<String> BLACKLIST_URL_SENSOR_NAMES = ImmutableSet.of((Object)SoftwareProcess.DOWNLOAD_URL.getName(), (Object)CouchbaseCluster.COUCHBASE_CLUSTER_CONNECTION_URL.getName());
    public static final String UBUNTU_DOCKERFILE = "classpath://clocker/docker/entity/container/ubuntu/Dockerfile";
    public static final String UBUNTU_NETWORKING_DOCKERFILE = "classpath://clocker/docker/entity/container/ubuntu/NetworkingDockerfile";
    public static final String UBUNTU_USES_JAVA_DOCKERFILE = "classpath://clocker/docker/entity/container/ubuntu/UsesJavaDockerfile";
    public static final String CENTOS_DOCKERFILE = "classpath://clocker/docker/entity/container/centos/Dockerfile";
    public static final String COREOS_DOCKERFILE = "classpath://clocker/docker/entity/container/coreos/Dockerfile";
    public static final String SSHD_DOCKERFILE = "classpath://clocker/docker/entity/container/SshdDockerfile";
    public static final CharMatcher DOCKERFILE_CHARACTERS = CharMatcher.anyOf((CharSequence)"_").or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9'));
    public static final CharMatcher DOCKERFILE_INVALID_CHARACTERS = DOCKERFILE_CHARACTERS.negate();
    public static final Function<String, String> ALLOWED = new Function<String, String>(){

        public String apply(@Nullable String input) {
            if (input == null) {
                return null;
            }
            return DOCKERFILE_INVALID_CHARACTERS.collapseFrom((CharSequence)input.toLowerCase(Locale.ENGLISH), '_');
        }
    };

    private DockerUtils() {
    }

    public static <T> AttributeSensor<T> mappedSensor(AttributeSensor<?> source) {
        return Sensors.newSensorWithPrefix((String)"mapped.", source);
    }

    public static AttributeSensor<String> mappedPortSensor(AttributeSensor source) {
        return Sensors.newStringSensor((String)("mapped." + source.getName()), (String)(source.getDescription() + " (Docker mapping)"));
    }

    public static AttributeSensor<String> endpointSensor(AttributeSensor source) {
        List name = Lists.transform((List)source.getNameParts(), (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                String target = DockerUtils.PORT;
                if (input.equals(target)) {
                    return DockerUtils.ENDPOINT;
                }
                if (input.endsWith(target)) {
                    return input.replace(target, DockerUtils.ENDPOINT);
                }
                target = Strings.toInitialCapOnly((String)DockerUtils.PORT);
                if (input.endsWith(target)) {
                    return input.replace(target, Strings.toInitialCapOnly((String)DockerUtils.ENDPOINT));
                }
                return input;
            }
        });
        if (!name.contains(ENDPOINT)) {
            name.add(ENDPOINT);
        }
        return Sensors.newStringSensor((String)Joiner.on((String)".").join((Iterable)name), (String)(source.getDescription() + " (Docker mapping)"));
    }

    public static void configureEnrichers(SubnetTier subnetTier, Entity entity) {
        for (AttributeSensor sensor : Iterables.filter((Iterable)entity.getEntityType().getSensors(), AttributeSensor.class)) {
            Object target;
            if ((URL_SENSOR_NAMES.contains(sensor.getName()) || sensor.getName().endsWith(".url") || URI.class.isAssignableFrom(sensor.getType())) && !BLACKLIST_URL_SENSOR_NAMES.contains(sensor.getName())) {
                target = DockerUtils.mappedSensor(sensor);
                entity.enrichers().add(subnetTier.uriTransformingEnricher(EntityAndAttribute.create((Entity)entity, (AttributeSensor)sensor), target));
                Set hints = RendererHints.getHintsFor((AttributeSensor)sensor);
                for (RendererHints.Hint hint : hints) {
                    RendererHints.register(target, (RendererHints.Hint)((RendererHints.NamedActionWithUrl)hint));
                }
                LOG.debug("Mapped URL sensor: entity={}, origin={}, mapped={}", new Object[]{entity, sensor.getName(), target.getName()});
                continue;
            }
            if (!sensor.getName().matches("docker\\.port\\.[0-9]+") && !PortAttributeSensorAndConfigKey.class.isAssignableFrom(sensor.getClass())) continue;
            target = DockerUtils.mappedPortSensor(sensor);
            entity.enrichers().add(subnetTier.hostAndPortTransformingEnricher(EntityAndAttribute.create((Entity)entity, (AttributeSensor)sensor), target));
            LOG.debug("Mapped port sensor: entity={}, origin={}, mapped={}", new Object[]{entity, sensor.getName(), target.getName()});
        }
    }

    public static void configurePortMappings(Entity entity) {
        DockerContainer container = (DockerContainer)entity.sensors().get(DockerContainer.CONTAINER);
        DockerContainerLocation location = (DockerContainerLocation)((Object)container.sensors().get(DockerContainer.DYNAMIC_LOCATION));
        Set<Integer> ports = DockerUtils.getContainerPorts(entity);
        for (Integer portNumber : ports) {
            location.obtainSpecificPort(portNumber);
        }
    }

    public static String allowed(String input) {
        return (String)ALLOWED.apply((Object)input);
    }

    public static String checkId(String input) {
        String imageId = Strings.removeFromStart((String)Strings.trim((String)input).toLowerCase(Locale.ENGLISH), (String)SHA_256);
        boolean prefix = input.startsWith(SHA_256);
        if (imageId.length() == 64 && DOCKERFILE_CHARACTERS.matchesAllOf((CharSequence)imageId)) {
            return (prefix ? SHA_256 : "") + imageId;
        }
        throw new IllegalStateException("Invalid image ID returned: " + imageId);
    }

    public static String imageName(Entity entity, String dockerfile) {
        String simpleName = entity.getEntityType().getSimpleName();
        String version = (String)entity.config().get(SoftwareProcess.SUGGESTED_VERSION);
        long hash = HashGenerator.builder().add(simpleName).add(version).add(dockerfile).add(entity, VanillaSoftwareProcess.INSTALL_UNIQUE_LABEL).add(entity, SoftwareProcess.DOWNLOAD_URL.getConfigKey()).add(entity, SoftwareProcess.PRE_INSTALL_FILES).add(entity, SoftwareProcess.PRE_INSTALL_TEMPLATES).add(entity, VanillaSoftwareProcess.PRE_INSTALL_COMMAND).add(entity, VanillaSoftwareProcess.INSTALL_COMMAND).add(entity, (ConfigKey<?>)SoftwareProcess.SHELL_ENVIRONMENT).build();
        return Identifiers.makeIdFromHash((long)hash).toLowerCase(Locale.ENGLISH);
    }

    public static String randomImageName() {
        return Identifiers.makeRandomId((int)12).toLowerCase(Locale.ENGLISH);
    }

    public static boolean isJcloudsLocation(MachineProvisioningLocation location, String providerName) {
        return location instanceof JcloudsLocation && ((JcloudsLocation)location).getProvider().equals(providerName);
    }

    public static String getContainerName(Entity target) {
        String unique = DockerUtils.getUniqueContainerName(target);
        String suffix = "_" + target.getId();
        return Strings.removeFromEnd((String)unique, (String)suffix);
    }

    public static String getUniqueContainerName(Entity target) {
        return (String)Optional.fromNullable((Object)target.sensors().get(DockerContainer.DOCKER_CONTAINER_NAME)).or(Optional.fromNullable((Object)target.config().get(DockerContainer.DOCKER_CONTAINER_NAME))).or(Optional.fromNullable((Object)DockerUtils.getContainerNameFromPlan(target))).or(Optional.fromNullable((Object)target.config().get(DockerContainer.DOCKER_IMAGE_NAME))).or(Optional.fromNullable((Object)target.getId())).transform(ALLOWED).orNull();
    }

    private static String getContainerNameFromPlan(Entity target) {
        String planId = (String)target.config().get(BrooklynCampConstants.PLAN_ID);
        if (planId != null) {
            return planId + "_" + target.getId();
        }
        return null;
    }

    public static String getTargetAddress(Entity source, Entity target) {
        boolean local = ((MachineProvisioningLocation)source.sensors().get(SoftwareProcess.PROVISIONING_LOCATION)).equals(target.sensors().get(SoftwareProcess.PROVISIONING_LOCATION));
        if (local) {
            return (String)target.sensors().get(Attributes.SUBNET_ADDRESS);
        }
        return (String)target.sensors().get(Attributes.ADDRESS);
    }

    public static Map<String, Object> generateLinks(Entity source, Entity target, String alias) {
        Entities.waitForServiceUp((Entity)target);
        String from = DockerUtils.getContainerName(source);
        String to = DockerUtils.getContainerName(target);
        boolean local = ((MachineProvisioningLocation)source.sensors().get(SoftwareProcess.PROVISIONING_LOCATION)).equals(target.sensors().get(SoftwareProcess.PROVISIONING_LOCATION));
        List networks = (List)target.sensors().get(SdnAttributes.ATTACHED_NETWORKS);
        if (Strings.isNonBlank((CharSequence)to)) {
            MutableMap env = MutableMap.of();
            MutableMap targetEnvironment = MutableMap.copyOf((Map)((Map)target.getConfig(DockerContainer.DOCKER_CONTAINER_ENVIRONMENT.getConfigKey())));
            if (target.getConfig(DockerContainer.DOCKER_CONTAINER_ENVIRONMENT.getConfigKey()) != null) {
                for (Map.Entry envvar : targetEnvironment.entrySet()) {
                    env.put(String.format("%S_ENV_%S", alias, envvar.getKey()), envvar.getValue().toString());
                }
            }
            String address = DockerUtils.getTargetAddress(source, target);
            MutableMap ports = MutableMap.of();
            MutableSet containerPorts = MutableSet.copyOf((Iterable)((Iterable)target.sensors().get(DockerAttributes.DOCKER_CONTAINER_OPEN_PORTS)));
            if (containerPorts.size() > 0) {
                for (Integer port : containerPorts) {
                    AttributeSensor sensor = Sensors.newStringSensor((String)String.format("mapped.docker.port.%d", port));
                    String hostAndPort = (String)target.sensors().get(sensor);
                    if (local && networks != null && networks.size() > 0 || hostAndPort == null) {
                        ports.put(port, port);
                        continue;
                    }
                    ports.put(HostAndPort.fromString((String)hostAndPort).getPort(), port);
                }
            } else {
                ports = ImmutableMap.copyOf(DockerUtils.getMappedPorts(target));
            }
            for (Integer port : ports.keySet()) {
                Integer containerPort = (Integer)ports.get(port);
                env.put(String.format("%S_NAME", alias), String.format("/%s/%s", from, alias));
                env.put(String.format("%S_PORT", alias), String.format("tcp://%s:%d", address, port));
                env.put(String.format("%S_PORT_%d_TCP", alias, containerPort), String.format("tcp://%s:%d", address, port));
                env.put(String.format("%S_PORT_%d_TCP_ADDR", alias, containerPort), address);
                env.put(String.format("%S_PORT_%d_TCP_PORT", alias, containerPort), port);
                env.put(String.format("%S_PORT_%d_TCP_PROTO", alias, containerPort), "tcp");
            }
            LOG.debug("Links for {}: {}", (Object)to, (Object)Joiner.on((String)" ").withKeyValueSeparator("=").join((Map)env));
            return env;
        }
        LOG.warn("Cannot generate links for {}: no name specified", (Object)target);
        return ImmutableMap.of();
    }

    public static Map<Integer, Integer> getMappedPorts(Entity entity) {
        MutableMap ports = MutableMap.of();
        for (ConfigKey k : entity.getEntityType().getConfigKeys()) {
            PortRange r;
            Integer p;
            if (k instanceof PortAttributeSensorAndConfigKey) {
                String name = ((PortAttributeSensorAndConfigKey)k).getName();
                p = (Integer)((PortAttributeSensorAndConfigKey)k).getAsSensorValue(entity);
                Integer m = (Integer)entity.sensors().get(Sensors.newIntegerSensor((String)("mapped." + name)));
                if (m == null) {
                    ports.put(p, p);
                    continue;
                }
                ports.put(m, p);
                continue;
            }
            if (!PortRange.class.isAssignableFrom(k.getType()) || (r = (PortRange)entity.config().get(k)) == null || r.isEmpty()) continue;
            p = (Integer)r.iterator().next();
            ports.put(p, p);
        }
        for (Entity child : entity.getChildren()) {
            ports.putAll(DockerUtils.getMappedPorts(child));
        }
        return ImmutableMap.copyOf((Map)ports);
    }

    public static Set<Integer> getOpenPorts(Entity entity) {
        MutableSet ports = MutableSet.of((Object)22);
        ports.addAll(DockerUtils.getMappedPorts(entity).keySet());
        return ImmutableSet.copyOf((Collection)ports);
    }

    public static Set<Integer> getContainerPorts(Entity entity) {
        Map portBindings;
        List entityPortConfig;
        MutableList entityOpenPorts = MutableList.of();
        List openPorts = (List)entity.config().get(DockerAttributes.DOCKER_OPEN_PORTS);
        if (openPorts != null) {
            entityOpenPorts.addAll(openPorts);
        }
        if ((entityPortConfig = (List)entity.config().get(DockerAttributes.DOCKER_OPEN_PORT_CONFIG)) != null) {
            for (PortAttributeSensorAndConfigKey key : entityPortConfig) {
                Integer port;
                PortRange range = (PortRange)entity.config().get((ConfigKey.HasConfigKey)key);
                if (range == null || range.isEmpty() || (port = (Integer)range.iterator().next()) == null) continue;
                openPorts.add(port);
            }
        }
        if ((portBindings = (Map)entity.sensors().get(DockerAttributes.DOCKER_CONTAINER_PORT_BINDINGS)) != null) {
            entityOpenPorts.addAll(portBindings.values());
        }
        if (entityOpenPorts.size() > 0) {
            for (int i = 0; i < entityOpenPorts.size(); ++i) {
                Integer port = (Integer)entityOpenPorts.get(i);
                String name = String.format("docker.port.%d", port);
                entity.sensors().set(Sensors.newIntegerSensor((String)name), (Object)port);
                entity.config().set(ConfigKeys.newConfigKey(PortRange.class, (String)name), (Object)PortRanges.fromInteger((int)port));
            }
        }
        return ImmutableSet.copyOf((Collection)entityOpenPorts);
    }

    public static final void stop(Entity caller, Entity target, Duration timeout) {
        boolean stopped;
        if (target != null && Entities.isManaged((Entity)target) && !(stopped = Entities.invokeEffector((Entity)caller, (Entity)target, (Effector)Startable.STOP).blockUntilEnded(timeout))) {
            LOG.debug("{} may not have stopped. Proceeding to stop {} anyway", (Object)target, (Object)caller);
        }
    }

    public static final Predicate<Entity> sameInfrastructure(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity");
        return new SameInfrastructurePredicate(entity.getId());
    }

    public static void addExtraPublicKeys(Entity entity, SshMachineLocation location) {
        String extraPublicKey = (String)location.config().get(JcloudsLocationConfig.EXTRA_PUBLIC_KEY_DATA_TO_AUTH);
        if (extraPublicKey == null) {
            extraPublicKey = (String)entity.config().get(JcloudsLocationConfig.EXTRA_PUBLIC_KEY_DATA_TO_AUTH);
        }
        if (extraPublicKey != null) {
            LOG.info(location + ": Adding public key " + extraPublicKey);
            String cmd = "mkdir -p ~/.ssh && cat <<EOF >> ~/.ssh/authorized_keys\n" + extraPublicKey + "\nEOF\n";
            ProcessTaskWrapper task = (ProcessTaskWrapper)SshTasks.newSshExecTaskFactory((SshMachineLocation)location, (String[])new String[]{cmd}).summary("Add public key").requiringExitCodeZero().newTask();
            BrooklynTaskTags.markInessential((TaskAdaptable)task);
            DynamicTasks.queueIfPossible((TaskAdaptable)task).orSubmitAsync(entity);
        }
    }

    public static class SameInfrastructurePredicate
    implements Predicate<Entity> {
        private final String id;

        public SameInfrastructurePredicate(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        }

        public boolean apply(@Nullable Entity input) {
            Optional lookup = Iterables.tryFind((Iterable)input.getLocations(), (Predicate)Predicates.instanceOf(DockerContainerLocation.class));
            if (lookup.isPresent()) {
                DockerContainerLocation container = (DockerContainerLocation)((Object)lookup.get());
                return this.id.equals(container.getOwner().getDockerHost().getInfrastructure().getId());
            }
            return false;
        }
    }

    private static class HashGenerator {
        private long hash;

        static HashGenerator builder() {
            return new HashGenerator();
        }

        private HashGenerator() {
        }

        public HashGenerator add(String val) {
            this.hash = this.hash * 31L + (val == null ? 0L : Hashing.md5().hashString((CharSequence)val, Charsets.UTF_8).asLong());
            return this;
        }

        public HashGenerator add(Entity entity, ConfigKey<?> key) {
            Maybe value = ((BrooklynObjectInternal.ConfigurationSupportInternal)entity.config()).getNonBlocking(key);
            if (value.isPresent()) {
                this.hash = this.hash * 31L + (long)(value.get() == null ? 0 : value.get().hashCode());
            }
            return this;
        }

        public long build() {
            return this.hash;
        }
    }
}

