/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity;

import brooklyn.networking.subnet.SubnetTier;
import clocker.docker.entity.DockerHostImpl;
import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.location.strategy.affinity.AffinityRules;
import com.google.common.base.Optional;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.objs.HasShortName;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.location.dynamic.LocationOwner;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.machine.MachineEntity;
import org.apache.brooklyn.entity.nosql.etcd.EtcdNode;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.net.domain.IpPermission;

@ImplementedBy(value=DockerHostImpl.class)
public interface DockerHost
extends MachineEntity,
HasShortName,
LocationOwner<DockerHostLocation, DockerHost> {
    @SetFromFlag(value="dockerVersion")
    public static final ConfigKey<String> DOCKER_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"1.10.3");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"docker-%s");
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"https://get.docker.com/");
    @SetFromFlag(value="dockerPort")
    public static final PortAttributeSensorAndConfigKey DOCKER_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"docker.port", (String)"Docker port", (Object)PortRanges.fromInteger((int)2375));
    @SetFromFlag(value="dockerSslPort")
    public static final PortAttributeSensorAndConfigKey DOCKER_SSL_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"docker.ssl.port", (String)"Docker SSL port", (Object)PortRanges.fromInteger((int)2376));
    public static final ConfigKey<Integer> DOCKER_CONTROL_PLANE_PORT = ConfigKeys.newIntegerConfigKey((String)"docker.control.port", (String)"Docker control plane port (TCP and UDP)", (Integer)7946);
    public static final ConfigKey<Integer> DOCKER_DATA_PLANE_PORT = ConfigKeys.newIntegerConfigKey((String)"docker.data.port", (String)"Docker data plane port (UDP)", (Integer)4789);
    @SetFromFlag(value="openIptables")
    public static final ConfigKey<Boolean> OPEN_IPTABLES = ConfigKeys.newConfigKeyWithPrefix((String)"docker.host.", (ConfigKey)SoftwareProcess.OPEN_IPTABLES);
    @SetFromFlag(value="useSsh")
    public static final ConfigKey<Boolean> DOCKER_USE_SSH = DockerAttributes.DOCKER_USE_SSH;
    @SetFromFlag(value="containerSpec")
    public static final AttributeSensorAndConfigKey<EntitySpec, EntitySpec> DOCKER_CONTAINER_SPEC = ConfigKeys.newSensorAndConfigKey(EntitySpec.class, (String)"docker.container.spec", (String)"Specification to use when creating child Docker container", (Object)EntitySpec.create(DockerContainer.class));
    @SetFromFlag(value="infrastructure")
    public static final AttributeSensorAndConfigKey<Entity, Entity> DOCKER_INFRASTRUCTURE = DockerAttributes.DOCKER_INFRASTRUCTURE;
    public static final ConfigKey<String> EPEL_RELEASE = ConfigKeys.newStringConfigKey((String)"docker.host.epel.release", (String)"EPEL release for yum based OS", (String)"6-8");
    public static final ConfigKey<String> DOCKER_STORAGE_DRIVER = ConfigKeys.newStringConfigKey((String)"docker.host.driver.storage", (String)"The Docker storage driver type ('devicemapper', 'btrfs', 'aufs' or 'overlay', null uses Docker default)");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_ID = DockerAttributes.DOCKER_IMAGE_ID;
    public static final AttributeSensor<String> DOCKER_IMAGE_NAME = DockerAttributes.DOCKER_IMAGE_NAME;
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_HARDWARE_ID = DockerAttributes.DOCKER_HARDWARE_ID;
    @SetFromFlag(value="volumeMappings")
    public static final AttributeSensorAndConfigKey<Map<String, String>, Map<String, String>> DOCKER_HOST_VOLUME_MAPPING = DockerAttributes.DOCKER_HOST_VOLUME_MAPPING;
    @SetFromFlag(value="password")
    public static final ConfigKey<String> DOCKER_LOGIN_PASSWORD = DockerAttributes.DOCKER_LOGIN_PASSWORD;
    @SetFromFlag(value="affinityRules")
    public static final ConfigKey<List<String>> DOCKER_HOST_AFFINITY_RULES = AffinityRules.AFFINITY_RULES;
    @SetFromFlag(value="provisioningFlags")
    public static final ConfigKey<Map<String, Object>> PROVISIONING_FLAGS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, Object>>(){}, (String)"docker.host.flags", (String)"Provisioning flags for the Docker hosts", (Object)MutableMap.of());
    @SetFromFlag(value="scanInterval")
    public static final ConfigKey<Duration> SCAN_INTERVAL = ConfigKeys.newConfigKey(Duration.class, (String)"docker.host.scanInterval", (String)"Interval between scans of Docker containers", (Object)Duration.THIRTY_SECONDS);
    public static final AttributeSensor<Void> SCAN = Sensors.newSensor(Void.class, (String)"docker.host.scan", (String)"Notification of host scan");
    public static final AttributeSensor<Group> DOCKER_CONTAINER_CLUSTER = Sensors.newSensor(Group.class, (String)"docker.container.cluster", (String)"The cluster of Docker containers");
    public static final AttributeSensor<JcloudsLocation> JCLOUDS_DOCKER_LOCATION = Sensors.newSensor(JcloudsLocation.class, (String)"docker.jclouds.location", (String)"The location used for provisioning Docker containers");
    public static final AttributeSensor<SubnetTier> DOCKER_HOST_SUBNET_TIER = Sensors.newSensor(SubnetTier.class, (String)"docker.subnetTier", (String)"The SubnetTier for Docker port mapping");
    @SetFromFlag(value="addLocalhostPermission")
    public static final ConfigKey<Boolean> ADD_LOCALHOST_PERMISSION = ConfigKeys.newBooleanConfigKey((String)"docker.addLocalhostPermission", (String)"When true, will add the localhost IP address to the docker host as an acceptable ingress address. This is useful when running Clocker in the same network as the hosts will be run in (e.g. same AWS availibility zone).", (Boolean)false);
    public static final AttributeSensor<EtcdNode> ETCD_NODE = Sensors.newSensor(EtcdNode.class, (String)"etcd.node", (String)"The EtcdNode attached to this DockerHost");
    public static final MethodEffector<String> BUILD_IMAGE = new MethodEffector(DockerHost.class, "buildImage");
    public static final MethodEffector<String> RUN_DOCKER_COMMAND = new MethodEffector(DockerHost.class, "runDockerCommand");
    public static final MethodEffector<String> RUN_DOCKER_COMMAND_TIMEOUT = new MethodEffector(DockerHost.class, "runDockerCommandTimeout");
    public static final MethodEffector<String> DEPLOY_ARCHIVE = new MethodEffector(DockerHost.class, "deployArchive");

    public String getLoginPassword();

    public Integer getDockerPort();

    public JcloudsLocation getJcloudsLocation();

    public SubnetTier getSubnetTier();

    public Group getDockerContainerCluster();

    public List<Entity> getDockerContainerList();

    public Integer getCurrentSize();

    public DockerInfrastructure getInfrastructure();

    public int execCommandStatusTimeout(String var1, Duration var2);

    public int execCommandStatus(String var1);

    public Optional<String> getImageNamed(String var1);

    public Optional<String> getImageNamed(String var1, String var2);

    public void configureSecurityGroups();

    public void addIpPermissions(Collection<IpPermission> var1);

    public void removeIpPermissions(Collection<IpPermission> var1);

    public Object getHostMutex();

    @Effector(description="Create an image from a Dockerfile and entrypoint script and return the image ID")
    public String buildImage(@EffectorParam(name="dockerfile", description="URL of Dockerfile template") String var1, @EffectorParam(name="entrypoint", description="URL of entrypoint script") String var2, @EffectorParam(name="contextArchive", description="URL of context archive") String var3, @EffectorParam(name="name", description="Registry name") String var4, @EffectorParam(name="useSsh", description="Add an SSHable layer after building") boolean var5, @EffectorParam(name="substitutions", description="Extra template substitutions for the Dockerfile") Map<String, Object> var6);

    @Effector(description="Create an SSHable image based on the fullyQualifiedName provided")
    public String layerSshableImageOnFullyQualified(@EffectorParam(name="fullyQualifiedName", description="The fully qualified name to layer on") String var1);

    @Effector(description="Create an SSHable image based on the named image and return its ID")
    public String layerSshableImageOn(@EffectorParam(name="baseImage", description="The image's name") String var1, @EffectorParam(name="tag", description="The image's tag, e.g. latest") String var2);

    @Effector(description="Execute a Docker command and return the output")
    public String runDockerCommand(@EffectorParam(name="command", description="Docker command") String var1);

    @Effector(description="Execute a Docker command and return the output")
    public String runDockerCommandTimeout(@EffectorParam(name="command", description="Docker command") String var1, @EffectorParam(name="timeout", description="Timeout") Duration var2);

    @Effector(description="Upload an archive file to the host and expand it, for export to a container")
    public String deployArchive(@EffectorParam(name="url", description="Archive source URL") String var1);
}

