/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.test;

import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.location.DockerLocation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.factory.ApplicationBuilder;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.entity.software.base.EmptySoftwareProcess;
import org.apache.brooklyn.test.EntityTestUtils;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInfrastructureTests {
    private static final Logger LOG = LoggerFactory.getLogger(DockerInfrastructureTests.class);

    private DockerInfrastructureTests() {
    }

    public static DockerInfrastructure deployAndWaitForDockerInfrastructure(TestApplication app, Location location) {
        DockerInfrastructure dockerInfrastructure = (DockerInfrastructure)app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(DockerInfrastructure.class).configure(DockerInfrastructure.DOCKER_HOST_CLUSTER_MIN_SIZE, (Object)1)).configure(DockerInfrastructure.SDN_ENABLE, (Object)false)).displayName("Docker Infrastructure"));
        LOG.info("Starting {} in {}", (Object)dockerInfrastructure, (Object)location);
        app.start((Collection)ImmutableList.of((Object)location));
        DockerLocation dockerLocation = (DockerLocation)dockerInfrastructure.getDynamicLocation();
        LOG.info("Waiting {} for {} to have started", (Object)Duration.TWO_MINUTES, (Object)dockerInfrastructure);
        EntityTestUtils.assertAttributeEqualsEventually((Map)ImmutableMap.of((Object)"timeout", (Object)Duration.FIVE_MINUTES), (Entity)dockerInfrastructure, (AttributeSensor)Attributes.SERVICE_UP, (Object)true);
        return dockerInfrastructure;
    }

    public static void testDeploysTrivialApplication(TestApplication app, Location location) {
        DockerInfrastructure dockerInfrastructure = DockerInfrastructureTests.deployAndWaitForDockerInfrastructure(app, location);
        int existingCount = (Integer)dockerInfrastructure.sensors().get(DockerInfrastructure.DOCKER_CONTAINER_COUNT);
        TestApplication deployment = (TestApplication)ApplicationBuilder.newManagedApp(TestApplication.class, (ManagementContext)app.getManagementContext());
        deployment.createAndManageChild(EntitySpec.create(EmptySoftwareProcess.class));
        deployment.start((Collection)ImmutableList.of((Object)dockerInfrastructure.getDynamicLocation()));
        EntityTestUtils.assertAttributeEqualsEventually((Entity)deployment, (AttributeSensor)Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.RUNNING);
        EntityTestUtils.assertAttributeEqualsEventually((Entity)dockerInfrastructure, (AttributeSensor)DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)(existingCount + 1));
        deployment.stop();
    }
}

