/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn.util;

import clocker.docker.entity.DockerHost;
import clocker.docker.networking.entity.VirtualNetwork;
import clocker.docker.networking.entity.sdn.SdnProvider;
import clocker.docker.networking.entity.sdn.util.SdnAttributes;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdnUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SdnUtils.class);

    private SdnUtils() {
    }

    public static final boolean isSdnProvider(Entity entity, String providerName) {
        if (((Boolean)entity.config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
            Entity sdn = (Entity)entity.sensors().get(SdnAttributes.SDN_PROVIDER);
            if (sdn == null) {
                return false;
            }
            return sdn.getEntityType().getSimpleName().equalsIgnoreCase(providerName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VirtualNetwork createNetwork(SdnProvider provider, String networkId) {
        boolean createNetwork = false;
        Cidr subnetCidr = null;
        VirtualNetwork network = null;
        Object object = provider.getNetworkMutex();
        synchronized (object) {
            subnetCidr = provider.getSubnetCidr(networkId);
            if (subnetCidr == null) {
                subnetCidr = provider.getNextSubnetCidr(networkId);
                createNetwork = true;
            }
        }
        if (createNetwork) {
            EntitySpec networkSpec = (EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(VirtualNetwork.class).configure(SdnAttributes.SDN_PROVIDER, (Object)provider)).configure(VirtualNetwork.NETWORK_ID, (Object)networkId)).configure(VirtualNetwork.NETWORK_CIDR, (Object)subnetCidr);
            network = (VirtualNetwork)((Group)provider.sensors().get(SdnProvider.SDN_NETWORKS)).addChild(networkSpec);
            Entities.start((Entity)network, (Collection)provider.getLocations());
            Entities.waitForServiceUp((Entity)network);
        } else {
            network = SdnUtils.lookupNetwork(provider, networkId);
        }
        return network;
    }

    public static final VirtualNetwork lookupNetwork(final SdnProvider provider, final String networkId) {
        Task lookup = TaskBuilder.builder().displayName("Waiting until virtual network is available").body((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Repeater.create().every(Duration.TEN_SECONDS).until((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        Optional found = Iterables.tryFind((Iterable)((Group)provider.sensors().get(SdnProvider.SDN_NETWORKS)).getMembers(), (Predicate)EntityPredicates.attributeEqualTo(VirtualNetwork.NETWORK_ID, (Object)networkId));
                        return found.isPresent();
                    }
                }).limitTimeTo(Duration.ONE_MINUTE).run();
            }
        }).build();
        Boolean result = (Boolean)DynamicTasks.queueIfPossible((TaskAdaptable)lookup).orSubmitAndBlock().andWaitForSuccess();
        if (!result.booleanValue()) {
            throw new IllegalStateException(String.format("Cannot find virtual network entity for %s", networkId));
        }
        VirtualNetwork network = (VirtualNetwork)Iterables.find((Iterable)((Group)provider.sensors().get(SdnProvider.SDN_NETWORKS)).getMembers(), (Predicate)EntityPredicates.attributeEqualTo(VirtualNetwork.NETWORK_ID, (Object)networkId));
        return network;
    }

    public static final Cidr provisionNetwork(SdnProvider provider, VirtualNetwork network) {
        String networkId = (String)network.sensors().get(VirtualNetwork.NETWORK_ID);
        Cidr subnetCidr = (Cidr)network.config().get(VirtualNetwork.NETWORK_CIDR);
        if (subnetCidr == null) {
            subnetCidr = provider.getNextSubnetCidr(networkId);
        } else {
            provider.recordSubnetCidr(networkId, subnetCidr);
        }
        network.sensors().set(VirtualNetwork.NETWORK_CIDR, (Object)subnetCidr);
        return subnetCidr;
    }

    public static final Predicate<Entity> attachedToNetwork(String networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)"networkId");
        return new AttachedToNetworkPredicate(networkId);
    }

    public static final int countAttached(DockerHost dockerHost, String networkId) {
        Entity etcd = (Entity)dockerHost.sensors().get(DockerHost.ETCD_NODE);
        String installDir = (String)etcd.sensors().get((AttributeSensor)SoftwareProcess.EXPANDED_INSTALL_DIR);
        String fullNetworkId = dockerHost.runDockerCommand(String.format("network inspect --format=\"{{ .ID }}\" %s", networkId));
        String output = dockerHost.execCommand(String.format("%s/etcdctl ls /docker/network/v1.0/endpoint/%s", installDir, fullNetworkId));
        int attached = Iterables.size((Iterable)Splitter.on((String)"\n").split((CharSequence)output));
        return attached;
    }

    public static class AttachedToNetworkPredicate
    implements Predicate<Entity> {
        private final String id;

        public AttachedToNetworkPredicate(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        }

        public boolean apply(@Nullable Entity input) {
            List networks = (List)input.sensors().get(SdnAttributes.ATTACHED_NETWORKS);
            if (networks != null) {
                return networks.contains(this.id);
            }
            return false;
        }
    }
}

