/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn;

import clocker.docker.networking.entity.VirtualNetwork;
import clocker.docker.networking.location.NetworkProvisioningExtension;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.stock.BasicStartable;
import org.apache.brooklyn.util.net.Cidr;

public interface SdnProvider
extends BasicStartable,
NetworkProvisioningExtension {
    public static final AttributeSensor<Cidr> APPLICATION_CIDR = Sensors.newSensor(Cidr.class, (String)"sdn.application.cidr", (String)"CIDR for application running in container");
    public static final ConfigKey<Cidr> CONTAINER_NETWORK_CIDR = ConfigKeys.newConfigKey(Cidr.class, (String)"sdn.network.cidr", (String)"Pool CIDR for network allocation to containers", (Object)Cidr.LINK_LOCAL);
    public static final ConfigKey<Integer> CONTAINER_NETWORK_SIZE = ConfigKeys.newIntegerConfigKey((String)"sdn.network.size", (String)"Size of network subnets as CIDR length (e.g. 24 for 254 hosts)", (Integer)24);
    public static final AttributeSensor<Integer> ALLOCATED_NETWORKS = Sensors.newIntegerSensor((String)"sdn.networks.allocated", (String)"Number of allocated networks");
    public static final AttributeSensor<Map<String, Cidr>> SUBNETS = Sensors.newSensor((TypeToken)new TypeToken<Map<String, Cidr>>(){}, (String)"sdn.networks.addresses", (String)"Map of network subnets that have been created");
    public static final AttributeSensor<Map<String, VirtualNetwork>> SUBNET_ENTITIES = Sensors.newSensor((TypeToken)new TypeToken<Map<String, VirtualNetwork>>(){}, (String)"sdn.networks.entities", (String)"Map of managed network entities that have been created by this SDN");
    public static final AttributeSensor<Map<String, List<InetAddress>>> SUBNET_ADDRESS_ALLOCATIONS = Sensors.newSensor((TypeToken)new TypeToken<Map<String, List<InetAddress>>>(){}, (String)"sdn.networks.addresses.allocated", (String)"Map of allocated address count on network subnets");
    public static final AttributeSensor<Multimap<String, InetAddress>> CONTAINER_ADDRESSES = Sensors.newSensor((TypeToken)new TypeToken<Multimap<String, InetAddress>>(){}, (String)"sdn.container.addresses", (String)"Map of container ID to IP addresses on network");
    public static final AttributeSensor<Group> SDN_NETWORKS = Sensors.newSensor(Group.class, (String)"sdn.networks.managed", (String)"Collection of virtual network entites managed by this SDN");
    public static final AttributeSensor<Group> SDN_APPLICATIONS = Sensors.newSensor(Group.class, (String)"sdn.networks.applications", (String)"Groupings of application containers attached to each managed network");

    public InetAddress getNextContainerAddress(String var1);

    public void recordContainerAddress(String var1, InetAddress var2);

    public void associateContainerAddress(String var1, InetAddress var2);

    public Cidr getNextSubnetCidr(String var1);

    public Cidr getNextSubnetCidr();

    public void recordSubnetCidr(String var1, Cidr var2);

    public Cidr getSubnetCidr(String var1);

    public Object getNetworkMutex();
}

