/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn;

import clocker.docker.entity.DockerHost;
import clocker.docker.networking.entity.VirtualNetwork;
import clocker.docker.networking.entity.sdn.SdnProvider;
import java.net.InetAddress;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

public interface SdnAgent
extends SoftwareProcess {
    @SetFromFlag(value="host")
    public static final AttributeSensorAndConfigKey<DockerHost, DockerHost> DOCKER_HOST = ConfigKeys.newSensorAndConfigKey(DockerHost.class, (String)"sdn.agent.docker.host", (String)"Docker host we are running on");
    @SetFromFlag(value="provider")
    public static final AttributeSensorAndConfigKey<SdnProvider, SdnProvider> SDN_PROVIDER = ConfigKeys.newSensorAndConfigKey(SdnProvider.class, (String)"sdn.provider", (String)"SDN provider entity");
    public static final AttributeSensor<InetAddress> SDN_AGENT_ADDRESS = Sensors.newSensor(InetAddress.class, (String)"sdn.agent.address", (String)"IP address of SDN agent service");
    public static final AttributeSensor<SdnAgent> SDN_AGENT = Sensors.newSensor(SdnAgent.class, (String)"sdn.agent.entity", (String)"SDN agent entity");
    public static final MethodEffector<InetAddress> CREATE_NETWORK = new MethodEffector(SdnAgent.class, "createNetwork");
    public static final MethodEffector<InetAddress> ATTACH_NETWORK = new MethodEffector(SdnAgent.class, "attachNetwork");

    public DockerHost getDockerHost();

    public String provisionNetwork(VirtualNetwork var1);

    public void deallocateNetwork(VirtualNetwork var1);

    @Effector(description="Create a network")
    public VirtualNetwork createNetwork(@EffectorParam(name="networkId", description="Network ID") String var1);

    @Effector(description="Attach a container to a network")
    public InetAddress attachNetwork(@EffectorParam(name="containerId", description="Container ID") String var1, @EffectorParam(name="networkId", description="Network ID") String var2);
}

