/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location.strategy.basic;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.location.strategy.BasicDockerPlacementStrategy;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.entity.group.BasicGroup;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxContainersPlacementStrategy
extends BasicDockerPlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MaxContainersPlacementStrategy.class);
    @SetFromFlag(value="maxContainers")
    public static final ConfigKey<Integer> DOCKER_CONTAINER_CLUSTER_MAX_SIZE = ConfigKeys.newIntegerConfigKey((String)"docker.container.cluster.maxSize", (String)"Maximum size of a Docker container cluster");
    public static final Integer DEFAULT_MAX_CONTAINERS = 8;

    @Override
    public boolean apply(DockerHostLocation input) {
        Integer currentSize;
        Integer infrastructureMax;
        Integer maxSize = (Integer)this.config().get(DOCKER_CONTAINER_CLUSTER_MAX_SIZE);
        DockerInfrastructure infrastructure = (DockerInfrastructure)this.config().get(DOCKER_INFRASTRUCTURE);
        if (infrastructure != null && (infrastructureMax = (Integer)infrastructure.config().get(DOCKER_CONTAINER_CLUSTER_MAX_SIZE)) != null) {
            maxSize = infrastructureMax;
        }
        if (maxSize == null) {
            maxSize = DEFAULT_MAX_CONTAINERS;
        }
        boolean accept = (currentSize = (Integer)((Group)input.getOwner().sensors().get(DockerHost.DOCKER_CONTAINER_CLUSTER)).sensors().get(BasicGroup.GROUP_SIZE)) < maxSize;
        LOG.debug("Location {} size is {}/{}: {}", new Object[]{input, currentSize, maxSize, accept ? "accepted" : "rejected"});
        return accept;
    }
}

