/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location.strategy.basic;

import clocker.docker.location.DockerHostLocation;
import clocker.docker.location.strategy.BasicDockerPlacementStrategy;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.jclouds.compute.domain.NodeMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelPlacementStrategy
extends BasicDockerPlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(LabelPlacementStrategy.class);
    @SetFromFlag(value="labels")
    public static final ConfigKey<List<String>> LABELS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"docker.constraint.labels", (String)"The list of required labels", (Object)ImmutableList.of());

    @Override
    public boolean apply(DockerHostLocation input) {
        MutableSet labels = MutableSet.copyOf((Iterable)((Iterable)this.config().get(LABELS)));
        if (labels.isEmpty()) {
            return true;
        }
        SshMachineLocation ssh = input.getMachine();
        if (ssh instanceof JcloudsSshMachineLocation) {
            JcloudsSshMachineLocation jclouds = (JcloudsSshMachineLocation)ssh;
            NodeMetadata metadata = (NodeMetadata)jclouds.getOptionalNode().get();
            MutableSet tags = MutableSet.copyOf((Iterable)Iterables.transform((Iterable)metadata.getTags(), (Function)new Function<String, String>(){

                public String apply(String input) {
                    return (String)Iterables.get((Iterable)Splitter.on((String)"=").split((CharSequence)input), (int)0);
                }
            }));
            tags.addAll(metadata.getUserMetadata().keySet());
            labels.removeAll((Collection<?>)tags);
            LOG.debug("Host {} : Tags {} : Remaining {}", new Object[]{input, Iterables.toString((Iterable)tags), labels.isEmpty() ? "none" : Iterables.toString((Iterable)labels)});
            return labels.isEmpty();
        }
        return false;
    }
}

