/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.location.DockerContainerLocation;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.location.DockerVirtualLocation;
import clocker.docker.location.strategy.DockerAwarePlacementStrategy;
import clocker.docker.networking.location.NetworkProvisioningExtension;
import clocker.docker.policy.ContainerHeadroomEnricher;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.mgmt.rebind.RebindContext;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.LocationMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.BasicLocationDefinition;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.dynamic.DynamicLocation;
import org.apache.brooklyn.core.mgmt.rebind.BasicLocationRebindSupport;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.policy.autoscaling.AutoScalerPolicy;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerLocation
extends AbstractLocation
implements DockerVirtualLocation,
MachineProvisioningLocation<MachineLocation>,
DynamicLocation<DockerInfrastructure, DockerLocation>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DockerLocation.class);
    public static final ConfigKey<String> LOCATION_NAME = ConfigKeys.newStringConfigKey((String)"locationName");
    @SetFromFlag(value="strategies")
    private List<DockerAwarePlacementStrategy> strategies;
    @SetFromFlag(value="provisioner")
    private MachineProvisioningLocation<SshMachineLocation> provisioner;
    @SetFromFlag(value="machines")
    private final SetMultimap<DockerHostLocation, String> containers = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    @SetFromFlag(value="locationRegistrationId")
    private String locationRegistrationId;
    private transient DockerInfrastructure infrastructure;
    private transient Semaphore permit = new Semaphore(1);

    public DockerLocation() {
        this(Maps.newLinkedHashMap());
    }

    public DockerLocation(Map properties) {
        super(properties);
        if (this.isLegacyConstruction()) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.infrastructure = this.isRebinding() ? (DockerInfrastructure)this.getConfig(OWNER) : (DockerInfrastructure)Preconditions.checkNotNull((Object)this.getConfig(OWNER), (Object)"owner");
    }

    public void rebind() {
        super.rebind();
        this.infrastructure = (DockerInfrastructure)this.getConfig(OWNER);
        if (this.infrastructure != null && this.getConfig(LOCATION_NAME) != null) {
            this.register();
        }
    }

    public LocationDefinition register() {
        String locationName = (String)Preconditions.checkNotNull((Object)this.getConfig(LOCATION_NAME), (String)"config %s", (Object[])new Object[]{LOCATION_NAME.getName()});
        LocationDefinition check = this.getManagementContext().getLocationRegistry().getDefinedLocationByName(locationName);
        if (check != null) {
            throw new IllegalStateException("Location " + locationName + " is already defined: " + check);
        }
        String locationSpec = String.format("docker:%s", this.getId()) + String.format(":(name=\"%s\")", locationName);
        BasicLocationDefinition definition = new BasicLocationDefinition(locationName, locationSpec, (Map)ImmutableMap.of());
        this.getManagementContext().getLocationRegistry().updateDefinedLocation((LocationDefinition)definition);
        this.locationRegistrationId = definition.getId();
        this.requestPersist();
        return definition;
    }

    public void deregister() {
        if (this.locationRegistrationId != null) {
            this.getManagementContext().getLocationRegistry().removeDefinedLocation(this.locationRegistrationId);
            this.locationRegistrationId = null;
            this.requestPersist();
        }
    }

    public MachineProvisioningLocation<SshMachineLocation> getProvisioner() {
        return this.provisioner;
    }

    protected List<DockerHostLocation> getDockerHostLocations() {
        ArrayList result = Lists.newArrayList();
        for (Entity entity : this.getDockerHostList()) {
            DockerHost host = (DockerHost)entity;
            DockerHostLocation machine = (DockerHostLocation)host.getDynamicLocation();
            result.add(Optional.fromNullable((Object)machine));
        }
        return ImmutableList.copyOf((Iterable)Optional.presentInstances((Iterable)result));
    }

    public MachineLocation obtain() throws NoMachinesAvailableException {
        return this.obtain(Maps.newLinkedHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MachineLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        DockerHost dockerHost;
        DockerHostLocation machine;
        List entityStrategies;
        Entity entity;
        block25: {
            Object context = flags.get(LocationConfigKeys.CALLER_CONTEXT.getName());
            if (context != null && !(context instanceof Entity)) {
                throw new IllegalStateException("Invalid location context: " + context);
            }
            entity = (Entity)context;
            List<DockerHostLocation> available = this.getDockerHostLocations();
            LOG.debug("Placement for: {}", (Object)Iterables.toString((Iterable)Iterables.transform(available, (Function)EntityFunctions.id())));
            entityStrategies = (List)entity.config().get(DockerAttributes.PLACEMENT_STRATEGIES);
            if (entityStrategies == null) {
                entityStrategies = ImmutableList.of();
            }
            for (DockerAwarePlacementStrategy strategy : Iterables.concat(this.strategies, (Iterable)entityStrategies)) {
                available = strategy.filterLocations(available, entity);
                LOG.debug("Placement after {}: {}", (Object)strategy, (Object)Iterables.toString((Iterable)Iterables.transform(available, (Function)EntityFunctions.id())));
            }
            machine = null;
            dockerHost = null;
            if (available.size() > 0) {
                machine = available.get(0);
                dockerHost = machine.getOwner();
            } else {
                if (this.permit.tryAcquire()) {
                    try {
                        Integer headroom = (Integer)this.getOwner().config().get(ContainerHeadroomEnricher.CONTAINER_HEADROOM);
                        Double headroomPercent = (Double)this.getOwner().config().get(ContainerHeadroomEnricher.CONTAINER_HEADROOM_PERCENTAGE);
                        boolean headroomSet = headroom != null && headroom > 0 || headroomPercent != null && headroomPercent > 0.0;
                        Optional policy = Iterables.tryFind((Iterable)this.getOwner().getDockerHostCluster().policies(), (Predicate)Predicates.instanceOf(AutoScalerPolicy.class));
                        if (headroomSet && policy.isPresent()) {
                            ((Policy)policy.get()).suspend();
                        }
                        try {
                            LOG.info("Provisioning new host");
                            Entity added = (Entity)Iterables.getOnlyElement((Iterable)this.getOwner().getDockerHostCluster().resizeByDelta(1));
                            dockerHost = (DockerHost)added;
                            machine = (DockerHostLocation)dockerHost.getDynamicLocation();
                            if (headroomSet && policy.isPresent()) {
                                int currentMin = (Integer)((Policy)policy.get()).config().get(AutoScalerPolicy.MIN_POOL_SIZE);
                                LOG.info("Updating autoscaler policy ({}) setting {} to {}", new Object[]{policy.get(), AutoScalerPolicy.MIN_POOL_SIZE.getName(), currentMin + 1});
                                ((Policy)policy.get()).config().set(AutoScalerPolicy.MIN_POOL_SIZE, (Object)(currentMin + 1));
                            }
                            break block25;
                        }
                        finally {
                            if (policy.isPresent()) {
                                ((Policy)policy.get()).resume();
                            }
                        }
                    }
                    finally {
                        this.permit.release();
                    }
                }
                try {
                    this.permit.acquire();
                    return this.obtain(flags);
                }
                catch (InterruptedException ie) {
                    Exceptions.propagate((Throwable)ie);
                    return this.obtain(flags);
                }
                finally {
                    this.permit.release();
                }
            }
        }
        Entities.waitForServiceUp((Entity)dockerHost);
        try {
            LOG.debug("Obtain a new container from {} for {}", (Object)machine, (Object)entity);
            MutableMap hostFlags = MutableMap.copyOf(flags);
            DockerContainerLocation container = machine.obtain((Map<?, ?>)hostFlags);
            this.containers.put((Object)machine, (Object)container.getId());
            DockerContainerLocation dockerContainerLocation = container;
            return dockerContainerLocation;
        }
        finally {
            Iterator i$ = Iterables.concat(this.strategies, (Iterable)entityStrategies).iterator();
            while (true) {
                if (!i$.hasNext()) {
                }
                DockerAwarePlacementStrategy strategy = (DockerAwarePlacementStrategy)i$.next();
                if (!(strategy instanceof WithMutexes)) continue;
                ((WithMutexes)strategy).releaseMutex(entity.getApplicationId());
            }
        }
    }

    public MachineProvisioningLocation<MachineLocation> newSubLocation(Map<?, ?> newFlags) {
        throw new UnsupportedOperationException();
    }

    public void release(MachineLocation machine) {
        if (this.provisioner == null) {
            throw new IllegalStateException("No provisioner available to release " + machine);
        }
        String id = machine.getId();
        Set set = Multimaps.filterValues(this.containers, (Predicate)Predicates.equalTo((Object)id)).keySet();
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Request to release " + machine + ", but this machine is not currently allocated");
        }
        DockerHostLocation host = (DockerHostLocation)Iterables.getOnlyElement((Iterable)set);
        LOG.debug("Request to remove container mapping {} to {}", (Object)host, (Object)id);
        host.release((DockerContainerLocation)machine);
        if (this.containers.remove((Object)host, (Object)id)) {
            if (this.containers.get((Object)host).isEmpty()) {
                LOG.debug("Empty Docker host: {}", (Object)host);
                if (((Boolean)this.infrastructure.config().get(DockerInfrastructure.REMOVE_EMPTY_DOCKER_HOSTS)).booleanValue() && set.size() > 1) {
                    LOG.info("Removing empty Docker host: {}", (Object)host);
                    this.remove(host);
                }
            }
        } else {
            throw new IllegalArgumentException("Request to release " + machine + ", but container mapping not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(DockerHostLocation machine) {
        LOG.info("Releasing {}", (Object)machine);
        DynamicCluster cluster = this.infrastructure.getDockerHostCluster();
        DockerHost host = machine.getOwner();
        if (cluster.removeMember((Entity)host)) {
            LOG.info("Docker Host {} released", (Object)host.getDockerHostName());
        } else {
            LOG.warn("Docker Host {} not found for release", (Object)host.getDockerHostName());
        }
        try {
            host.stop();
            machine.close();
        }
        catch (Exception e) {
            LOG.warn("Error stopping host: " + host, (Throwable)e);
            Exceptions.propagateIfFatal((Throwable)e);
        }
        finally {
            Entities.unmanage((Entity)host);
        }
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return Maps.newLinkedHashMap();
    }

    public DockerInfrastructure getOwner() {
        return this.infrastructure;
    }

    @Override
    public List<Entity> getDockerContainerList() {
        return this.infrastructure.getDockerContainerList();
    }

    @Override
    public List<Entity> getDockerHostList() {
        return this.infrastructure.getDockerHostList();
    }

    @Override
    public DockerInfrastructure getDockerInfrastructure() {
        return this.infrastructure;
    }

    @Override
    public void close() throws IOException {
        LOG.info("Close called on Docker infrastructure: {}", (Object)this);
    }

    public RebindSupport<LocationMemento> getRebindSupport() {
        NetworkProvisioningExtension networkProvisioningExtension = null;
        if (this.hasExtension(NetworkProvisioningExtension.class)) {
            networkProvisioningExtension = (NetworkProvisioningExtension)this.getExtension(NetworkProvisioningExtension.class);
        }
        final Optional extension = Optional.fromNullable(networkProvisioningExtension);
        return new BasicLocationRebindSupport(this){

            public LocationMemento getMemento() {
                return this.getMementoWithProperties((Map)MutableMap.of((Object)"networkProvisioningExtension", (Object)extension));
            }

            protected void doReconstruct(RebindContext rebindContext, LocationMemento memento) {
                super.doReconstruct(rebindContext, (Memento)memento);
                Optional extension2 = (Optional)memento.getCustomField("networkProvisioningExtension");
                if (extension2.isPresent()) {
                    DockerLocation.this.addExtension(NetworkProvisioningExtension.class, extension2.get());
                }
            }
        };
    }

    public Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("provisioner", this.provisioner).add("infrastructure", (Object)this.infrastructure).add("strategies", this.strategies);
    }
}

