/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.microservice;

import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.entity.container.application.VanillaDockerApplication;
import clocker.docker.entity.microservice.MicroserviceDockerfile;
import clocker.docker.location.DockerLocation;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.entity.AbstractApplication;
import org.apache.brooklyn.core.entity.Entities;

public class MicroserviceDockerfileImpl
extends AbstractApplication
implements MicroserviceDockerfile {
    protected VanillaDockerApplication vanillaDockerApplication = null;

    public void initApp() {
        this.vanillaDockerApplication = (VanillaDockerApplication)this.addChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(VanillaDockerApplication.class).configure((CharSequence)"containerName", this.config().get(CONTAINER_NAME))).configure((CharSequence)"dockerfileUrl", this.config().get(DOCKERFILE_URL))).configure((CharSequence)"openPorts", this.config().get(OPEN_PORTS))).configure((CharSequence)"directPorts", this.config().get(DIRECT_PORTS))).configure((CharSequence)"portBindings", this.config().get(PORT_BINDINGS))).configure((CharSequence)"env", this.config().get(DOCKER_CONTAINER_ENVIRONMENT))).configure((CharSequence)"volumeMappings", this.config().get(DOCKER_HOST_VOLUME_MAPPING)));
    }

    protected void doStart(Collection<? extends Location> locations) {
        Optional dockerLocation = Iterables.tryFind((Iterable)this.getLocations(), (Predicate)Predicates.instanceOf(DockerLocation.class));
        if (!dockerLocation.isPresent()) {
            String locationName = "docker-" + this.getId();
            DockerInfrastructure dockerInfrastructure = (DockerInfrastructure)this.addChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(DockerInfrastructure.class).configure(DockerInfrastructure.DOCKER_HOST_CLUSTER_MIN_SIZE, (Object)1)).configure(DockerInfrastructure.SDN_ENABLE, (Object)false)).configure(DockerInfrastructure.LOCATION_NAME, (Object)locationName)).displayName("Docker Infrastructure"));
            Entities.start((Entity)dockerInfrastructure, locations);
            dockerLocation = Optional.of((Object)this.getManagementContext().getLocationRegistry().resolve(locationName));
        }
        Entities.start((Entity)this.vanillaDockerApplication, (Collection)dockerLocation.asSet());
    }
}

