/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.container.registry;

import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.container.application.VanillaDockerApplication;
import clocker.docker.entity.container.registry.DockerRegistryImpl;
import clocker.docker.entity.util.DockerAttributes;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="Docker Registry", description="The Docker Registry", iconUrl="classpath://docker-registry-logo.png")
@ImplementedBy(value=DockerRegistryImpl.class)
public interface DockerRegistry
extends VanillaDockerApplication {
    public static final AttributeSensorAndConfigKey<String, String> IMAGE_NAME = ConfigKeys.newSensorAndConfigKeyWithDefault(DockerAttributes.DOCKER_IMAGE_NAME, (Object)"registry");
    @SetFromFlag(value="imageTag")
    public static final AttributeSensorAndConfigKey<String, String> IMAGE_TAG = ConfigKeys.newSensorAndConfigKeyWithDefault(DockerAttributes.DOCKER_IMAGE_TAG, (Object)"2");
    @SetFromFlag(value="registryPort")
    public static final AttributeSensorAndConfigKey<Integer, Integer> DOCKER_REGISTRY_PORT = ConfigKeys.newIntegerSensorAndConfigKey((String)"docker.registry.port", (String)"The docker registry port to expose", (Integer)50000);
    public static final AttributeSensorAndConfigKey<Entity, Entity> DOCKER_HOST = DockerContainer.DOCKER_HOST;
    public static final ConfigKey<Map<String, Object>> DOCKER_CONTAINER_ENVIRONMENT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)DockerContainer.DOCKER_CONTAINER_ENVIRONMENT.getConfigKey(), (Object)ImmutableMap.builder().put((Object)"REGISTRY_HTTP_TLS_CERTIFICATE", (Object)"/certs/repo-cert.pem").put((Object)"REGISTRY_HTTP_TLS_KEY", (Object)"/certs/repo-key.pem").build());
    public static final AttributeSensor<List<String>> DOCKER_REGISTRY_CATALOG = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"docker.registry.catalog", (String)"The docker registry catalog, which lists all of the available repositories");
}

