/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.container.application;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.container.application.VanillaDockerApplication;
import clocker.docker.entity.container.application.VanillaDockerApplicationDriver;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.entity.util.DockerUtils;
import clocker.docker.location.DockerContainerLocation;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaDockerApplicationImpl
extends SoftwareProcessImpl
implements VanillaDockerApplication {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaDockerApplicationImpl.class);

    public String getIconUrl() {
        return "classpath://container.png";
    }

    public String getDisplayName() {
        return String.format("Container (%s)", Objects.firstNonNull((Object)this.sensors().get(DockerContainer.DOCKER_CONTAINER_NAME), (Object)this.config().get(IMAGE_NAME)));
    }

    protected void connectSensors() {
        this.connectServiceUpIsRunning();
        super.connectSensors();
    }

    protected void postStart() {
        super.postStart();
        DockerUtils.getContainerPorts((Entity)this);
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
    }

    public void rebind() {
        super.rebind();
        this.disconnectSensors();
        this.connectSensors();
    }

    public Class<? extends VanillaDockerApplicationDriver> getDriverInterface() {
        return VanillaDockerApplicationDriver.class;
    }

    @Override
    public DockerContainer getDockerContainer() {
        DockerContainerLocation location = (DockerContainerLocation)((Object)Iterables.find((Iterable)this.getLocations(), (Predicate)Predicates.instanceOf(DockerContainerLocation.class)));
        return location.getOwner();
    }

    @Override
    public DockerHost getDockerHost() {
        return this.getDockerContainer().getDockerHost();
    }

    @Override
    public String getDockerfile() {
        return (String)this.config().get(DOCKERFILE_URL);
    }

    @Override
    public List<Integer> getContainerPorts() {
        return (List)this.config().get(DockerAttributes.DOCKER_OPEN_PORTS);
    }
}

