/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.container.application;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.container.application.VanillaDockerApplicationImpl;
import clocker.docker.entity.util.DockerAttributes;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.software.base.VanillaSoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Docker Container", description="A micro-service running in a Docker container.", iconUrl="classpath:///container.png")
@ImplementedBy(value=VanillaDockerApplicationImpl.class)
public interface VanillaDockerApplication
extends VanillaSoftwareProcess {
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    @SetFromFlag(value="dockerfileUrl")
    public static final ConfigKey<String> DOCKERFILE_URL = DockerAttributes.DOCKERFILE_URL;
    @SetFromFlag(value="containerName")
    public static final ConfigKey<String> CONTAINER_NAME = DockerContainer.DOCKER_CONTAINER_NAME.getConfigKey();
    @SetFromFlag(value="imageName")
    public static final ConfigKey<String> IMAGE_NAME = DockerAttributes.DOCKER_IMAGE_NAME.getConfigKey();
    @SetFromFlag(value="imageTag")
    public static final ConfigKey<String> IMAGE_TAG = DockerAttributes.DOCKER_IMAGE_TAG.getConfigKey();
    @SetFromFlag(value="entrypoint")
    public static final ConfigKey<List<String>> IMAGE_ENTRYPOINT = DockerAttributes.DOCKER_IMAGE_ENTRYPOINT.getConfigKey();
    @SetFromFlag(value="commands")
    public static final ConfigKey<List<String>> IMAGE_COMMANDS = DockerAttributes.DOCKER_IMAGE_COMMANDS.getConfigKey();
    @SetFromFlag(value="useSsh")
    public static final ConfigKey<Boolean> DOCKER_USE_SSH = ConfigKeys.newConfigKeyWithDefault(DockerAttributes.DOCKER_USE_SSH, (Object)Boolean.FALSE);
    @SetFromFlag(value="openPorts")
    public static final ConfigKey<List<Integer>> DOCKER_OPEN_PORTS = DockerAttributes.DOCKER_OPEN_PORTS;
    @SetFromFlag(value="directPorts")
    public static final ConfigKey<List<Integer>> DOCKER_DIRECT_PORTS = DockerAttributes.DOCKER_DIRECT_PORTS;
    @SetFromFlag(value="portBindings")
    public static final ConfigKey<Map<Integer, Integer>> DOCKER_PORT_BINDINGS = DockerAttributes.DOCKER_PORT_BINDINGS;
    @SetFromFlag(value="env")
    public static final ConfigKey<Map<String, Object>> DOCKER_CONTAINER_ENVIRONMENT = DockerContainer.DOCKER_CONTAINER_ENVIRONMENT.getConfigKey();
    @SetFromFlag(value="volumes")
    public static final ConfigKey<List<String>> DOCKER_CONTAINER_VOLUME_EXPORT = DockerAttributes.DOCKER_CONTAINER_VOLUME_EXPORT;
    @SetFromFlag(value="volumesFrom")
    public static final ConfigKey<List<String>> DOCKER_CONTAINER_VOLUMES_FROM = DockerAttributes.DOCKER_CONTAINER_VOLUMES_FROM;
    @SetFromFlag(value="volumeMappings")
    public static final AttributeSensorAndConfigKey<Map<String, String>, Map<String, String>> DOCKER_HOST_VOLUME_MAPPING = DockerAttributes.DOCKER_HOST_VOLUME_MAPPING;
    @SetFromFlag(value="links")
    public static final ConfigKey<Map<String, Entity>> DOCKER_LINKS = DockerAttributes.DOCKER_LINKS;
    public static final ConfigKey<Boolean> SKIP_ENTITY_INSTALLATION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.SKIP_ENTITY_INSTALLATION, (Object)Boolean.TRUE);
    public static final ConfigKey<String> ON_BOX_BASE_DIR = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.ONBOX_BASE_DIR, (Object)"/tmp/clocker");
    public static final ConfigKey<Boolean> SKIP_ON_BOX_BASE_DIR_RESOLUTION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION, (Object)Boolean.TRUE);
    public static final ConfigKey<String> LAUNCH_COMMAND = ConfigKeys.newConfigKeyWithDefault((ConfigKey)VanillaSoftwareProcess.LAUNCH_COMMAND, null);

    public DockerContainer getDockerContainer();

    public DockerHost getDockerHost();

    public String getDockerfile();

    public List<Integer> getContainerPorts();
}

