/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.container;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.container.DockerContainerImpl;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.location.DockerContainerLocation;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.objs.HasShortName;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.location.dynamic.LocationOwner;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.stock.BasicStartable;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.net.HasNetworkAddresses;

@ImplementedBy(value=DockerContainerImpl.class)
public interface DockerContainer
extends BasicStartable,
HasNetworkAddresses,
HasShortName,
LocationOwner<DockerContainerLocation, DockerContainer> {
    @SetFromFlag(value="dockerHost")
    public static final AttributeSensorAndConfigKey<Entity, Entity> DOCKER_HOST = ConfigKeys.newSensorAndConfigKey(Entity.class, (String)"docker.host", (String)"The parent Docker host");
    @SetFromFlag(value="infrastructure")
    public static final AttributeSensorAndConfigKey<Entity, Entity> DOCKER_INFRASTRUCTURE = DockerHost.DOCKER_INFRASTRUCTURE;
    @SetFromFlag(value="containerName")
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_CONTAINER_NAME = DockerAttributes.DOCKER_CONTAINER_NAME;
    @SetFromFlag(value="privileged")
    public static final ConfigKey<Boolean> PRIVILEGED = DockerAttributes.PRIVILEGED;
    @SetFromFlag(value="interactive")
    public static final ConfigKey<Boolean> INTERACTIVE = DockerAttributes.INTERACTIVE;
    @SetFromFlag(value="managed")
    public static final ConfigKey<Boolean> MANAGED = DockerAttributes.MANAGED;
    @SetFromFlag(value="password")
    public static final ConfigKey<String> DOCKER_LOGIN_PASSWORD = DockerAttributes.DOCKER_LOGIN_PASSWORD;
    @SetFromFlag(value="imageId")
    public static final ConfigKey<String> DOCKER_IMAGE_ID = DockerAttributes.DOCKER_IMAGE_ID.getConfigKey();
    @SetFromFlag(value="imageName")
    public static final ConfigKey<String> DOCKER_IMAGE_NAME = DockerAttributes.DOCKER_IMAGE_NAME.getConfigKey();
    @SetFromFlag(value="imageTag")
    public static final ConfigKey<String> DOCKER_IMAGE_TAG = DockerAttributes.DOCKER_IMAGE_TAG.getConfigKey();
    @SetFromFlag(value="entrypoint")
    public static final ConfigKey<List<String>> DOCKER_IMAGE_ENTRYPOINT = DockerAttributes.DOCKER_IMAGE_ENTRYPOINT.getConfigKey();
    @SetFromFlag(value="commands")
    public static final ConfigKey<List<String>> DOCKER_IMAGE_COMMANDS = DockerAttributes.DOCKER_IMAGE_COMMANDS.getConfigKey();
    @SetFromFlag(value="hardwareId")
    public static final ConfigKey<String> DOCKER_HARDWARE_ID = DockerAttributes.DOCKER_HARDWARE_ID.getConfigKey();
    @SetFromFlag(value="useHostDnsName")
    public static final ConfigKey<Boolean> DOCKER_USE_HOST_DNS_NAME = DockerAttributes.DOCKER_USE_HOST_DNS_NAME;
    @SetFromFlag(value="useSsh")
    public static final ConfigKey<Boolean> DOCKER_USE_SSH = DockerAttributes.DOCKER_USE_SSH;
    @SetFromFlag(value="cpuShares")
    public static final ConfigKey<Integer> DOCKER_CPU_SHARES = DockerAttributes.DOCKER_CPU_SHARES;
    @SetFromFlag(value="memory")
    public static final ConfigKey<Integer> DOCKER_MEMORY = DockerAttributes.DOCKER_MEMORY;
    @SetFromFlag(value="volumes")
    public static final ConfigKey<List<String>> DOCKER_CONTAINER_VOLUME_EXPORT = DockerAttributes.DOCKER_CONTAINER_VOLUME_EXPORT;
    @SetFromFlag(value="volumesFrom")
    public static final ConfigKey<List<String>> DOCKER_CONTAINER_VOLUMES_FROM = DockerAttributes.DOCKER_CONTAINER_VOLUMES_FROM;
    @SetFromFlag(value="env")
    public static final AttributeSensorAndConfigKey<Map<String, Object>, Map<String, Object>> DOCKER_CONTAINER_ENVIRONMENT = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<Map<String, Object>>(){}, (String)"docker.container.environment", (String)"Environment variables for the Docker container");
    @SetFromFlag(value="entity")
    public static final AttributeSensorAndConfigKey<Entity, Entity> ENTITY = ConfigKeys.newSensorAndConfigKey(Entity.class, (String)"docker.container.entity", (String)"The entity running in this Docker container");
    public static final ConfigKey<String> DOCKER_CONTAINER_NAME_FORMAT = ConfigKeys.newStringConfigKey((String)"docker.container.nameFormat", (String)"Format for generating Docker container names", (String)"clocker-%2$02x");
    public static final AttributeSensor<String> IMAGE_ID = Sensors.newStringSensor((String)"docker.container.image.id", (String)"The Docker container image ID");
    public static final AttributeSensor<String> IMAGE_NAME = Sensors.newStringSensor((String)"docker.container.image.name", (String)"The Docker container image name");
    public static final AttributeSensor<String> HARDWARE_ID = Sensors.newStringSensor((String)"docker.container.hardwareId", (String)"The Docker container hardware ID");
    public static final AttributeSensor<String> CONTAINER_ID = Sensors.newStringSensor((String)"docker.container.id", (String)"The Docker container ID");
    public static final AttributeSensor<Set<String>> CONTAINER_ADDRESSES = Sensors.newSensor((TypeToken)new TypeToken<Set<String>>(){}, (String)"docker.container.addresses", (String)"The set of Docker container IP addresses");
    public static final AttributeSensor<Entity> CONTAINER = Sensors.newSensor(Entity.class, (String)"docker.container", (String)"The Docker container entity");
    public static final AttributeSensor<Boolean> CONTAINER_RUNNING = Sensors.newBooleanSensor((String)"docker.container.running", (String)"The Docker container process running status");
    public static final AttributeSensor<Boolean> CONTAINER_PAUSED = Sensors.newBooleanSensor((String)"docker.container.paused", (String)"The Docker container process paused status");
    public static final AttributeSensor<Lifecycle> SERVICE_STATE_ACTUAL = SoftwareProcess.SERVICE_STATE_ACTUAL;
    public static final AttributeSensor<SshMachineLocation> SSH_MACHINE_LOCATION = Sensors.newSensor(SshMachineLocation.class, (String)"docker.container.ssh", (String)"The SSHable machine");
    public static final MethodEffector<Void> SHUT_DOWN = new MethodEffector(DockerContainer.class, "shutDown");
    public static final MethodEffector<Void> PAUSE = new MethodEffector(DockerContainer.class, "pause");
    public static final MethodEffector<Void> RESUME = new MethodEffector(DockerContainer.class, "resume");

    @Effector(description="Shut-down the Docker container")
    public void shutDown();

    @Effector(description="Pause the Docker container")
    public void pause();

    @Effector(description="Resume the Docker container")
    public void resume();

    public String getDockerContainerName();

    public String getContainerId();

    public Entity getRunningEntity();

    public void setRunningEntity(Entity var1);

    public DockerHost getDockerHost();

    public SshMachineLocation getMachine();
}

