/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.container.registry.DockerRegistry;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.entity.util.DockerUtils;
import clocker.docker.location.DockerLocation;
import clocker.docker.location.DockerResolver;
import clocker.docker.networking.entity.sdn.util.SdnAttributes;
import clocker.docker.policy.ContainerHeadroomEnricher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.X509TrustManager;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.entity.AbstractApplication;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.dynamic.LocationOwner;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.Cluster;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.entity.machine.MachineAttributes;
import org.apache.brooklyn.entity.nosql.etcd.EtcdCluster;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.stock.DelegateEntity;
import org.apache.brooklyn.policy.autoscaling.AutoScalerPolicy;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.crypto.SecureKeys;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.VersionComparator;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInfrastructureImpl
extends AbstractApplication
implements DockerInfrastructure {
    private static final Logger LOG = LoggerFactory.getLogger(DockerInfrastructure.class);
    private transient Object mutex = new Object[0];

    @Override
    public Object getInfrastructureMutex() {
        return this.mutex;
    }

    public void init() {
        String version = (String)this.config().get(DOCKER_VERSION);
        if (VersionComparator.getInstance().compare("1.9", version) > 1) {
            throw new IllegalStateException("Requires libnetwork capable Docker > 1.9");
        }
        LOG.info("Starting Docker infrastructure id {}", (Object)this.getId());
        this.registerLocationResolver();
        super.init();
        this.sensors().set(DOCKER_HOST_COUNTER, (Object)new AtomicInteger(0));
        this.sensors().set(DOCKER_CONTAINER_COUNTER, (Object)new AtomicInteger(0));
        int initialSize = (Integer)this.config().get(DOCKER_HOST_CLUSTER_MIN_SIZE);
        ImmutableMap runtimeFiles = ImmutableMap.of();
        if (!((Boolean)this.config().get(DOCKER_GENERATE_TLS_CERTIFICATES)).booleanValue()) {
            runtimeFiles = ImmutableMap.builder().put(this.config().get(DOCKER_SERVER_CERTIFICATE_PATH), (Object)"cert.pem").put(this.config().get(DOCKER_SERVER_KEY_PATH), (Object)"key.pem").put(this.config().get(DOCKER_CA_CERTIFICATE_PATH), (Object)"ca.pem").build();
        }
        if (!((Boolean)this.config().get(DOCKER_SHOULD_START_REGISTRY)).booleanValue()) {
            ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_IMAGE_REGISTRY_URL);
        }
        try {
            String caCertPath = (String)this.config().get(DOCKER_CA_CERTIFICATE_PATH);
            try (InputStream caCert = ResourceUtils.create().getResourceFromUrl(caCertPath);){
                X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(caCert);
                KeyStore store = SecureKeys.newKeyStore();
                store.setCertificateEntry("ca", certificate);
                X509TrustManager trustManager = SecureKeys.getTrustManager((X509Certificate)certificate);
            }
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            Exceptions.propagate((Throwable)e);
        }
        EntitySpec dockerHostSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get((ConfigKey.HasConfigKey)DOCKER_HOST_SPEC)));
        ((EntitySpec)((EntitySpec)dockerHostSpec.configure(DockerHost.DOCKER_INFRASTRUCTURE, (Object)this)).configure(DockerHost.RUNTIME_FILES, (Object)runtimeFiles)).configure(SoftwareProcess.CHILDREN_STARTABLE_MODE, (Object)SoftwareProcess.ChildStartableMode.BACKGROUND_LATE);
        String dockerVersion = (String)this.config().get(DOCKER_VERSION);
        if (Strings.isNonBlank((CharSequence)dockerVersion)) {
            dockerHostSpec.configure(SoftwareProcess.SUGGESTED_VERSION, (Object)dockerVersion);
        }
        if (Boolean.TRUE.equals(this.config().get(SdnAttributes.SDN_DEBUG))) {
            dockerHostSpec.configure(DockerAttributes.DOCKERFILE_URL, (Object)"classpath://clocker/docker/entity/container/ubuntu/NetworkingDockerfile");
        }
        this.sensors().set((AttributeSensor)DOCKER_HOST_SPEC, (Object)dockerHostSpec);
        DynamicCluster hosts = (DynamicCluster)this.addChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(DynamicCluster.class).configure((ConfigKey)Cluster.INITIAL_SIZE, (Object)initialSize)).configure(DynamicCluster.QUARANTINE_FAILED_ENTITIES, (Object)true)).configure(DynamicCluster.MEMBER_SPEC, (Object)dockerHostSpec)).configure(DynamicCluster.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).configure(DynamicCluster.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).configure(BrooklynCampConstants.PLAN_ID, (Object)"docker-hosts")).displayName("Docker Hosts"));
        EntitySpec etcdNodeSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get((ConfigKey.HasConfigKey)EtcdCluster.ETCD_NODE_SPEC)));
        String etcdVersion = (String)this.config().get(ETCD_VERSION);
        if (Strings.isNonBlank((CharSequence)etcdVersion)) {
            etcdNodeSpec.configure(SoftwareProcess.SUGGESTED_VERSION, (Object)etcdVersion);
        }
        this.sensors().set((AttributeSensor)EtcdCluster.ETCD_NODE_SPEC, (Object)etcdNodeSpec);
        EtcdCluster etcd = (EtcdCluster)this.addChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(EtcdCluster.class).configure((ConfigKey)Cluster.INITIAL_SIZE, (Object)0)).configure((ConfigKey.HasConfigKey)EtcdCluster.ETCD_NODE_SPEC, (Object)etcdNodeSpec)).configure(EtcdCluster.CLUSTER_NAME, (Object)"docker")).configure(EtcdCluster.CLUSTER_TOKEN, (Object)"etcd-docker")).configure(DynamicCluster.QUARANTINE_FAILED_ENTITIES, (Object)true)).configure(DynamicCluster.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).configure(DynamicCluster.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).displayName("Etcd Cluster"));
        this.sensors().set(ETCD_CLUSTER, (Object)etcd);
        DynamicGroup fabric = (DynamicGroup)this.addChild((EntitySpec)((EntitySpec)EntitySpec.create(DynamicGroup.class).configure(DynamicGroup.ENTITY_FILTER, (Object)Predicates.and((Predicate)Predicates.instanceOf(DockerContainer.class), (Predicate)EntityPredicates.attributeEqualTo(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)this)))).displayName("All Docker Containers"));
        if (((Boolean)this.config().get(SDN_ENABLE)).booleanValue() && this.config().get(SDN_PROVIDER_SPEC) != null) {
            EntitySpec entitySpec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get(SDN_PROVIDER_SPEC)));
            entitySpec.configure(DockerAttributes.DOCKER_INFRASTRUCTURE, (Object)this);
            Entity sdn = this.addChild(entitySpec);
            this.sensors().set(SDN_PROVIDER, (Object)sdn);
        }
        this.sensors().set(DOCKER_HOST_CLUSTER, (Object)hosts);
        this.sensors().set(DOCKER_CONTAINER_FABRIC, (Object)fabric);
        hosts.enrichers().add(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(DockerHost.CPU_USAGE).computingAverage()).fromMembers()).publishing(MachineAttributes.AVERAGE_CPU_USAGE).valueToReportIfNoSensors((Object)0.0)).build());
        hosts.enrichers().add(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(DOCKER_CONTAINER_COUNT).computingSum()).fromMembers()).publishing(DOCKER_CONTAINER_COUNT).build());
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{DOCKER_CONTAINER_COUNT, MachineAttributes.AVERAGE_CPU_USAGE}).from((Entity)hosts)).build());
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating((Map)ImmutableMap.of((Object)DynamicCluster.GROUP_SIZE, (Object)DOCKER_HOST_COUNT)).from((Entity)hosts)).build());
        Integer headroom = (Integer)this.config().get(ContainerHeadroomEnricher.CONTAINER_HEADROOM);
        Double headroomPercent = (Double)this.config().get(ContainerHeadroomEnricher.CONTAINER_HEADROOM_PERCENTAGE);
        if (headroom != null && headroom > 0 || headroomPercent != null && headroomPercent > 0.0) {
            this.enrichers().add((EnricherSpec)((EnricherSpec)EnricherSpec.create(ContainerHeadroomEnricher.class).configure(ContainerHeadroomEnricher.CONTAINER_HEADROOM, (Object)headroom)).configure(ContainerHeadroomEnricher.CONTAINER_HEADROOM_PERCENTAGE, (Object)headroomPercent));
            hosts.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_COLD, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_HOT, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_OK}).from((Entity)this)).build());
            hosts.policies().add((PolicySpec)((PolicySpec)((PolicySpec)((PolicySpec)((PolicySpec)((PolicySpec)((PolicySpec)PolicySpec.create(AutoScalerPolicy.class).configure(AutoScalerPolicy.POOL_COLD_SENSOR, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_COLD)).configure(AutoScalerPolicy.POOL_HOT_SENSOR, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_HOT)).configure(AutoScalerPolicy.POOL_OK_SENSOR, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_OK)).configure(AutoScalerPolicy.MIN_POOL_SIZE, (Object)initialSize)).configure(AutoScalerPolicy.RESIZE_UP_STABILIZATION_DELAY, (Object)Duration.THIRTY_SECONDS)).configure(AutoScalerPolicy.RESIZE_DOWN_STABILIZATION_DELAY, (Object)Duration.FIVE_MINUTES)).displayName("Headroom Auto Scaler"));
        }
        this.sensors().set(Attributes.MAIN_URI, (Object)URI.create("/clocker"));
        Entity sdn = (Entity)this.sensors().get(SDN_PROVIDER);
        this.enrichers().add((EnricherSpec)((EnricherSpec)EnricherSpec.create(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.class).uniqueTag("service-lifecycle-indicators-from-children-and-members").configure(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.FROM_CHILDREN, (Object)true)).configure(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.ENTITY_FILTER, (Object)Predicates.or((Predicate)Predicates.equalTo((Object)hosts), (Predicate)(sdn == null ? Predicates.alwaysFalse() : Predicates.equalTo((Object)sdn)))));
    }

    public String getIconUrl() {
        return "classpath://docker-logo.png";
    }

    private void registerLocationResolver() {
        LocationRegistry registry = this.getManagementContext().getLocationRegistry();
        DockerResolver dockerResolver = new DockerResolver();
        ((BasicLocationRegistry)registry).registerResolver((LocationResolver)dockerResolver);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Explicitly registered docker resolver: " + dockerResolver);
        }
    }

    @Override
    public List<Entity> getDockerHostList() {
        if (this.getDockerHostCluster() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.getDockerHostCluster().getMembers());
    }

    @Override
    public DynamicCluster getDockerHostCluster() {
        return (DynamicCluster)this.sensors().get(DOCKER_HOST_CLUSTER);
    }

    @Override
    public List<Entity> getDockerContainerList() {
        if (this.getContainerFabric() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.getContainerFabric().getMembers());
    }

    @Override
    public DynamicGroup getContainerFabric() {
        return (DynamicGroup)this.sensors().get(DOCKER_CONTAINER_FABRIC);
    }

    public Integer resize(Integer desiredSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resize Docker infrastructure to {} at {}", new Object[]{desiredSize, this.getLocations()});
        }
        return this.getDockerHostCluster().resize(desiredSize);
    }

    public Integer getCurrentSize() {
        return this.getDockerHostCluster().getCurrentSize();
    }

    public DockerLocation getDynamicLocation() {
        return (DockerLocation)this.sensors().get(DYNAMIC_LOCATION);
    }

    public boolean isLocationAvailable() {
        return this.getDynamicLocation() != null;
    }

    public DockerLocation createLocation(Map<String, ?> flags) {
        String locationName = (String)this.config().get((ConfigKey.HasConfigKey)LOCATION_NAME);
        if (Strings.isBlank((CharSequence)locationName)) {
            String prefix = (String)this.config().get(LOCATION_NAME_PREFIX);
            String suffix = (String)this.config().get(LOCATION_NAME_SUFFIX);
            locationName = Joiner.on((String)"-").skipNulls().join((Object)prefix, (Object)this.getId(), new Object[]{suffix});
        }
        DockerLocation location = (DockerLocation)this.getManagementContext().getLocationManager().createLocation((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(DockerLocation.class).displayName("Docker Infrastructure(" + this.getId() + ")")).configure(flags)).configure((CharSequence)"owner", (Object)this.getProxy())).configure((CharSequence)"locationName", (Object)locationName));
        LocationDefinition definition = location.register();
        this.sensors().set(LocationOwner.LOCATION_SPEC, (Object)definition.getSpec());
        this.sensors().set(LocationOwner.DYNAMIC_LOCATION, (Object)location);
        this.sensors().set((AttributeSensor)LocationOwner.LOCATION_NAME, (Object)locationName);
        LOG.info("New Docker location {} created for {}", (Object)location, (Object)this);
        return location;
    }

    public void deleteLocation() {
        DockerLocation location = this.getDynamicLocation();
        if (location != null) {
            location.deregister();
            Locations.unmanage((Location)location);
        }
        this.sensors().set(LocationOwner.DYNAMIC_LOCATION, null);
        this.sensors().set((AttributeSensor)LocationOwner.LOCATION_NAME, null);
    }

    public void doStart(Collection<? extends Location> locs) {
        this.addLocations(locs);
        MutableList locations = MutableList.copyOf((Iterable)Locations.getLocationsCheckingAncestors(locs, (Entity)this));
        this.sensors().set(SERVICE_UP, (Object)Boolean.FALSE);
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        Location provisioner = (Location)Iterables.getOnlyElement((Iterable)locations);
        LOG.info("Creating new DockerLocation wrapping {}", (Object)provisioner);
        MutableMap flags = MutableMap.builder().putAll((Map)this.config().get(LOCATION_FLAGS)).put((Object)"provisioner", (Object)provisioner).putIfNotNull((Object)"strategies", this.config().get(PLACEMENT_STRATEGIES)).build();
        this.createLocation((Map)flags);
        super.doStart((Collection)locations);
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
        this.sensors().set(SERVICE_UP, (Object)Boolean.TRUE);
    }

    public void postStart(Collection<? extends Location> locations) {
        if (((Boolean)this.config().get(DOCKER_SHOULD_START_REGISTRY)).booleanValue()) {
            DockerHost firstEntity = (DockerHost)((DynamicCluster)this.sensors().get(DOCKER_HOST_CLUSTER)).sensors().get(DynamicCluster.FIRST);
            EntitySpec spec = (EntitySpec)((EntitySpec)EntitySpec.create(DockerRegistry.class).configure(DockerRegistry.DOCKER_HOST, (Object)firstEntity)).configure(DockerRegistry.DOCKER_REGISTRY_PORT, this.config().get(DOCKER_REGISTRY_PORT));
            DockerRegistry registry = (DockerRegistry)this.addChild(spec);
            LOG.debug("Starting a new Docker Registry with spec {}", (Object)spec);
            Entities.start((Entity)registry, (Collection)ImmutableList.of((Object)firstEntity.getDynamicLocation()));
            String registryUrl = HostAndPort.fromParts((String)((String)firstEntity.sensors().get(Attributes.ADDRESS)), (int)((Integer)this.config().get(DOCKER_REGISTRY_PORT))).toString();
            this.sensors().set((AttributeSensor)DOCKER_IMAGE_REGISTRY_URL, (Object)registryUrl);
            this.sensors().set(DOCKER_IMAGE_REGISTRY, (Object)registry);
        }
    }

    public void stop() {
        this.sensors().set(SERVICE_UP, (Object)Boolean.FALSE);
        Duration timeout = (Duration)this.config().get(SHUTDOWN_TIMEOUT);
        this.deleteLocation();
        if (((Boolean)this.config().get(DOCKER_SHOULD_START_REGISTRY)).booleanValue()) {
            Entity registry = (Entity)this.sensors().get(DOCKER_IMAGE_REGISTRY);
            DockerUtils.stop((Entity)this, registry, Duration.THIRTY_SECONDS);
        }
        try {
            Iterable entities = Iterables.filter((Iterable)this.getManagementContext().getEntityManager().getEntities(), (Predicate)Predicates.and(DockerUtils.sameInfrastructure((Entity)this), (Predicate)Predicates.not((Predicate)EntityPredicates.applicationIdEqualTo((String)this.getApplicationId()))));
            ImmutableSet applications = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)entities, (Function)new Function<Entity, Application>(){

                public Application apply(Entity input) {
                    return input.getApplication();
                }
            }));
            LOG.debug("Stopping applications: {}", (Object)Iterables.toString((Iterable)applications));
            Entities.invokeEffectorList((Entity)this, (Iterable)applications, (Effector)Startable.STOP).get(timeout);
        }
        catch (Exception e) {
            LOG.warn("Error stopping applications", (Throwable)e);
        }
        try {
            DynamicCluster hosts = this.getDockerHostCluster();
            LOG.debug("Stopping hosts: {}", (Object)Iterables.toString((Iterable)hosts.getMembers()));
            Entities.invokeEffectorList((Entity)this, (Iterable)hosts.getMembers(), (Effector)Startable.STOP).get(timeout);
        }
        catch (Exception e) {
            LOG.warn("Error stopping hosts", (Throwable)e);
        }
        try {
            super.stop();
        }
        catch (Exception e) {
            LOG.warn("Error stopping children", (Throwable)e);
        }
    }

    static {
        DockerAttributes.init();
        RendererHints.register((AttributeSensor)DOCKER_HOST_CLUSTER, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)DOCKER_CONTAINER_FABRIC, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)SDN_PROVIDER, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)ETCD_CLUSTER, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
    }
}

