/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;

public class DockerTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected Optional<String> dns = Optional.absent();
    protected Optional<String> hostname = Optional.absent();
    protected Optional<Integer> memory = Optional.absent();
    protected Optional<Integer> cpuShares = Optional.absent();
    protected Optional<List<String>> commands = Optional.absent();
    protected Optional<Map<String, String>> volumes = Optional.absent();
    protected Optional<List<String>> env = Optional.absent();
    protected Optional<Map<Integer, Integer>> portBindings = Optional.absent();
    public static final DockerTemplateOptions NONE = new DockerTemplateOptions();

    public DockerTemplateOptions clone() {
        DockerTemplateOptions options = new DockerTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof DockerTemplateOptions) {
            DockerTemplateOptions eTo = (DockerTemplateOptions)DockerTemplateOptions.class.cast(to);
            if (this.volumes.isPresent()) {
                eTo.volumes((Map)this.getVolumes().get());
            }
            if (this.hostname.isPresent()) {
                eTo.hostname((String)this.hostname.get());
            }
            if (this.dns.isPresent()) {
                eTo.dns((String)this.dns.get());
            }
            if (this.memory.isPresent()) {
                eTo.memory((Integer)this.memory.get());
            }
            if (this.commands.isPresent()) {
                eTo.commands((Iterable)this.commands.get());
            }
            if (this.cpuShares.isPresent()) {
                eTo.cpuShares((Integer)this.cpuShares.get());
            }
            if (this.env.isPresent()) {
                eTo.env((Iterable)this.env.get());
            }
            if (this.portBindings.isPresent()) {
                eTo.portBindings((Map)this.portBindings.get());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerTemplateOptions that = (DockerTemplateOptions)DockerTemplateOptions.class.cast(o);
        return super.equals((Object)that) && Objects.equal(this.volumes, that.volumes) && Objects.equal(this.hostname, that.hostname) && Objects.equal(this.dns, that.dns) && Objects.equal(this.memory, that.memory) && Objects.equal(this.commands, that.commands) && Objects.equal(this.cpuShares, that.cpuShares) && Objects.equal(this.env, that.env) && Objects.equal(this.portBindings, that.portBindings);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.volumes, this.hostname, this.dns, this.memory, this.commands, this.cpuShares, this.env, this.portBindings});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("dns", this.dns).add("hostname", this.hostname).add("memory", this.memory).add("cpuShares", this.cpuShares).add("commands", this.commands).add("volumes", this.volumes).add("env", this.env).add("portBindings", this.portBindings).toString();
    }

    public DockerTemplateOptions volumes(Map<String, String> volumes) {
        this.volumes = Optional.of((Object)ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(volumes, (Object)"volumes"))));
        return this;
    }

    public DockerTemplateOptions dns(@Nullable String dns) {
        this.dns = Optional.fromNullable((Object)dns);
        return this;
    }

    public DockerTemplateOptions hostname(@Nullable String hostname) {
        this.hostname = Optional.fromNullable((Object)hostname);
        return this;
    }

    public DockerTemplateOptions memory(@Nullable Integer memory) {
        this.memory = Optional.fromNullable((Object)memory);
        return this;
    }

    public DockerTemplateOptions commands(Iterable<String> commands) {
        this.commands = Optional.of((Object)ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(commands, (Object)"commands"))));
        return this;
    }

    public DockerTemplateOptions commands(String ... commands) {
        return this.commands((Iterable<String>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)commands, (Object)"commands"))));
    }

    public DockerTemplateOptions cpuShares(@Nullable Integer cpuShares) {
        this.cpuShares = Optional.fromNullable((Object)cpuShares);
        return this;
    }

    public DockerTemplateOptions env(Iterable<String> env) {
        this.env = Optional.of((Object)ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(env, (Object)"env"))));
        return this;
    }

    public DockerTemplateOptions env(String ... env) {
        return this.env((Iterable<String>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)env, (Object)"env"))));
    }

    public DockerTemplateOptions portBindings(Map<Integer, Integer> portBindings) {
        this.portBindings = Optional.of((Object)ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(portBindings, (Object)"portBindings"))));
        return this;
    }

    public Optional<Map<String, String>> getVolumes() {
        return this.volumes;
    }

    public Optional<String> getDns() {
        return this.dns;
    }

    public Optional<String> getHostname() {
        return this.hostname;
    }

    public Optional<Integer> getMemory() {
        return this.memory;
    }

    public Optional<List<String>> getCommands() {
        return this.commands;
    }

    public Optional<Integer> getCpuShares() {
        return this.cpuShares;
    }

    public Optional<List<String>> getEnv() {
        return this.env;
    }

    public Optional<Map<Integer, Integer>> getPortBindings() {
        return this.portBindings;
    }

    public DockerTemplateOptions blockOnPort(int port, int seconds) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public DockerTemplateOptions inboundPorts(int ... ports) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public DockerTemplateOptions authorizePublicKey(String publicKey) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public DockerTemplateOptions installPrivateKey(String privateKey) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public DockerTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public DockerTemplateOptions dontAuthorizePublicKey() {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public DockerTemplateOptions nameTask(String name) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.nameTask(name));
    }

    public DockerTemplateOptions runAsRoot(boolean runAsRoot) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public DockerTemplateOptions runScript(Statement script) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.runScript(script));
    }

    public DockerTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public DockerTemplateOptions overrideLoginPassword(String password) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public DockerTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public DockerTemplateOptions overrideLoginUser(String loginUser) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public DockerTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public DockerTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public DockerTemplateOptions userMetadata(String key, String value) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public DockerTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public DockerTemplateOptions networks(Iterable<String> networks) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static DockerTemplateOptions volumes(Map<String, String> volumes) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.volumes(volumes);
        }

        public static DockerTemplateOptions dns(String dns) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.dns(dns);
        }

        public static DockerTemplateOptions hostname(String hostname) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.hostname(hostname);
        }

        public static DockerTemplateOptions memory(int memory) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.memory(memory);
        }

        public static DockerTemplateOptions commands(String ... commands) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.commands(commands);
        }

        public static DockerTemplateOptions commands(Iterable<String> commands) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.commands(commands);
        }

        public static DockerTemplateOptions cpuShares(int cpuShares) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.cpuShares(cpuShares);
        }

        public static DockerTemplateOptions env(String ... env) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.env(env);
        }

        public static DockerTemplateOptions env(Iterable<String> env) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.env(env);
        }

        public static DockerTemplateOptions portBindings(Map<Integer, Integer> portBindings) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.portBindings(portBindings);
        }

        public static DockerTemplateOptions inboundPorts(int ... ports) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.inboundPorts(ports);
        }

        public static DockerTemplateOptions blockOnPort(int port, int seconds) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.blockOnPort(port, seconds);
        }

        public static DockerTemplateOptions installPrivateKey(String rsaKey) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        public static DockerTemplateOptions authorizePublicKey(String rsaKey) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static DockerTemplateOptions userMetadata(Map<String, String> userMetadata) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.userMetadata((Map)userMetadata);
        }

        public static DockerTemplateOptions nodeNames(Iterable<String> nodeNames) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.nodeNames((Iterable)nodeNames);
        }

        public static DockerTemplateOptions networks(Iterable<String> networks) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.networks((Iterable)networks);
        }

        public static DockerTemplateOptions overrideLoginUser(String user) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static DockerTemplateOptions overrideLoginPassword(String password) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static DockerTemplateOptions overrideLoginPrivateKey(String privateKey) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static DockerTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static DockerTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static DockerTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }
    }
}

