/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.storage.softlayer;

import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.util.http.HttpToolResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.http.HttpResponse;
import org.jclouds.softlayer.SoftLayerApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftLayerRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(SoftLayerRestClient.class);
    private final String endpoint;
    private final String apiKey;
    private final String secretKey;
    private final ComputeServiceContext context;

    public static SoftLayerRestClient newInstance(JcloudsLocation loc) {
        return new SoftLayerRestClient((String)loc.config().get(JcloudsLocation.CLOUD_ENDPOINT), loc.getIdentity(), loc.getCredential(), loc.getComputeService().getContext());
    }

    public SoftLayerRestClient(String endpoint, String apiKey, String secretKey, ComputeServiceContext context) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.endpoint = endpoint;
        this.context = context;
    }

    public void close() {
        this.context.close();
    }

    public SoftLayerApi getSoftLayerApi() {
        return (SoftLayerApi)this.context.unwrapApi(SoftLayerApi.class);
    }

    public QuerySigner getQuerySigner() {
        return (QuerySigner)this.context.utils().injector().getInstance(QuerySigner.class);
    }

    public static JsonElement json(HttpToolResponse response) {
        return SoftLayerRestClient.json(new ByteArrayInputStream(response.getContent()));
    }

    public static JsonElement json(HttpResponse response) throws IOException {
        return SoftLayerRestClient.json(response.getPayload().openStream());
    }

    public static JsonElement json(InputStream is) {
        JsonParser parser = new JsonParser();
        JsonReader reader = null;
        try {
            reader = new JsonReader((Reader)new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JsonElement el = parser.parse(reader);
        return el;
    }

    public static String pretty(InputStream is) {
        return SoftLayerRestClient.pretty(SoftLayerRestClient.json(is));
    }

    public static String pretty(JsonElement js) {
        return SoftLayerRestClient.gson().toJson(js);
    }

    protected static Gson gson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }
}

