/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn.ibm;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.networking.sdn.SdnProviderImpl;
import brooklyn.networking.sdn.ibm.SdnVeAgent;
import brooklyn.networking.sdn.ibm.SdnVeNetwork;
import brooklyn.util.collections.MutableList;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.net.domain.IpPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdnVeNetworkImpl
extends SdnProviderImpl
implements SdnVeNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(SdnVeNetwork.class);

    @Override
    public void init() {
        LOG.info("Starting IBM SDN VE network id {}", (Object)this.getId());
        super.init();
        EntitySpec agentSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.getConfig((ConfigKey.HasConfigKey)SdnProvider.SDN_AGENT_SPEC, EntitySpec.create(SdnVeAgent.class)))).configure((ConfigKey.HasConfigKey)SdnVeAgent.SDN_PROVIDER, (Object)this);
        this.setAttribute((AttributeSensor)SdnProvider.SDN_AGENT_SPEC, agentSpec);
    }

    @Override
    public Collection<IpPermission> getIpPermissions(String source) {
        MutableList permissions = MutableList.of();
        return permissions;
    }

    @Override
    public void addHost(DockerHost host) {
        SshMachineLocation machine = ((DockerHostLocation)host.getDynamicLocation()).getMachine();
        EntitySpec spec = EntitySpec.create((EntitySpec)((EntitySpec)this.getAttribute((AttributeSensor)SDN_AGENT_SPEC))).configure((ConfigKey.HasConfigKey)SdnVeAgent.DOCKER_HOST, (Object)host);
        SdnVeAgent agent = (SdnVeAgent)this.getAgents().addChild(spec);
        Entities.manage((Entity)agent);
        this.getAgents().addMember((Entity)agent);
        agent.start((Collection)ImmutableList.of((Object)machine));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added IBM SDN VE agent {}", (Object)this, (Object)agent);
        }
    }

    @Override
    public void removeHost(DockerHost host) {
        SdnAgent agent = (SdnAgent)host.getAttribute(SdnAgent.SDN_AGENT);
        if (agent == null) {
            LOG.warn("{} cannot find dove agent: {}", (Object)this, (Object)host);
            return;
        }
        agent.stop();
        this.getAgents().removeMember((Entity)agent);
        Entities.unmanage((Entity)agent);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} removed IBM SDN VE agent {}", (Object)this, (Object)agent);
        }
    }
}

