/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn.calico;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.nosql.etcd.EtcdNode;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.calico.CalicoNodeImpl;
import brooklyn.util.flags.SetFromFlag;

@ImplementedBy(value=CalicoNodeImpl.class)
public interface CalicoNode
extends SdnAgent {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"0.4.2");
    @SetFromFlag(value="downloadUrl")
    public static final ConfigKey<String> DOWNLOAD_URL = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.DOWNLOAD_URL.getConfigKey(), (Object)"https://github.com/Metaswitch/calico-docker/releases/download/v${version}/calicoctl");
    @SetFromFlag(value="etcdNode")
    public static final AttributeSensorAndConfigKey<EtcdNode, EtcdNode> ETCD_NODE = ConfigKeys.newSensorAndConfigKey(EtcdNode.class, (String)"sdn.calico.etcd.node", (String)"The EtcdNode attached to the same DockerHost as the plugin");
    @SetFromFlag(value="powerstripPort")
    public static final ConfigKey<Integer> POWERSTRIP_PORT = ConfigKeys.newIntegerConfigKey((String)"powerstrip.port", (String)"Powerstrip port", (Integer)2377);
}

