/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn.calico;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.nosql.etcd.EtcdCluster;
import brooklyn.entity.nosql.etcd.EtcdNode;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.location.Location;
import brooklyn.location.PortRange;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.networking.sdn.SdnProviderImpl;
import brooklyn.networking.sdn.calico.CalicoNetwork;
import brooklyn.networking.sdn.calico.CalicoNode;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.QuorumCheck;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.net.Cidr;
import brooklyn.util.text.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalicoNetworkImpl
extends SdnProviderImpl
implements CalicoNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(CalicoNetwork.class);

    @Override
    public void init() {
        LOG.info("Starting Calico network id {}", (Object)this.getId());
        super.init();
        EntitySpec etcdNodeSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.getConfig((ConfigKey.HasConfigKey)EtcdCluster.ETCD_NODE_SPEC, EntitySpec.create(EtcdNode.class))));
        String etcdVersion = (String)this.config().get(ETCD_VERSION);
        if (Strings.isNonBlank((CharSequence)etcdVersion)) {
            etcdNodeSpec.configure(SoftwareProcess.SUGGESTED_VERSION, (Object)etcdVersion);
        }
        this.setAttribute((AttributeSensor)EtcdCluster.ETCD_NODE_SPEC, etcdNodeSpec);
        EtcdCluster etcd = (EtcdCluster)this.addChild((EntitySpec)EntitySpec.create(EtcdCluster.class).configure((ConfigKey)Cluster.INITIAL_SIZE, (Object)0).configure(EtcdCluster.ETCD_NODE_SPEC, (Object)etcdNodeSpec).configure(EtcdCluster.CLUSTER_NAME, (Object)"calico").configure(EtcdCluster.CLUSTER_TOKEN, (Object)"etcd-calico").configure(DynamicCluster.QUARANTINE_FAILED_ENTITIES, (Object)true).configure(DynamicCluster.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).configure(DynamicCluster.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).displayName("Calico Etcd Cluster"));
        if (Entities.isManaged((Entity)this)) {
            Entities.manage((Entity)etcd);
        }
        this.setAttribute(ETCD_CLUSTER, etcd);
        EntitySpec agentSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.getConfig((ConfigKey.HasConfigKey)SdnProvider.SDN_AGENT_SPEC, EntitySpec.create(CalicoNode.class)))).configure((ConfigKey.HasConfigKey)CalicoNode.SDN_PROVIDER, (Object)this);
        String calicoVersion = (String)this.config().get(CALICO_VERSION);
        if (Strings.isNonBlank((CharSequence)calicoVersion)) {
            agentSpec.configure(SoftwareProcess.SUGGESTED_VERSION, (Object)calicoVersion);
        }
        this.setAttribute((AttributeSensor)SdnProvider.SDN_AGENT_SPEC, agentSpec);
    }

    @Override
    public Collection<IpPermission> getIpPermissions(String source) {
        MutableList permissions = MutableList.of();
        PortRange etcdClientPortConfig = (PortRange)this.config().get((ConfigKey.HasConfigKey)EtcdNode.ETCD_CLIENT_PORT);
        Integer etcdClientPort = (Integer)etcdClientPortConfig.iterator().next();
        IpPermission etcdClientTcpPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(etcdClientPort.intValue()).toPort(etcdClientPort.intValue()).cidrBlock(Cidr.UNIVERSAL.toString()).build();
        permissions.add(etcdClientTcpPort);
        PortRange etcdPeerPortConfig = (PortRange)this.config().get((ConfigKey.HasConfigKey)EtcdNode.ETCD_PEER_PORT);
        Integer etcdPeerPort = (Integer)etcdPeerPortConfig.iterator().next();
        IpPermission etcdPeerTcpPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(etcdPeerPort.intValue()).toPort(etcdPeerPort.intValue()).cidrBlock(Cidr.UNIVERSAL.toString()).build();
        permissions.add(etcdPeerTcpPort);
        Integer powerstripPort = (Integer)this.config().get(CalicoNode.POWERSTRIP_PORT);
        IpPermission powerstripTcpPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(powerstripPort.intValue()).toPort(powerstripPort.intValue()).cidrBlock(source).build();
        permissions.add(powerstripTcpPort);
        return permissions;
    }

    @Override
    public InetAddress getNextAgentAddress(String agentId) {
        Entity agent = this.getManagementContext().getEntityManager().getEntity(agentId);
        String address = (String)((DockerHost)agent.getAttribute((AttributeSensor)CalicoNode.DOCKER_HOST)).getAttribute(Attributes.ADDRESS);
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException uhe) {
            throw Exceptions.propagate((Throwable)uhe);
        }
    }

    @Override
    public void rebind() {
        super.rebind();
    }

    @Override
    public void addHost(DockerHost host) {
        SshMachineLocation machine = ((DockerHostLocation)host.getDynamicLocation()).getMachine();
        EtcdCluster etcd = (EtcdCluster)this.getAttribute(ETCD_CLUSTER);
        EtcdNode node = (EtcdNode)etcd.addNode((Location)machine, Maps.newHashMap());
        node.start((Collection)ImmutableList.of((Object)machine));
        EntitySpec spec = EntitySpec.create((EntitySpec)((EntitySpec)this.getAttribute((AttributeSensor)SDN_AGENT_SPEC))).configure((ConfigKey.HasConfigKey)CalicoNode.DOCKER_HOST, (Object)host).configure(CalicoNode.ETCD_NODE, (Object)node);
        CalicoNode agent = (CalicoNode)this.getAgents().addChild(spec);
        Entities.manage((Entity)agent);
        this.getAgents().addMember((Entity)agent);
        agent.start((Collection)ImmutableList.of((Object)machine));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added calico plugin {}", (Object)this, (Object)agent);
        }
    }

    @Override
    public void removeHost(DockerHost host) {
        SdnAgent agent = (SdnAgent)host.getAttribute(SdnAgent.SDN_AGENT);
        if (agent == null) {
            LOG.warn("{} cannot find calico service: {}", (Object)this, (Object)host);
            return;
        }
        EtcdCluster etcd = (EtcdCluster)this.getAttribute(ETCD_CLUSTER);
        EtcdNode node = (EtcdNode)agent.getAttribute((AttributeSensor)CalicoNode.ETCD_NODE);
        etcd.removeMember((Entity)node);
        node.stop();
        agent.stop();
        this.getAgents().removeMember((Entity)agent);
        Entities.unmanage((Entity)agent);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} removed calico plugin {}", (Object)this, (Object)agent);
        }
    }

    static {
        RendererHints.register((AttributeSensor)ETCD_CLUSTER, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }
}

