/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker.strategy.affinity;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.location.Location;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.strategy.AbstractDockerPlacementStrategy;
import brooklyn.location.docker.strategy.affinity.AffinityRules;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerAffinityRuleStrategy
extends AbstractDockerPlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DockerAffinityRuleStrategy.class);

    @Override
    public List<DockerHostLocation> filterLocations(List<DockerHostLocation> locations, Entity entity) {
        ArrayList available = Lists.newArrayList();
        for (DockerHostLocation machine : locations) {
            Optional entityRules = Optional.fromNullable((Object)entity.config().get(DockerHost.DOCKER_HOST_AFFINITY_RULES));
            Optional hostRules = Optional.fromNullable((Object)machine.getOwner().config().get(DockerHost.DOCKER_HOST_AFFINITY_RULES));
            Optional infrastructureRules = Optional.fromNullable((Object)machine.getOwner().getInfrastructure().config().get(DockerHost.DOCKER_HOST_AFFINITY_RULES));
            Iterable combined = Iterables.concat((Iterable)Optional.presentInstances((Iterable)ImmutableList.of((Object)entityRules, (Object)hostRules, (Object)infrastructureRules)));
            AffinityRules rules = AffinityRules.rulesFor(entity).parse(combined);
            Collection entities = this.getBrooklynManagementContext().getEntityManager().findEntities(EntityPredicates.locationsIncludes((Location)machine));
            if (Iterables.isEmpty((Iterable)entities)) {
                if (!rules.allowEmptyLocations()) continue;
                available.add(machine);
                continue;
            }
            Iterable filtered = Iterables.filter((Iterable)entities, (Predicate)rules);
            if (Iterables.size((Iterable)filtered) != Iterables.size((Iterable)entities)) continue;
            available.add(machine);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Available Docker hosts: {}", (Object)Iterables.toString((Iterable)available));
        }
        return available;
    }
}

