/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.policy;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.location.docker.strategy.MaxContainersPlacementStrategy;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.math.MathFunctions;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerHeadroomEnricher
extends AbstractEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerHeadroomEnricher.class);
    @SetFromFlag(value="headroom")
    public static final ConfigKey<Integer> CONTAINER_HEADROOM = ConfigKeys.newIntegerConfigKey((String)"docker.container.cluster.headroom.count", (String)"Required headroom (number of free containers) for the Docker cluster");
    @SetFromFlag(value="headroomPercent")
    public static final ConfigKey<Double> CONTAINER_HEADROOM_PERCENTAGE = ConfigKeys.newDoubleConfigKey((String)"docker.container.cluster.headroom.percent", (String)"Required headroom (percentage free containers) for the Docker cluster");
    public static final AttributeSensor<Integer> CONTAINERS_NEEDED = Sensors.newIntegerSensor((String)"docker.container.cluster.needed", (String)"Number of containers needed to give requierd headroom");
    public static final AttributeSensor<Double> DOCKER_CONTAINER_UTILISATION = Sensors.newDoubleSensor((String)"docker.container.cluster.utilisation", (String)"Resource utilisation of Docker container cluster");
    public static final BasicNotificationSensor<Map> DOCKER_CONTAINER_CLUSTER_HOT = new BasicNotificationSensor(Map.class, "docker.container.cluster.hot", "Docker cluster has insufficient containers for current workload");
    public static final BasicNotificationSensor<Map> DOCKER_CONTAINER_CLUSTER_COLD = new BasicNotificationSensor(Map.class, "docker.container.cluster.cold", "Docker cluster has too many containers for current workload");
    public static final BasicNotificationSensor<Map> DOCKER_CONTAINER_CLUSTER_OK = new BasicNotificationSensor(Map.class, "docker.container.cluster.ok", "Docker cluster is ok for the current workload");
    private BasicNotificationSensor lastPublished = null;

    public void setEntity(EntityLocal entity) {
        Preconditions.checkArgument((boolean)(entity instanceof DockerInfrastructure), (String)"Entity must be a DockerInfrastructure: %s", (Object[])new Object[]{entity});
        super.setEntity(entity);
        Integer headroom = (Integer)this.config().get(CONTAINER_HEADROOM);
        Double percent = (Double)this.config().get(CONTAINER_HEADROOM_PERCENTAGE);
        Preconditions.checkArgument((boolean)(headroom != null ^ percent != null), (Object)"Headroom must be configured as either number or percentage for this enricher");
        if (headroom != null) {
            Preconditions.checkArgument((headroom > 0 ? 1 : 0) != 0, (String)"Headroom must be a positive integer: %d", (Object[])new Object[]{headroom});
        }
        if (percent != null) {
            Preconditions.checkArgument((percent > 0.0 && percent < 1.0 ? 1 : 0) != 0, (String)"Headroom percentage must be between 0.0 and 1.0: %f", (Object[])new Object[]{percent});
        }
        this.subscribe((Entity)entity, (Sensor)DockerInfrastructure.DOCKER_CONTAINER_COUNT, new Listener());
        this.subscribe((Entity)entity, (Sensor)DockerInfrastructure.DOCKER_HOST_COUNT, new Listener());
    }

    private void recalculate() {
        Integer maxContainers = null;
        List strategies = (List)this.entity.config().get(DockerInfrastructure.PLACEMENT_STRATEGIES);
        Optional lookup = Iterables.tryFind((Iterable)strategies, (Predicate)Predicates.instanceOf(MaxContainersPlacementStrategy.class));
        if (lookup.isPresent()) {
            maxContainers = (Integer)((MaxContainersPlacementStrategy)lookup.get()).config().get(MaxContainersPlacementStrategy.DOCKER_CONTAINER_CLUSTER_MAX_SIZE);
        }
        if (maxContainers == null) {
            maxContainers = (Integer)this.entity.config().get(MaxContainersPlacementStrategy.DOCKER_CONTAINER_CLUSTER_MAX_SIZE);
        }
        if (maxContainers == null) {
            maxContainers = MaxContainersPlacementStrategy.DEFAULT_MAX_CONTAINERS;
        }
        Integer containers = (Integer)this.entity.getAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT);
        Integer hosts = (Integer)this.entity.getAttribute(DockerInfrastructure.DOCKER_HOST_COUNT);
        if (containers == null || hosts == null) {
            return;
        }
        int possible = maxContainers * hosts;
        int available = possible - containers;
        Integer headroom = (Integer)this.config().get(CONTAINER_HEADROOM);
        Double percent = (Double)this.config().get(CONTAINER_HEADROOM_PERCENTAGE);
        if (headroom == null) {
            headroom = (int)Math.ceil(percent * (double)possible);
        }
        int needed = headroom - available;
        double utilisation = (double)containers.intValue() / (double)possible;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Headroom enricher: {} containers on {} hosts, {} available and {} needed", new Object[]{containers, hosts, available, needed});
        }
        double lowThreshold = (double)(possible - (headroom + maxContainers)) / (double)possible;
        lowThreshold = Math.max(0.0, lowThreshold);
        double highThreshold = (double)(possible - headroom) / (double)possible;
        highThreshold = Math.max(0.0, highThreshold);
        this.emit((Sensor)CONTAINERS_NEEDED, needed);
        this.emit((Sensor)DOCKER_CONTAINER_UTILISATION, utilisation);
        ImmutableMap properties = ImmutableMap.of((Object)"pool.current.size", (Object)hosts, (Object)"pool.current.workrate", (Object)utilisation, (Object)"pool.low.threshold", (Object)lowThreshold, (Object)"pool.high.threshold", (Object)highThreshold);
        if (needed > 0) {
            this.lastPublished = DOCKER_CONTAINER_CLUSTER_HOT;
            this.emit((Sensor)DOCKER_CONTAINER_CLUSTER_HOT, properties);
        } else if (available > headroom + maxContainers) {
            this.lastPublished = DOCKER_CONTAINER_CLUSTER_COLD;
            this.emit((Sensor)DOCKER_CONTAINER_CLUSTER_COLD, properties);
        } else if (this.lastPublished != null && this.lastPublished != DOCKER_CONTAINER_CLUSTER_OK) {
            this.lastPublished = DOCKER_CONTAINER_CLUSTER_OK;
            this.emit((Sensor)DOCKER_CONTAINER_CLUSTER_OK, properties);
        }
    }

    static {
        RendererHints.register(DOCKER_CONTAINER_UTILISATION, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)3)));
    }

    private class Listener
    implements SensorEventListener<Object> {
        private Listener() {
        }

        public void onEvent(SensorEvent<Object> event) {
            ContainerHeadroomEnricher.this.recalculate();
        }
    }
}

