/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker.application;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.VanillaSoftwareProcess;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.application.VanillaDockerApplicationImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;
import java.util.List;

@Catalog(name="Docker Container", description="A micro-service running in a Docker container.", iconUrl="classpath:///container.png")
@ImplementedBy(value=VanillaDockerApplicationImpl.class)
public interface VanillaDockerApplication
extends VanillaSoftwareProcess {
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    @SetFromFlag(value="dockerfileUrl")
    public static final ConfigKey<String> DOCKERFILE_URL = DockerAttributes.DOCKERFILE_URL;
    @SetFromFlag(value="containerName")
    public static final ConfigKey<String> CONTAINER_NAME = DockerContainer.DOCKER_CONTAINER_NAME.getConfigKey();
    @SetFromFlag(value="imageName")
    public static final ConfigKey<String> IMAGE_NAME = DockerAttributes.DOCKER_IMAGE_NAME.getConfigKey();
    @SetFromFlag(value="imageTag")
    public static final ConfigKey<String> IMAGE_TAG = DockerAttributes.DOCKER_IMAGE_TAG.getConfigKey();
    @SetFromFlag(value="openPorts")
    public static final ConfigKey<List<Integer>> DOCKER_OPEN_PORTS = DockerAttributes.DOCKER_OPEN_PORTS;
    @SetFromFlag(value="directPorts")
    public static final ConfigKey<List<Integer>> DOCKER_DIRECT_PORTS = DockerAttributes.DOCKER_DIRECT_PORTS;

    public DockerContainer getDockerContainer();

    public DockerHost getDockerHost();

    public String getDockerfile();

    public List<Integer> getContainerPorts();
}

