/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker.application;

import brooklyn.catalog.CatalogItem;
import brooklyn.entity.Entity;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.docker.application.VanillaDockerApplication;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.util.text.Strings;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import io.brooklyn.camp.brooklyn.spi.creation.service.BrooklynServiceTypeResolver;
import io.brooklyn.camp.brooklyn.spi.creation.service.ServiceTypeResolver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerServiceTypeResolver
extends BrooklynServiceTypeResolver {
    private static final Logger log = LoggerFactory.getLogger(ServiceTypeResolver.class);
    public static final String PREFIX = "docker";

    public String getTypePrefix() {
        return PREFIX;
    }

    public String getBrooklynType(String serviceType) {
        return VanillaDockerApplication.class.getName();
    }

    public CatalogItem<Entity, EntitySpec<?>> getCatalogItem(BrooklynComponentTemplateResolver resolver, String serviceType) {
        return null;
    }

    public <T extends Entity> void decorateSpec(BrooklynComponentTemplateResolver resolver, EntitySpec<T> spec) {
        String dockerServiceType = Strings.removeFromStart((String)resolver.getDeclaredType(), (String)"docker:");
        List parts = Splitter.on((String)":").splitToList((CharSequence)dockerServiceType);
        if (parts.isEmpty() || parts.size() > 2) {
            throw new IllegalArgumentException("Docker serviceType cannot be parsed: " + dockerServiceType);
        }
        String imageName = (String)Iterables.get((Iterable)parts, (int)0);
        String imageTag = (String)Iterables.get((Iterable)parts, (int)1, (Object)"latest");
        log.debug("Creating Docker service entity with image {} and tag {}", (Object)imageName, (Object)imageTag);
        spec.configure(DockerAttributes.DOCKER_IMAGE_NAME, (Object)imageName);
        if (parts.size() == 2) {
            spec.configure(DockerAttributes.DOCKER_IMAGE_TAG, (Object)imageTag);
        }
        if (resolver.getAttrs().containsKey("id")) {
            String containerName = (String)resolver.getAttrs().getStringKey("id");
            spec.configure(DockerAttributes.DOCKER_CONTAINER_NAME, (Object)containerName);
        }
        super.decorateSpec(resolver, spec);
    }
}

