/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BasicStartableImpl;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.DockerUtils;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.OsDetails;
import brooklyn.location.PortRange;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.PortRanges;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.location.docker.DockerContainerLocation;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsLocationConfig;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import brooklyn.location.jclouds.templates.PortableTemplateBuilder;
import brooklyn.management.LocationManager;
import brooklyn.networking.portforwarding.subnet.JcloudsPortforwardingSubnetLocation;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnAttributes;
import brooklyn.networking.subnet.SubnetTier;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.net.Cidr;
import brooklyn.util.net.Urls;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.docker.compute.options.DockerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerImpl
extends BasicStartableImpl
implements DockerContainer {
    private static final Logger LOG = LoggerFactory.getLogger(DockerContainer.class);
    private transient FunctionFeed status;

    public void init() {
        LOG.info("Starting Docker container id {}", (Object)this.getId());
        super.init();
        AtomicInteger counter = (AtomicInteger)((Entity)this.config().get((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE)).getAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNTER);
        String dockerContainerName = (String)this.config().get((ConfigKey.HasConfigKey)DOCKER_CONTAINER_NAME);
        String dockerContainerNameFormat = (String)this.config().get(DOCKER_CONTAINER_NAME_FORMAT);
        if (Strings.isBlank((CharSequence)dockerContainerName) && Strings.isNonBlank((CharSequence)dockerContainerNameFormat)) {
            dockerContainerName = String.format(dockerContainerNameFormat, this.getId(), counter.incrementAndGet());
        }
        if (Strings.isNonBlank((CharSequence)dockerContainerName)) {
            dockerContainerName = CharMatcher.BREAKING_WHITESPACE.trimAndCollapseFrom((CharSequence)dockerContainerName, '-');
            this.setDisplayName(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, dockerContainerName));
            this.setAttribute((AttributeSensor)DOCKER_CONTAINER_NAME, dockerContainerName);
        }
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_INFRASTRUCTURE);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_HOST);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)ENTITY);
    }

    protected void connectSensors() {
        this.status = FunctionFeed.builder().entity((EntityLocal)this).period(Duration.seconds((Number)15)).poll((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig((AttributeSensor)DOCKER_CONTAINER_NAME).period(Duration.minutes((Number)1))).callable((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String containerId = DockerContainerImpl.this.getContainerId();
                if (containerId == null) {
                    return "";
                }
                String name = DockerContainerImpl.this.getDockerHost().runDockerCommand("inspect -f {{.Name}} " + containerId);
                return Strings.removeFromStart((String)name, (String)"/");
            }
        }).onFailureOrException(Functions.constant((Object)""))).poll((FunctionPollConfig)new FunctionPollConfig(SERVICE_UP).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String containerId = DockerContainerImpl.this.getContainerId();
                if (containerId == null) {
                    return false;
                }
                return Strings.isNonBlank((CharSequence)DockerContainerImpl.this.getDockerHost().runDockerCommand("inspect -f {{.Id}} " + containerId));
            }
        }).onFailureOrException(Functions.constant((Object)Boolean.FALSE))).poll((FunctionPollConfig)new FunctionPollConfig(CONTAINER_RUNNING).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String containerId = DockerContainerImpl.this.getContainerId();
                if (containerId == null) {
                    return false;
                }
                String running = DockerContainerImpl.this.getDockerHost().runDockerCommand("inspect -f {{.State.Running}} " + containerId);
                return Strings.isNonBlank((CharSequence)running) && Boolean.parseBoolean(Strings.trim((String)running));
            }
        }).onFailureOrException(Functions.constant((Object)Boolean.FALSE))).poll((FunctionPollConfig)new FunctionPollConfig(CONTAINER_PAUSED).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String containerId = DockerContainerImpl.this.getContainerId();
                if (containerId == null) {
                    return false;
                }
                String running = DockerContainerImpl.this.getDockerHost().runDockerCommand("inspect -f {{.State.Paused}} " + containerId);
                return Strings.isNonBlank((CharSequence)running) && Boolean.parseBoolean(Strings.trim((String)running));
            }
        }).onFailureOrException(Functions.constant((Object)Boolean.FALSE))).build();
    }

    public void disconnectSensors() {
        if (this.status != null) {
            this.status.stop();
        }
    }

    @Override
    public Entity getRunningEntity() {
        return (Entity)this.getAttribute((AttributeSensor)ENTITY);
    }

    @Override
    public void setRunningEntity(Entity entity) {
        this.setAttribute((AttributeSensor)ENTITY, entity);
    }

    @Override
    public String getDockerContainerName() {
        return (String)this.getAttribute((AttributeSensor)DOCKER_CONTAINER_NAME);
    }

    @Override
    public String getContainerId() {
        return (String)this.getAttribute(CONTAINER_ID);
    }

    @Override
    public SshMachineLocation getMachine() {
        return (SshMachineLocation)this.getAttribute(SSH_MACHINE_LOCATION);
    }

    @Override
    public DockerHost getDockerHost() {
        return (DockerHost)this.config().get((ConfigKey.HasConfigKey)DOCKER_HOST);
    }

    public String getShortName() {
        return "Docker Container";
    }

    public DockerContainerLocation getDynamicLocation() {
        return (DockerContainerLocation)((Object)this.getAttribute(DYNAMIC_LOCATION));
    }

    public boolean isLocationAvailable() {
        return this.getDynamicLocation() != null;
    }

    @Override
    public void shutDown() {
        String dockerContainerName = (String)this.getAttribute((AttributeSensor)DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Stopping {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("kill " + this.getContainerId());
    }

    @Override
    public void pause() {
        String dockerContainerName = (String)this.getAttribute((AttributeSensor)DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Pausing {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("stop " + this.getContainerId());
    }

    @Override
    public void resume() {
        String dockerContainerName = (String)this.getAttribute((AttributeSensor)DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Resuming {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("start " + this.getContainerId());
    }

    private void removeContainer() {
        String dockerContainerName = (String)this.getAttribute((AttributeSensor)DockerContainer.DOCKER_CONTAINER_NAME);
        LOG.info("Removing {}", (Object)dockerContainerName);
        this.getDockerHost().runDockerCommand("rm " + this.getContainerId());
    }

    private DockerTemplateOptions getDockerTemplateOptions() {
        List entityPorts;
        Map entityEnvironment;
        List exports;
        Integer memory;
        Integer cpuShares;
        Entity entity = this.getRunningEntity();
        DockerTemplateOptions options = new DockerTemplateOptions();
        Boolean useHostDns = (Boolean)entity.config().get(DOCKER_USE_HOST_DNS_NAME);
        if (useHostDns == null) {
            useHostDns = (Boolean)this.config().get(DOCKER_USE_HOST_DNS_NAME);
        }
        if (useHostDns != null && useHostDns.booleanValue()) {
            String address;
            String hostname = (String)this.getDockerHost().getAttribute(Attributes.HOSTNAME);
            if (hostname.equalsIgnoreCase(address = (String)this.getDockerHost().getAttribute(Attributes.ADDRESS))) {
                options.hostname(this.getDockerContainerName());
            } else {
                options.hostname(hostname);
            }
        }
        if ((cpuShares = (Integer)entity.config().get(DOCKER_CPU_SHARES)) == null) {
            cpuShares = (Integer)this.config().get(DOCKER_CPU_SHARES);
        }
        if (cpuShares != null) {
            TemplateBuilder template;
            Integer hostCores = ((DockerHostLocation)this.getDockerHost().getDynamicLocation()).getMachine().getMachineDetails().getHardwareDetails().getCpuCount();
            Integer minCores = (Integer)entity.config().get(JcloudsLocationConfig.MIN_CORES);
            Map flags = (Map)entity.config().get((ConfigKey)SoftwareProcess.PROVISIONING_PROPERTIES);
            if (minCores == null && flags != null) {
                minCores = (Integer)flags.get(JcloudsLocationConfig.MIN_CORES.getName());
            }
            if (minCores == null && flags != null && (template = (TemplateBuilder)flags.get(JcloudsLocationConfig.TEMPLATE_BUILDER.getName())) != null) {
                minCores = 0;
                for (Processor cpu : template.build().getHardware().getProcessors()) {
                    minCores = minCores + (int)cpu.getCores();
                }
            }
            if (minCores != null) {
                double ratio = (double)minCores.intValue() / (double)(hostCores != null ? hostCores : 1);
                LOG.info("Cores: host {}, min {}, ratio {}", new Object[]{hostCores, minCores, ratio});
            }
        }
        if (cpuShares != null) {
            options.cpuShares(cpuShares);
        }
        if ((memory = (Integer)entity.config().get(DOCKER_MEMORY)) == null) {
            memory = (Integer)this.config().get(DOCKER_MEMORY);
        }
        if (memory != null) {
            TemplateBuilder template;
            Integer hostRam = ((DockerHostLocation)this.getDockerHost().getDynamicLocation()).getMachine().getMachineDetails().getHardwareDetails().getRam();
            Integer minRam = (Integer)entity.config().get(JcloudsLocationConfig.MIN_RAM);
            Map flags = (Map)entity.config().get((ConfigKey)SoftwareProcess.PROVISIONING_PROPERTIES);
            if (minRam == null && flags != null) {
                minRam = (Integer)flags.get(JcloudsLocationConfig.MIN_RAM.getName());
            }
            if (minRam == null && flags != null && (template = (TemplateBuilder)flags.get(JcloudsLocationConfig.TEMPLATE_BUILDER.getName())) != null) {
                minRam = template.build().getHardware().getRam();
            }
            if (minRam != null) {
                double ratio = (double)minRam.intValue() / (double)hostRam.intValue();
                LOG.info("Memory: host {}, min {}, ratio {}", new Object[]{hostRam, minRam, ratio});
            }
        }
        if (memory != null) {
            options.memory(memory);
        }
        MutableMap volumes = MutableMap.copyOf((Map)((Map)this.getDockerHost().getAttribute((AttributeSensor)DockerHost.DOCKER_HOST_VOLUME_MAPPING)));
        Map mapping = (Map)entity.config().get(DockerHost.DOCKER_HOST_VOLUME_MAPPING);
        if (mapping != null) {
            for (String source : mapping.keySet()) {
                if (Urls.isUrlWithProtocol((String)source)) {
                    String path = this.getDockerHost().deployArchive(source);
                    volumes.put(path, mapping.get(source));
                    continue;
                }
                volumes.put(source, mapping.get(source));
            }
        }
        if ((exports = (List)entity.config().get(DockerContainer.DOCKER_CONTAINER_VOLUME_EXPORT)) != null) {
            for (String dir : exports) {
                volumes.put(dir, dir);
            }
        }
        options.volumes((Map<String, String>)volumes);
        MutableList environment = MutableList.of();
        Map dockerEnvironment = (Map)this.config().get(DockerContainer.DOCKER_CONTAINER_ENVIRONMENT);
        if (dockerEnvironment != null) {
            environment.add(Joiner.on((String)":").withKeyValueSeparator("=").join(dockerEnvironment));
        }
        if ((entityEnvironment = (Map)entity.config().get(DockerContainer.DOCKER_CONTAINER_ENVIRONMENT)) != null) {
            environment.add(Joiner.on((String)":").withKeyValueSeparator("=").join(entityEnvironment));
        }
        options.env((Iterable<String>)environment);
        MutableMap bindings = MutableMap.of();
        List entityPortConfig = (List)entity.config().get(DockerAttributes.DOCKER_DIRECT_PORT_CONFIG);
        if (entityPortConfig != null) {
            for (PortAttributeSensorAndConfigKey key : entityPortConfig) {
                Integer port;
                PortRange range = (PortRange)entity.config().get((ConfigKey.HasConfigKey)key);
                if (range == null || range.isEmpty() || (port = (Integer)range.iterator().next()) == null) continue;
                bindings.put(port, port);
            }
        }
        if ((entityPorts = (List)entity.config().get(DockerAttributes.DOCKER_DIRECT_PORTS)) != null) {
            for (Integer port : entityPorts) {
                bindings.put(port, port);
            }
        }
        if (bindings.size() > 0) {
            options.portBindings((Map<Integer, Integer>)bindings);
        }
        Collection<Integer> entityOpenPorts = this.getRequiredOpenPorts(entity);
        options.inboundPorts(Ints.toArray(entityOpenPorts));
        LOG.debug("Docker options for {}: {}", (Object)this.getDockerHost(), (Object)options);
        options.overrideLoginPassword(this.getDockerHost().getPassword());
        return options;
    }

    @Nullable
    private String getSshHostAddress() {
        DockerHost dockerHost = this.getDockerHost();
        OsDetails osDetails = ((DockerHostLocation)dockerHost.getDynamicLocation()).getMachine().getMachineDetails().getOsDetails();
        if (osDetails.isMac()) {
            String address = dockerHost.execCommand("boot2docker ip");
            LOG.debug("The boot2docker IP address is {}", (Object)Strings.trim((String)address));
            return Strings.trim((String)address);
        }
        return null;
    }

    public DockerContainerLocation createLocation(Map flags) {
        DockerHost dockerHost = this.getDockerHost();
        DockerHostLocation host = (DockerHostLocation)dockerHost.getDynamicLocation();
        SubnetTier subnetTier = dockerHost.getSubnetTier();
        DockerTemplateOptions options = this.getDockerTemplateOptions();
        String containerName = (String)this.getRunningEntity().config().get((ConfigKey.HasConfigKey)DOCKER_CONTAINER_NAME);
        if (Strings.isBlank((CharSequence)containerName)) {
            containerName = (String)this.getAttribute((AttributeSensor)DOCKER_CONTAINER_NAME);
        }
        if (Strings.isNonBlank((CharSequence)containerName)) {
            options.nodeNames((Iterable)ImmutableList.of((Object)DockerUtils.allowed(containerName)));
        }
        MutableMap dockerFlags = MutableMap.builder().put((Object)JcloudsLocationConfig.TEMPLATE_BUILDER, (Object)new PortableTemplateBuilder().options((TemplateOptions)options)).put((Object)JcloudsLocationConfig.IMAGE_ID, this.config().get(DOCKER_IMAGE_ID)).put((Object)JcloudsLocationConfig.HARDWARE_ID, this.config().get(DOCKER_HARDWARE_ID)).put((Object)LocationConfigKeys.USER, (Object)"root").put((Object)LocationConfigKeys.PASSWORD, this.config().get(DOCKER_PASSWORD)).put((Object)SshTool.PROP_PASSWORD, this.config().get(DOCKER_PASSWORD)).put((Object)LocationConfigKeys.PRIVATE_KEY_DATA, null).put((Object)LocationConfigKeys.PRIVATE_KEY_FILE, null).put((Object)CloudLocationConfig.WAIT_FOR_SSHABLE, (Object)false).put((Object)JcloudsLocationConfig.INBOUND_PORTS, this.getRequiredOpenPorts(this.getRunningEntity())).put((Object)JcloudsLocation.USE_PORT_FORWARDING, (Object)true).put((Object)JcloudsLocation.PORT_FORWARDER, (Object)subnetTier.getPortForwarderExtension()).put((Object)JcloudsLocation.PORT_FORWARDING_MANAGER, (Object)subnetTier.getPortForwardManager()).put((Object)JcloudsPortforwardingSubnetLocation.PORT_FORWARDER, (Object)subnetTier.getPortForwarder()).put((Object)SubnetTier.SUBNET_CIDR, (Object)Cidr.CLASS_B).build();
        try {
            JcloudsSshMachineLocation container = (JcloudsSshMachineLocation)host.getJcloudsLocation().obtain((Map)dockerFlags);
            String containerId = container.getNode().getId();
            this.setAttribute(CONTAINER_ID, containerId);
            Entity entity = this.getRunningEntity();
            ((EntityLocal)entity).setAttribute(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)dockerHost.getInfrastructure());
            ((EntityLocal)entity).setAttribute(DockerContainer.DOCKER_HOST, (Object)dockerHost);
            ((EntityLocal)entity).setAttribute(DockerContainer.CONTAINER, (Object)this);
            ((EntityLocal)entity).setAttribute(DockerContainer.CONTAINER_ID, (Object)containerId);
            if (((Boolean)this.config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
                SdnAgent agent = (SdnAgent)Entities.attributeSupplierWhenReady((Entity)dockerHost, SdnAgent.SDN_AGENT).get();
                ArrayList networks = Lists.newArrayList((Object[])new String[]{entity.getApplicationId()});
                Collection extra = (Collection)entity.config().get(SdnAttributes.NETWORK_LIST);
                if (extra != null) {
                    networks.addAll(extra);
                }
                this.setAttribute(SdnAttributes.ATTACHED_NETWORKS, networks);
                ((EntityLocal)entity).setAttribute(SdnAttributes.ATTACHED_NETWORKS, (Object)networks);
                HashSet addresses = Sets.newHashSet();
                for (String networkId : networks) {
                    InetAddress address = agent.attachNetwork(containerId, networkId);
                    addresses.add(address.getHostAddress().toString());
                    if (!networkId.equals(entity.getApplicationId())) continue;
                    this.setAttribute(Attributes.SUBNET_ADDRESS, address.getHostAddress());
                }
                this.setAttribute(CONTAINER_ADDRESSES, addresses);
                ((EntityLocal)entity).setAttribute(CONTAINER_ADDRESSES, (Object)addresses);
            }
            LocationSpec spec = (LocationSpec)LocationSpec.create(DockerContainerLocation.class).parent((Location)host).configure(flags).configure(DynamicLocation.OWNER, (Object)this).configure((CharSequence)"machine", (Object)container).configure(container.config().getBag().getAllConfig()).configureIfNotNull(SshMachineLocation.SSH_HOST, (Object)this.getSshHostAddress()).displayName(this.getDockerContainerName());
            DockerContainerLocation location = (DockerContainerLocation)this.getManagementContext().getLocationManager().createLocation(spec);
            this.setAttribute(DYNAMIC_LOCATION, (Object)location);
            this.setAttribute((AttributeSensor)LOCATION_NAME, location.getId());
            LOG.info("New Docker container location {} created", (Object)location);
            return location;
        }
        catch (NoMachinesAvailableException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void deleteLocation() {
        DockerContainerLocation location = this.getDynamicLocation();
        if (location != null) {
            try {
                location.close();
            }
            catch (IOException ioe) {
                LOG.debug("Error closing container location", (Throwable)ioe);
            }
            LocationManager mgr = this.getManagementContext().getLocationManager();
            if (mgr.isManaged((Location)location)) {
                mgr.unmanage((Location)location);
            }
        }
        this.setAttribute(DYNAMIC_LOCATION, null);
        this.setAttribute((AttributeSensor)LOCATION_NAME, null);
    }

    protected Collection<Integer> getRequiredOpenPorts(Entity entity) {
        MutableSet ports = MutableSet.of((Object)22);
        for (ConfigKey k : entity.getEntityType().getConfigKeys()) {
            PortRange p;
            if (!PortRange.class.isAssignableFrom(k.getType()) || (p = (PortRange)entity.config().get(k)) == null || p.isEmpty()) continue;
            ports.add(p.iterator().next());
        }
        List entityOpenPorts = (List)entity.config().get(DockerAttributes.DOCKER_OPEN_PORTS);
        if (entityOpenPorts != null) {
            for (int i = 0; i < entityOpenPorts.size(); ++i) {
                Integer port = (Integer)entityOpenPorts.get(i);
                String name = String.format("docker.port.%02d", port);
                ((EntityInternal)entity).setAttribute(Sensors.newIntegerSensor((String)name), (Object)port);
                entity.config().set(ConfigKeys.newConfigKey(PortRange.class, (String)name), (Object)PortRanges.fromInteger((int)port));
            }
            ports.addAll(entityOpenPorts);
        }
        for (Entity child : entity.getChildren()) {
            ports.addAll(this.getRequiredOpenPorts(child));
        }
        LOG.debug("getRequiredOpenPorts detected default {} for {}", (Object)ports, (Object)entity);
        return ports;
    }

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        Boolean started = (Boolean)this.config().get(SoftwareProcess.ENTITY_STARTED);
        if (Boolean.TRUE.equals(started)) {
            DockerHost dockerHost = this.getDockerHost();
            DockerHostLocation host = (DockerHostLocation)dockerHost.getDynamicLocation();
            this.setAttribute(DockerContainer.IMAGE_ID, this.config().get(DOCKER_IMAGE_ID));
            this.setAttribute(DockerContainer.IMAGE_NAME, this.config().get(DockerAttributes.DOCKER_IMAGE_NAME));
            this.setAttribute(SSH_MACHINE_LOCATION, host.getMachine());
        } else {
            MutableMap flags = MutableMap.copyOf((Map)((Map)this.config().get(LOCATION_FLAGS)));
            DockerContainerLocation location = this.createLocation((Map)flags);
            this.setAttribute(SSH_MACHINE_LOCATION, location.getMachine());
        }
        this.connectSensors();
        super.start(locations);
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
    }

    public void rebind() {
        super.rebind();
        if (this.status == null) {
            this.connectSensors();
        }
    }

    public void stop() {
        Lifecycle state = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (Lifecycle.STOPPING.equals((Object)state) || Lifecycle.STOPPED.equals((Object)state)) {
            LOG.debug("Ignoring request to stop {} when it is already {}", (Object)this, (Object)state);
            LOG.trace("Duplicate stop came from: \n" + Joiner.on((String)"\n").join((Object[])Thread.getAllStackTraces().get(Thread.currentThread())));
            return;
        }
        LOG.info("Stopping {} when its state is {}", (Object)this, this.getAttribute(SERVICE_STATE_ACTUAL));
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPING);
        this.disconnectSensors();
        this.shutDown();
        this.removeContainer();
        this.setAttribute(SSH_MACHINE_LOCATION, null);
        Boolean started = (Boolean)this.config().get(SoftwareProcess.ENTITY_STARTED);
        if (!Boolean.TRUE.equals(started)) {
            this.deleteLocation();
        }
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPED);
    }

    public String getHostname() {
        return this.getDockerContainerName();
    }

    public Set<String> getPublicAddresses() {
        return Sets.newHashSet((Object[])new String[]{(String)this.getAttribute(SoftwareProcess.SUBNET_ADDRESS)});
    }

    public Set<String> getPrivateAddresses() {
        return (Set)this.getAttribute(CONTAINER_ADDRESSES);
    }

    static {
        RendererHints.register((AttributeSensor)DOCKER_HOST, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)ENTITY, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)CONTAINER, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }
}

