/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.entity.BrooklynAppLiveTestSupport;
import brooklyn.entity.basic.Entities;
import brooklyn.launcher.BrooklynLauncher;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

public class AbstractClockerIntegrationTest
extends BrooklynAppLiveTestSupport {
    private static final String DEFAULT_LOCATION_SPEC = "jclouds:softlayer:ams01";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClockerIntegrationTest.class);
    protected BrooklynLauncher launcher;
    protected Location testLocation;
    protected String testLocationSpec;

    @BeforeClass(alwaysRun=true)
    @Parameters(value={"locationSpec"})
    public void setSpec(@Optional String locationSpec) {
        this.testLocationSpec = Strings.isBlank((CharSequence)locationSpec) ? DEFAULT_LOCATION_SPEC : locationSpec;
        LOG.info("Running {} in {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)this.testLocationSpec);
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.testLocation = this.mgmt.getLocationRegistry().resolve(this.testLocationSpec);
        this.launcher = BrooklynLauncher.newInstance().managementContext((ManagementContext)this.mgmt).start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.mgmt != null) {
            Entities.destroyAll((ManagementContext)this.mgmt);
        }
        if (this.launcher != null) {
            this.launcher.terminate();
        }
    }
}

