/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityAndAttribute;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerAttributes;
import brooklyn.entity.container.docker.DockerCallbacks;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.location.Location;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerContainerLocation;
import brooklyn.location.docker.DockerLocation;
import brooklyn.location.docker.DockerVirtualLocation;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.networking.subnet.PortForwarder;
import brooklyn.networking.subnet.SubnetTier;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.mutex.MutexSupport;
import brooklyn.util.mutex.WithMutexes;
import brooklyn.util.net.Cidr;
import brooklyn.util.os.Os;
import brooklyn.util.text.Strings;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHostLocation
extends AbstractLocation
implements MachineProvisioningLocation<DockerContainerLocation>,
DockerVirtualLocation,
DynamicLocation<DockerHost, DockerHostLocation>,
WithMutexes,
Closeable {
    private static final long serialVersionUID = -1453203257759956820L;
    private static final Logger LOG = LoggerFactory.getLogger(DockerHostLocation.class);
    public static final String CONTAINER_MUTEX = "container";
    @SetFromFlag(value="mutex")
    private transient WithMutexes mutexSupport;
    @SetFromFlag(value="machine")
    private SshMachineLocation machine;
    @SetFromFlag(value="jcloudsLocation")
    private JcloudsLocation jcloudsLocation;
    @SetFromFlag(value="portForwarder")
    private PortForwarder portForwarder;
    @SetFromFlag(value="owner")
    private DockerHost dockerHost;
    @SetFromFlag(value="repository")
    private String repository;
    @SetFromFlag(value="images")
    private ConcurrentMap<String, CountDownLatch> images = Maps.newConcurrentMap();

    public DockerHostLocation() {
        this(Maps.newLinkedHashMap());
    }

    public DockerHostLocation(Map properties) {
        super(properties);
        if (this.isLegacyConstruction()) {
            this.init();
        }
    }

    public void init() {
        super.init();
        if (this.mutexSupport == null) {
            this.mutexSupport = new MutexSupport();
        }
        if (this.repository == null) {
            this.repository = this.machine.getId();
        }
    }

    public DockerContainerLocation obtain() throws NoMachinesAvailableException {
        return this.obtain(Maps.newLinkedHashMap());
    }

    public DockerContainerLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        try {
            this.acquireMutex(CONTAINER_MUTEX, "Obtaining container");
            Object context = flags.get(LocationConfigKeys.CALLER_CONTEXT.getName());
            if (context != null && !(context instanceof Entity)) {
                throw new IllegalStateException("Invalid location context: " + context);
            }
            Entity entity = (Entity)context;
            LOG.info("Configuring entity {} via subnet {}", (Object)entity, (Object)this.dockerHost.getSubnetTier());
            ((AbstractEntity)entity).setConfigEvenIfOwned(SubnetTier.PORT_FORWARDING_MANAGER, (Object)this.dockerHost.getSubnetTier().getPortForwardManager());
            ((AbstractEntity)entity).setConfigEvenIfOwned(SubnetTier.PORT_FORWARDER, (Object)this.portForwarder);
            ((AbstractEntity)entity).setConfigEvenIfOwned(SubnetTier.SUBNET_CIDR, (Object)Cidr.UNIVERSAL);
            this.configureEnrichers((AbstractEntity)entity);
            String dockerfile = (String)entity.getConfig(DockerAttributes.DOCKERFILE_URL);
            String imageId = (String)entity.getConfig(DockerAttributes.DOCKER_IMAGE_ID);
            String imageName = DockerAttributes.imageName(entity, dockerfile, this.repository);
            LOG.warn("ImageName for entity {}: {}", (Object)entity, (Object)imageName);
            String imageList = this.dockerHost.runDockerCommand("images --no-trunc " + Os.mergePaths((String[])new String[]{this.repository, imageName}));
            if (Strings.containsLiteral((CharSequence)imageList, (CharSequence)imageName)) {
                this.waitForImage(imageName);
                imageList = this.dockerHost.runDockerCommand("images --no-trunc " + Os.mergePaths((String[])new String[]{this.repository, imageName}));
                imageId = Strings.getFirstWordAfter((String)imageList, (String)"latest");
                LOG.info("Found image {} for entity: {}", (Object)imageName, (Object)imageId);
                ((AbstractEntity)entity).setConfigEvenIfOwned(SoftwareProcess.SKIP_INSTALLATION, (Object)true);
            } else {
                ((AbstractEntity)entity).setConfigEvenIfOwned(SoftwareProcess.POST_INSTALL_COMMAND, (Object)DockerCallbacks.commit());
                if (Strings.isNonBlank((CharSequence)dockerfile)) {
                    if (imageId != null) {
                        LOG.warn("Ignoring container imageId {} as dockerfile URL is set: {}", (Object)imageId, (Object)dockerfile);
                    }
                    imageId = this.dockerHost.createSshableImage(dockerfile, imageName);
                }
                if (Strings.isBlank((CharSequence)imageId)) {
                    imageId = (String)this.getOwner().getAttribute((AttributeSensor)DockerHost.DOCKER_IMAGE_ID);
                }
                this.images.putIfAbsent(imageName, new CountDownLatch(1));
                this.dockerHost.runDockerCommand(String.format("tag %s %s:latest", imageId, Os.mergePaths((String[])new String[]{this.repository, imageName})));
            }
            String hardwareId = (String)entity.getConfig(DockerAttributes.DOCKER_HARDWARE_ID);
            if (Strings.isEmpty((CharSequence)hardwareId)) {
                hardwareId = (String)this.getOwner().getConfig((ConfigKey.HasConfigKey)DockerAttributes.DOCKER_HARDWARE_ID);
            }
            LOG.info("Starting container with imageId {} and hardwareId {} at {}", new Object[]{imageId, hardwareId, this.machine});
            MutableMap containerFlags = MutableMap.builder().putAll(flags).put((Object)"entity", (Object)entity).putIfNotNull((Object)"imageId", (Object)imageId).putIfNotNull((Object)"hardwareId", (Object)hardwareId).build();
            DynamicCluster cluster = this.dockerHost.getDockerContainerCluster();
            Entity added = cluster.addNode((Location)this.machine, (Map)containerFlags);
            if (added == null) {
                throw new NoMachinesAvailableException(String.format("Failed to create container at %s", this.dockerHost.getDockerHostName()));
            }
            Entities.start((Entity)added, (Collection)ImmutableList.of((Object)this.machine));
            DockerContainer dockerContainer = (DockerContainer)added;
            ((EntityLocal)dockerContainer).setAttribute(DockerContainer.IMAGE_ID, (Object)imageId);
            ((EntityLocal)dockerContainer).setAttribute(DockerContainer.IMAGE_NAME, (Object)imageName);
            ((EntityLocal)dockerContainer).setAttribute(DockerContainer.HARDWARE_ID, (Object)hardwareId);
            ((EntityLocal)entity).setAttribute(DockerContainer.CONTAINER, (Object)dockerContainer);
            DockerContainerLocation dockerContainerLocation = (DockerContainerLocation)dockerContainer.getDynamicLocation();
            return dockerContainerLocation;
        }
        catch (InterruptedException ie) {
            throw Exceptions.propagate((Throwable)ie);
        }
        finally {
            this.releaseMutex(CONTAINER_MUTEX);
        }
    }

    public void waitForImage(String imageName) {
        try {
            CountDownLatch latch = (CountDownLatch)this.images.get(imageName);
            if (latch != null) {
                latch.await(15L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException ie) {
            throw Exceptions.propagate((Throwable)ie);
        }
    }

    public void markImage(String imageName) {
        CountDownLatch latch = (CountDownLatch)this.images.get(imageName);
        if (latch != null) {
            latch.countDown();
        }
    }

    private void configureEnrichers(AbstractEntity entity) {
        for (AttributeSensor sensor : Iterables.filter((Iterable)entity.getEntityType().getSensors(), AttributeSensor.class)) {
            Object target;
            if (DockerAttributes.URL_SENSOR_NAMES.contains(sensor.getName()) || sensor.getName().endsWith(".url")) {
                target = DockerAttributes.mappedSensor(sensor);
                entity.addEnricher(this.dockerHost.getSubnetTier().uriTransformingEnricher(EntityAndAttribute.supplier((Entity)entity, (AttributeSensor)sensor), target));
                Set hints = RendererHints.getHintsFor((Object)sensor, RendererHints.NamedActionWithUrl.class);
                for (RendererHints.Hint hint : hints) {
                    RendererHints.register(target, (RendererHints.Hint)((RendererHints.NamedActionWithUrl)hint));
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Mapped URL sensor: origin={}, mapped={}", (Object)sensor.getName(), (Object)target.getName());
                continue;
            }
            if (!PortAttributeSensorAndConfigKey.class.isAssignableFrom(sensor.getClass())) continue;
            target = DockerAttributes.mappedPortSensor((PortAttributeSensorAndConfigKey)sensor);
            entity.addEnricher(this.dockerHost.getSubnetTier().hostAndPortTransformingEnricher(EntityAndAttribute.supplier((Entity)entity, (AttributeSensor)sensor), target));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Mapped port sensor: origin={}, mapped={}", (Object)sensor.getName(), (Object)target.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DockerContainerLocation machine) {
        try {
            this.acquireMutex(CONTAINER_MUTEX, "Releasing container " + (Object)((Object)machine));
            LOG.info("Releasing {}", (Object)machine);
            DynamicCluster cluster = this.dockerHost.getDockerContainerCluster();
            DockerContainer container = machine.getOwner();
            if (cluster.removeMember((Entity)container)) {
                LOG.info("Docker Host {}: member {} released", (Object)this.dockerHost.getDockerHostName(), (Object)machine);
            } else {
                LOG.warn("Docker Host {}: member {} not found for release", (Object)this.dockerHost.getDockerHostName(), (Object)machine);
            }
            try {
                machine.close();
                container.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping container: " + container, (Throwable)e);
                Exceptions.propagateIfFatal((Throwable)e);
            }
            finally {
                Entities.unmanage((Entity)container);
            }
        }
        catch (InterruptedException ie) {
            throw Exceptions.propagate((Throwable)ie);
        }
        finally {
            this.releaseMutex(CONTAINER_MUTEX);
        }
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return MutableMap.of();
    }

    public DockerHost getOwner() {
        return this.dockerHost;
    }

    public String getRepository() {
        return this.repository;
    }

    public SshMachineLocation getMachine() {
        return this.machine;
    }

    public JcloudsLocation getJcloudsLocation() {
        return this.jcloudsLocation;
    }

    public PortForwarder getPortForwarder() {
        return this.portForwarder;
    }

    public int getCurrentSize() {
        return this.dockerHost.getCurrentSize();
    }

    public int getMaxSize() {
        return (Integer)this.dockerHost.getConfig(DockerHost.DOCKER_CONTAINER_CLUSTER_MAX_SIZE);
    }

    public MachineProvisioningLocation<DockerContainerLocation> newSubLocation(Map<?, ?> newFlags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Entity> getDockerContainerList() {
        return this.dockerHost.getDockerContainerList();
    }

    @Override
    public List<Entity> getDockerHostList() {
        return Lists.newArrayList((Object[])new Entity[]{this.dockerHost});
    }

    @Override
    public DockerInfrastructure getDockerInfrastructure() {
        return ((DockerLocation)this.getParent()).getDockerInfrastructure();
    }

    @Override
    public void close() throws IOException {
        LOG.info("Close called on Docker host {}: {}", (Object)this.machine, (Object)this);
        try {
            this.machine.close();
        }
        catch (Exception e) {
            LOG.info("{}: Closing Docker host: {}", (Object)e.getMessage(), (Object)this);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            LOG.info("Docker host closed: {}", (Object)this);
        }
    }

    public void acquireMutex(String mutexId, String description) throws InterruptedException {
        this.mutexSupport.acquireMutex(mutexId, description);
    }

    public boolean tryAcquireMutex(String mutexId, String description) {
        return this.mutexSupport.tryAcquireMutex(mutexId, description);
    }

    public void releaseMutex(String mutexId) {
        this.mutexSupport.releaseMutex(mutexId);
    }

    public boolean hasMutex(String mutexId) {
        return this.mutexSupport.hasMutex(mutexId);
    }

    public Objects.ToStringHelper string() {
        return super.string().add("machine", (Object)this.machine).add("jcloudsLocation", (Object)this.jcloudsLocation).add("dockerHost", (Object)this.dockerHost);
    }
}

