/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker;

import brooklyn.entity.Entity;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.location.Location;
import brooklyn.location.cloud.AbstractAvailabilityZoneExtension;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.DockerVirtualLocation;
import brooklyn.management.ManagementContext;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class DockerHostExtension
extends AbstractAvailabilityZoneExtension {
    private final DockerVirtualLocation location;

    public DockerHostExtension(ManagementContext managementContext, DockerVirtualLocation location) {
        super(managementContext);
        this.location = (DockerVirtualLocation)Preconditions.checkNotNull((Object)location, (Object)"location");
    }

    protected List<Location> doGetAllSubLocations() {
        ArrayList result = Lists.newArrayList();
        for (Entity entity : this.location.getDockerHostList()) {
            DockerHost host = (DockerHost)entity;
            DockerHostLocation machine = (DockerHostLocation)host.getDynamicLocation();
            result.add(Optional.fromNullable((Object)machine));
        }
        return ImmutableList.copyOf((Iterable)Optional.presentInstances((Iterable)result));
    }

    public List<Location> getAllSubLocations() {
        this.subLocations.set(null);
        return super.getAllSubLocations();
    }

    protected boolean isNameMatch(Location loc, Predicate<? super String> namePredicate) {
        return namePredicate.apply((Object)((DockerHostLocation)loc).getDockerInfrastructure().getId());
    }
}

