/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.container.docker.DockerAttributes;
import brooklyn.entity.container.docker.DockerCallbacks;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.location.Location;
import brooklyn.location.PortRange;
import brooklyn.location.access.PortForwardManager;
import brooklyn.location.basic.HasSubnetHostname;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.basic.SupportsPortForwarding;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import brooklyn.location.jclouds.JcloudsUtil;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.net.Cidr;
import brooklyn.util.net.Protocol;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.IptablesCommands;
import brooklyn.util.time.Duration;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerLocation
extends SshMachineLocation
implements SupportsPortForwarding,
HasSubnetHostname,
DynamicLocation<DockerContainer, DockerContainerLocation> {
    private static final long serialVersionUID = 610389734596906782L;
    private static final Logger LOG = LoggerFactory.getLogger(DockerContainerLocation.class);
    @SetFromFlag(value="entity")
    private Entity entity;
    @SetFromFlag(value="machine")
    private JcloudsSshMachineLocation machine;
    @SetFromFlag(value="owner")
    private DockerContainer dockerContainer;

    public void init() {
        super.init();
    }

    public DockerContainer getOwner() {
        return this.dockerContainer;
    }

    public JcloudsSshMachineLocation getMachine() {
        return this.machine;
    }

    public String getRepository() {
        return this.dockerContainer.getDockerHost().getRepository();
    }

    private void addIptablesRule(Integer port) {
        if (((Boolean)this.getOwner().getConfig(DockerInfrastructure.OPEN_IPTABLES)).booleanValue()) {
            SshMachineLocation host = ((DockerHostLocation)this.getOwner().getDockerHost().getDynamicLocation()).getMachine();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using iptables to add access for TCP/{} to {}", (Object)port, (Object)host);
            }
            ImmutableList commands = ImmutableList.of((Object)IptablesCommands.insertIptablesRule((IptablesCommands.Chain)IptablesCommands.Chain.INPUT, (Protocol)Protocol.TCP, (int)port, (IptablesCommands.Policy)IptablesCommands.Policy.ACCEPT));
            int result = host.execCommands(String.format("Open iptables TCP/%d", port), (List)commands);
            if (result != 0) {
                String msg = String.format("Error running iptables update for TCP/%d on %s", port, host);
                LOG.error(msg);
                throw new RuntimeException(msg);
            }
        }
    }

    public int getMappedPort(int portNumber) {
        String containerId = this.getOwner().getContainerId();
        Map mapping = JcloudsUtil.dockerPortMappingsFor((JcloudsLocation)this.getOwner().getDockerHost().getJcloudsLocation(), (String)containerId);
        Integer publicPort = (Integer)mapping.get(portNumber);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Docker mapped port {} to {} for Container {}", new Object[]{portNumber, publicPort, containerId});
        }
        return publicPort;
    }

    public boolean obtainSpecificPort(int portNumber) {
        boolean result = this.machine.obtainSpecificPort(portNumber);
        if (result) {
            int targetPort = this.getMappedPort(portNumber);
            this.mapPort(targetPort, portNumber);
            this.addIptablesRule(targetPort);
        }
        return result;
    }

    public int obtainPort(PortRange range) {
        int portNumber = this.machine.obtainPort(range);
        int targetPort = this.getMappedPort(portNumber);
        this.mapPort(targetPort, portNumber);
        this.addIptablesRule(targetPort);
        return portNumber;
    }

    private void mapPort(int hostPort, int containerPort) {
        String dockerHost = this.getAddress().getHostAddress();
        PortForwardManager portForwardManager = this.getOwner().getDockerHost().getSubnetTier().getPortForwardManager();
        portForwardManager.recordPublicIpHostname(dockerHost, dockerHost);
        portForwardManager.acquirePublicPortExplicit(dockerHost, hostPort);
        portForwardManager.associate(dockerHost, hostPort, (Location)this, containerPort);
    }

    public HostAndPort getSocketEndpointFor(Cidr accessor, int privatePort) {
        String dockerHost = this.getAddress().getHostAddress();
        int hostPort = this.getMappedPort(privatePort);
        return HostAndPort.fromParts((String)dockerHost, (int)hostPort);
    }

    public int execScript(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        Iterable filtered = Iterables.filter(commands, DockerCallbacks.FILTER);
        for (String dockerCommand : filtered) {
            this.parseDockerCallback(dockerCommand);
        }
        return super.execScript(props, summaryForLogging, commands, env);
    }

    public int execCommands(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        Iterable filtered = Iterables.filter(commands, DockerCallbacks.FILTER);
        for (String dockerCommand : filtered) {
            this.parseDockerCallback(dockerCommand);
        }
        return super.execCommands(props, summaryForLogging, commands, env);
    }

    private void parseDockerCallback(String dockerCommand) {
        List tokens = DockerCallbacks.PARSER.splitToList((CharSequence)dockerCommand);
        String command = (String)tokens.get(1);
        if ("commit".equalsIgnoreCase(command)) {
            String containerId = this.getOwner().getContainerId();
            String imageName = (String)this.getOwner().getAttribute(DockerContainer.IMAGE_NAME);
            String output = this.getOwner().getDockerHost().runDockerCommandTimeout(String.format("commit %s %s", containerId, Os.mergePaths((String[])new String[]{this.getRepository(), imageName})), Duration.minutes((Number)15));
            String imageId = DockerAttributes.checkId(output);
            ((EntityLocal)this.getOwner().getRunningEntity()).setAttribute(DockerContainer.IMAGE_ID, (Object)imageId);
            ((EntityLocal)this.getOwner()).setAttribute(DockerContainer.IMAGE_ID, (Object)imageId);
            ((DockerHostLocation)this.getOwner().getDockerHost().getDynamicLocation()).markImage(imageName);
        } else if ("push".equalsIgnoreCase(command)) {
            String imageName = (String)this.getOwner().getAttribute(DockerContainer.IMAGE_NAME);
            this.getOwner().getDockerHost().runDockerCommand(String.format("push %s", Os.mergePaths((String[])new String[]{this.getRepository(), imageName})));
        } else {
            LOG.warn("Unknown Docker host command: {}", (Object)command);
        }
    }

    public void releasePort(int portNumber) {
        this.machine.releasePort(portNumber);
    }

    public InetAddress getAddress() {
        return ((DockerHostLocation)this.getOwner().getDockerHost().getDynamicLocation()).getMachine().getAddress();
    }

    public void close() throws IOException {
        LOG.info("Close called on Docker container {}: {}", (Object)this.machine, (Object)this);
        try {
            this.machine.close();
        }
        catch (Exception e) {
            LOG.info("{}: Closing Docker container: {}", (Object)e.getMessage(), (Object)this);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            LOG.info("Docker container closed: {}", (Object)this);
        }
    }

    public Objects.ToStringHelper string() {
        return super.string().add("entity", (Object)this.entity).add("machine", (Object)this.machine).add("owner", (Object)this.dockerContainer);
    }

    public String getSubnetHostname() {
        return this.getSubnetIp();
    }

    public String getSubnetIp() {
        String containerAddress = this.getOwner().getDockerHost().runDockerCommand("inspect --format={{.NetworkSettings.IPAddress}} " + this.getOwner().getContainerId());
        return containerAddress.trim();
    }
}

