/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.lifecycle.ScriptHelper;
import brooklyn.entity.container.docker.DockerAttributes;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerHostDriver;
import brooklyn.entity.container.docker.DockerHostImpl;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.event.AttributeSensor;
import brooklyn.location.OsDetails;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import brooklyn.location.jclouds.networking.JcloudsLocationSecurityGroupCustomizer;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.file.ArchiveUtils;
import brooklyn.util.net.Networking;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class DockerHostSshDriver
extends AbstractSoftwareProcessSshDriver
implements DockerHostDriver {
    public DockerHostSshDriver(DockerHostImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    protected Map<String, Integer> getPortMap() {
        return MutableMap.of((Object)"dockerPort", (Object)this.getDockerPort());
    }

    @Override
    public Integer getDockerPort() {
        return (Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_PORT);
    }

    @Override
    public String getRepository() {
        return (String)this.getEntity().getAttribute(DockerHost.DOCKER_REPOSITORY);
    }

    @Override
    public String buildImage(String dockerFile, String name) {
        ProcessTaskWrapper task = ((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{String.format("mkdir -p %s", Os.mergePaths((String[])new String[]{this.getRunDir(), name}))}).machine(this.getMachine())).newTask();
        DynamicTasks.queueIfPossible((TaskAdaptable)task).executionContext((Entity)this.getEntity()).orSubmitAndBlock();
        int result = (Integer)task.get();
        if (result != 0) {
            throw new IllegalStateException("Error creating image directory: " + name);
        }
        this.copyTemplate(dockerFile, Os.mergePaths((String[])new String[]{name, "BaseDockerfile"}));
        String baseImageId = this.getImageId("BaseDockerfile", name);
        log.info("Created base Dockerfile image with ID {}", (Object)baseImageId);
        this.copyTemplate("classpath://brooklyn/entity/container/docker/SshdDockerfile", Os.mergePaths((String[])new String[]{name, "SshdDockerfile"}), (Map)MutableMap.of((Object)"repository", (Object)this.getRepository(), (Object)"imageName", (Object)name));
        String sshdImageId = this.getImageId("SshdDockerfile", name);
        log.info("Created SSHable Dockerfile image with ID {}", (Object)sshdImageId);
        return sshdImageId;
    }

    private String getImageId(String dockerfile, String name) {
        String build = String.format("build --rm -t %s - < %s", Os.mergePaths((String[])new String[]{this.getRepository(), name}), Os.mergePaths((String[])new String[]{this.getRunDir(), name, dockerfile}));
        String stdout = ((DockerHost)this.getEntity()).runDockerCommandTimeout(build, Duration.minutes((Number)15));
        String prefix = Strings.getFirstWordAfter((String)stdout, (String)"Successfully built");
        String inspect = String.format("inspect --format={{.Id}} %s", prefix);
        String imageId = ((DockerHost)this.getEntity()).runDockerCommand(inspect);
        return DockerAttributes.checkId(imageId);
    }

    public String getEpelRelease() {
        return (String)this.getEntity().getConfig(DockerHost.EPEL_RELEASE);
    }

    public boolean isRunning() {
        ScriptHelper helper = this.newScript((String)"check-running").body.append((CharSequence)BashCommands.alternatives((String[])new String[]{BashCommands.ifExecutableElse1((String)"boot2docker", (String)BashCommands.sudo((String)"boot2docker status")), BashCommands.ifExecutableElse1((String)"service", (String)BashCommands.sudo((String)"service docker status"))})).failOnNonZeroResultCode().gatherOutput();
        helper.execute();
        return helper.getResultStdout().contains("running");
    }

    public void stop() {
        this.newScript((String)"stopping").body.append((CharSequence)BashCommands.alternatives((String[])new String[]{BashCommands.ifExecutableElse1((String)"boot2docker", (String)BashCommands.sudo((String)"boot2docker down")), BashCommands.ifExecutableElse1((String)"service", (String)BashCommands.sudo((String)"service docker stop"))})).failOnNonZeroResultCode().execute();
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("docker-%s", this.getVersion()))}));
    }

    public void install() {
        ImmutableList commands;
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        String osVersion = osDetails.getVersion();
        String arch = osDetails.getArch();
        if (!osDetails.is64bit()) {
            throw new IllegalStateException("Docker supports only 64bit OS");
        }
        if (osDetails.getName().equalsIgnoreCase("ubuntu") && osVersion.equals("12.04")) {
            commands = ImmutableList.builder().add((Object)BashCommands.installPackage((String)"linux-image-generic-lts-raring")).add((Object)BashCommands.installPackage((String)"linux-headers-generic-lts-raring")).add((Object)BashCommands.sudo((String)"reboot")).build();
            this.executeKernelInstallation((List<String>)commands);
        }
        if (osDetails.getName().equalsIgnoreCase("centos")) {
            commands = ImmutableList.builder().add((Object)BashCommands.sudo((String)"yum -y --nogpgcheck upgrade kernel")).add((Object)BashCommands.sudo((String)"reboot")).build();
            this.executeKernelInstallation((List<String>)commands);
        }
        log.info("waiting for Docker host {} to be sshable", (Object)this.getLocation());
        boolean isSshable = Repeater.create().every(Duration.TEN_SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return DockerHostSshDriver.this.getLocation().isSshable();
            }
        }).limitTimeTo(Duration.minutes((Number)15)).run();
        if (!isSshable) {
            throw new IllegalStateException(String.format("The entity %s is not ssh'able after reboot", this.entity));
        }
        log.info("Docker host {} is now sshable; continuing with setup", (Object)this.getLocation());
        ArrayList commands2 = Lists.newArrayList();
        if (osDetails.getName().equalsIgnoreCase("ubuntu")) {
            commands2.add(this.installDockerOnUbuntu());
        } else if (osDetails.getName().equalsIgnoreCase("centos")) {
            commands2.add(BashCommands.ifExecutableElse0((String)"yum", (String)this.useYum(osVersion, arch, this.getEpelRelease())));
            commands2.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"docker-io"), null));
        } else {
            commands2.add(BashCommands.chainGroup((String[])new String[]{BashCommands.INSTALL_CURL, "curl -s https://get.docker.io/ | sudo sh"}));
        }
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append((Collection)commands2).execute();
    }

    private void executeKernelInstallation(List<String> commands) {
        this.newScript((String)"installingkernel").body.append(commands).execute();
    }

    private String useYum(String osVersion, String arch, String epelRelease) {
        String osMajorVersion = osVersion.substring(0, osVersion.lastIndexOf("."));
        return BashCommands.chainGroup((String[])new String[]{BashCommands.INSTALL_WGET, BashCommands.alternatives((String[])new String[]{BashCommands.sudo((String)"rpm -qa | grep epel-release"), BashCommands.sudo((String)String.format("rpm -Uvh http://dl.fedoraproject.org/pub/epel/%s/%s/epel-release-%s.noarch.rpm", osMajorVersion, arch, epelRelease))})});
    }

    private String installDockerOnUbuntu() {
        return BashCommands.chainGroup((String[])new String[]{BashCommands.INSTALL_CURL, "curl -s https://get.docker.io/ubuntu/ | sudo sh"});
    }

    public void customize() {
        Networking.checkPortsValid(this.getPortMap());
        this.stop();
        this.newScript((String)"customizing").failOnNonZeroResultCode().body.append(new CharSequence[]{BashCommands.ifExecutableElse0((String)"apt-get", (String)BashCommands.chainGroup((String[])new String[]{BashCommands.executeCommandThenAsUserTeeOutputToFile((String)String.format("echo 'DOCKER_OPTS=\"-H tcp://0.0.0.0:%s -H unix:///var/run/docker.sock\"'", this.getDockerPort()), (String)"root", (String)"/etc/default/docker"), BashCommands.sudo((String)"groupadd -f docker"), BashCommands.sudo((String)String.format("gpasswd -a %s docker", this.getMachine().getUser())), BashCommands.sudo((String)"newgrp docker")})), BashCommands.ifExecutableElse0((String)"yum", (String)BashCommands.executeCommandThenAsUserTeeOutputToFile((String)String.format("echo 'other_args=\"--selinux-enabled -H tcp://0.0.0.0:%s -H unix:///var/run/docker.sock -e lxc\"'", this.getDockerPort()), (String)"root", (String)"/etc/sysconfig/docker"))}).execute();
        MutableMap mapping = MutableMap.of();
        Map volumes = (Map)this.getEntity().getConfig(DockerHost.DOCKER_HOST_VOLUME_MAPPING);
        if (volumes != null) {
            for (String source : volumes.keySet()) {
                if (Urls.isUrlWithProtocol((String)source)) {
                    String path = this.deployArchive(source);
                    mapping.put(path, volumes.get(source));
                    continue;
                }
                mapping.put(source, volumes.get(source));
            }
        }
        this.getEntity().setAttribute(DockerHost.DOCKER_HOST_VOLUME_MAPPING, (Object)mapping);
    }

    @Override
    public String deployArchive(String url) {
        String volumeId = Identifiers.makeIdFromHash((long)url.hashCode());
        String path = Os.mergePaths((String[])new String[]{this.getRunDir(), volumeId});
        ArchiveUtils.deploy((String)url, (SshMachineLocation)this.getMachine(), (String)path);
        return path;
    }

    @Override
    public void configureSecurityGroups() {
        String securityGroup = (String)this.getEntity().getConfig(DockerInfrastructure.SECURITY_GROUP);
        if (Strings.isBlank((CharSequence)securityGroup)) {
            if (!(this.getLocation() instanceof JcloudsSshMachineLocation)) {
                log.info("{} not running in a JcloudsSshMachineLocation, not configuring extra security groups", (Object)this.entity);
                return;
            }
            JcloudsSshMachineLocation location = (JcloudsSshMachineLocation)this.getLocation();
            Collection<IpPermission> permissions = this.getIpPermissions();
            log.debug("Applying custom security groups to {}: {}", (Object)location, permissions);
            JcloudsLocationSecurityGroupCustomizer.getInstance((String)this.getEntity().getApplicationId()).addPermissionsToLocation(location, permissions);
        }
    }

    protected Collection<IpPermission> getIpPermissions() {
        IpPermission dockerPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_PORT)).intValue()).toPort(((Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_PORT)).intValue()).cidrBlock(JcloudsLocationSecurityGroupCustomizer.getInstance((Entity)this.getEntity()).getBrooklynCidrBlock()).build();
        IpPermission dockerSslPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_SSL_PORT)).intValue()).toPort(((Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_SSL_PORT)).intValue()).cidrBlock(JcloudsLocationSecurityGroupCustomizer.getInstance((Entity)this.getEntity()).getBrooklynCidrBlock()).build();
        IpPermission dockerPortForwarding = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(49000).toPort(49900).cidrBlock(JcloudsLocationSecurityGroupCustomizer.getInstance((Entity)this.getEntity()).getBrooklynCidrBlock()).build();
        return ImmutableList.of((Object)dockerPort, (Object)dockerSslPort, (Object)dockerPortForwarding);
    }

    public String getPidFile() {
        return "/var/run/docker.pid";
    }

    public void launch() {
        this.newScript((String)"launching").body.append((CharSequence)BashCommands.alternatives((String[])new String[]{BashCommands.ifExecutableElse1((String)"boot2docker", (String)BashCommands.sudo((String)"boot2docker up")), BashCommands.ifExecutableElse1((String)"service", (String)BashCommands.sudo((String)"service docker start"))})).failOnNonZeroResultCode().uniqueSshConnection().execute();
    }
}

