/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.branch.indexing.BranchUniversalObject;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.R;
import io.branch.referral.util.LinkProperties;
import java.util.HashMap;

public class LinkingValidatorDialogRowItem
extends LinearLayout {
    private static final String TAG = "BranchSDK";
    TextView titleText;
    Button infoButton;
    String infoText;
    Button actionButton;
    HashMap<String, String> linkDataParams;
    String routingKey;
    String routingValue;
    String canonicalIdentifier;
    Context context;
    Button debugButton;
    String debugText;

    public LinkingValidatorDialogRowItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public LinkingValidatorDialogRowItem(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
    }

    public void InitializeRow(String title, String infoText, String debugText, String routingKey, String routingValue, String canonicalIdentifier, boolean isSharableLink, int index, String ... params) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.linking_validator_dialog_row_item, null);
        this.addView(view);
        this.titleText = (TextView)view.findViewById(R.id.linkingValidatorRowTitleText);
        this.infoButton = (Button)view.findViewById(R.id.linkingValidatorRowInfoButton);
        this.actionButton = (Button)view.findViewById(R.id.linkingValidatorRowActionButton);
        this.debugButton = (Button)view.findViewById(R.id.linkingValidatorRowDebugButton);
        this.titleText.setText((CharSequence)title);
        this.infoText = infoText;
        this.debugText = debugText;
        this.routingKey = routingKey;
        this.routingValue = routingValue;
        this.canonicalIdentifier = canonicalIdentifier;
        this.linkDataParams = new HashMap();
        for (int i = 0; i < params.length; i += 2) {
            this.linkDataParams.put(params[i], params[i + 1]);
        }
        this.linkDataParams.put(routingKey, routingValue);
        this.infoButton.setOnClickListener(view1 -> this.HandleInfoButtonClicked());
        this.debugButton.setOnClickListener(view2 -> this.HandleDebugButtonClicked());
        if (isSharableLink) {
            this.actionButton.setText((CharSequence)"Share");
            this.actionButton.setOnClickListener(view2 -> this.HandleShareButtonClicked());
        } else {
            this.actionButton.setText((CharSequence)"Test");
            if (index == 4) {
                this.actionButton.setOnClickListener(view2 -> this.HandleWarmStartClick());
            } else if (index == 5) {
                this.actionButton.setOnClickListener(view2 -> this.HandleForegroundLinkClick());
            }
        }
    }

    private void HandleInfoButtonClicked() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setMessage((CharSequence)this.infoText).setTitle(this.titleText.getText());
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private void HandleShareButtonClicked() {
        LinkProperties lp = new LinkProperties();
        for (String key : this.linkDataParams.keySet()) {
            lp.addControlParameter(key, this.linkDataParams.get(key));
        }
        BranchUniversalObject buo = new BranchUniversalObject().setCanonicalIdentifier(this.canonicalIdentifier);
        if (Build.VERSION.SDK_INT >= 22) {
            Branch.getInstance().share(this.getActivity(this.context), buo, lp, new Branch.BranchNativeLinkShareListener(){

                @Override
                public void onLinkShareResponse(String sharedLink, BranchError error) {
                }

                @Override
                public void onChannelSelected(String channelName) {
                }
            }, this.titleText.getText().toString(), this.infoText);
        }
    }

    private void HandleDebugButtonClicked() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setMessage((CharSequence)this.debugText).setTitle((CharSequence)(this.titleText.getText() + " not working?"));
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private void HandleWarmStartClick() {
        this.getActivity(this.context).moveTaskToBack(true);
        this.HandleForegroundLinkClick();
    }

    private void HandleForegroundLinkClick() {
        BranchUniversalObject buo = new BranchUniversalObject().setCanonicalIdentifier(this.canonicalIdentifier);
        LinkProperties lp = new LinkProperties();
        lp.addControlParameter(this.routingKey, this.routingValue);
        for (int i = 0; i < this.linkDataParams.size(); i += 2) {
            lp.addControlParameter(this.linkDataParams.get(i), this.linkDataParams.get(i + 1));
        }
        String branchLink = buo.getShortUrl(this.context, lp);
        Intent intent = new Intent(this.getContext(), this.getActivity(this.context).getClass());
        intent.putExtra("branch", branchLink);
        intent.putExtra("branch_force_new_session", true);
        this.getActivity(this.context).startActivity(intent);
    }

    public Activity getActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            return this.getActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }
}

