/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.widget.Button;
import android.widget.TextView;
import io.branch.referral.Branch;
import io.branch.referral.R;
import io.branch.referral.validators.IntegrationValidator;
import io.branch.referral.validators.IntegrationValidatorDialogRowItem;
import io.branch.referral.validators.LinkingValidator;

public class IntegrationValidatorDialog
extends Dialog {
    IntegrationValidatorDialogRowItem autoInstanceValidatorRowItem;
    IntegrationValidatorDialogRowItem verifyBranchKeysRowItem;
    IntegrationValidatorDialogRowItem verifyPackageNameRowItem;
    IntegrationValidatorDialogRowItem verifyURISchemeRowItem;
    IntegrationValidatorDialogRowItem verifyAppLinksRowItem;
    IntegrationValidatorDialogRowItem verifyCustomDomainRowItem;
    IntegrationValidatorDialogRowItem domainIntentFiltersRowItem;
    IntegrationValidatorDialogRowItem alternateDomainIntentFiltersRowItem;
    Button exportLogsButton;
    Button testDeepLinkingButton;

    public IntegrationValidatorDialog(Context context) {
        super(context);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.dialog_integration_validator);
        TextView sdkVersionTextView = (TextView)this.findViewById(R.id.sdk_version);
        sdkVersionTextView.setText((CharSequence)("SDK Version: " + Branch.getSdkVersionNumber()));
        this.autoInstanceValidatorRowItem = (IntegrationValidatorDialogRowItem)this.findViewById(R.id.test_1_auto_instance_validator_row);
        this.verifyBranchKeysRowItem = (IntegrationValidatorDialogRowItem)this.findViewById(R.id.test_2_verify_branch_keys);
        this.verifyPackageNameRowItem = (IntegrationValidatorDialogRowItem)this.findViewById(R.id.test_3_verify_package_name);
        this.verifyURISchemeRowItem = (IntegrationValidatorDialogRowItem)this.findViewById(R.id.test_4_verify_uri_scheme);
        this.verifyAppLinksRowItem = (IntegrationValidatorDialogRowItem)this.findViewById(R.id.test_5_verify_app_links);
        this.verifyCustomDomainRowItem = (IntegrationValidatorDialogRowItem)this.findViewById(R.id.test_6_verify_custom_domain);
        this.domainIntentFiltersRowItem = (IntegrationValidatorDialogRowItem)this.findViewById(R.id.test_7_domain_intent_filters);
        this.alternateDomainIntentFiltersRowItem = (IntegrationValidatorDialogRowItem)this.findViewById(R.id.test_8_alternate_domain_intent_filters);
        this.exportLogsButton = (Button)this.findViewById(R.id.export_logs_button);
        this.testDeepLinkingButton = (Button)this.findViewById(R.id.test_deep_linking_button);
        this.exportLogsButton.setOnClickListener(view -> this.shareLogsAsText(context));
        this.testDeepLinkingButton.setOnClickListener(view -> LinkingValidator.validate(context));
    }

    public void SetTestResultForRowItem(int testNumber, String name, boolean didTestPass, String detailsMessage, String moreInfoLink) {
        switch (testNumber) {
            case 1: {
                this.setResult(this.autoInstanceValidatorRowItem, name, didTestPass, detailsMessage, moreInfoLink);
                break;
            }
            case 2: {
                this.setResult(this.verifyBranchKeysRowItem, name, didTestPass, detailsMessage, moreInfoLink);
                break;
            }
            case 3: {
                this.setResult(this.verifyPackageNameRowItem, name, didTestPass, detailsMessage, moreInfoLink);
                break;
            }
            case 4: {
                this.setResult(this.verifyURISchemeRowItem, name, didTestPass, detailsMessage, moreInfoLink);
                break;
            }
            case 5: {
                this.setResult(this.verifyAppLinksRowItem, name, didTestPass, detailsMessage, moreInfoLink);
                break;
            }
            case 6: {
                this.setResult(this.verifyCustomDomainRowItem, name, didTestPass, detailsMessage, moreInfoLink);
                break;
            }
            case 7: {
                this.setResult(this.domainIntentFiltersRowItem, name, didTestPass, detailsMessage, moreInfoLink);
                break;
            }
            case 8: {
                this.setResult(this.alternateDomainIntentFiltersRowItem, name, didTestPass, detailsMessage, moreInfoLink);
            }
        }
    }

    private void setResult(IntegrationValidatorDialogRowItem rowItem, String name, boolean didTestPass, String detailsMessage, String moreInfoLink) {
        rowItem.SetTitleText(name);
        rowItem.SetTestResult(didTestPass);
        rowItem.SetDetailsMessage(detailsMessage);
        rowItem.SetMoreInfoLink(moreInfoLink);
    }

    private void shareLogsAsText(Context context) {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.TEXT", IntegrationValidator.getLogs());
        sendIntent.setType("text/plain");
        Intent shareIntent = Intent.createChooser((Intent)sendIntent, null);
        context.startActivity(shareIntent);
    }
}

