/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.content.Context;
import android.text.TextUtils;
import io.branch.referral.validators.BranchIntegrationModel;
import io.branch.referral.validators.IntegrationValidatorCheck;
import org.json.JSONObject;

public class CustomDomainCheck
extends IntegrationValidatorCheck {
    String name = "Custom Domain";
    String errorMessage = "Could not find intent filter to support Branch default link domain. Please add intent filter for handling custom link domain in your Android Manifest file";
    String moreInfoLink = "<a href=\"https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app\">More info</a>";
    BranchIntegrationModel integrationModel;
    JSONObject branchAppConfig;

    public CustomDomainCheck(BranchIntegrationModel integrationModel, JSONObject branchAppConfig) {
        ((IntegrationValidatorCheck)this).name = this.name;
        ((IntegrationValidatorCheck)this).errorMessage = this.errorMessage;
        ((IntegrationValidatorCheck)this).moreInfoLink = this.moreInfoLink;
        this.integrationModel = integrationModel;
        this.branchAppConfig = branchAppConfig;
    }

    @Override
    public boolean RunTests(Context context) {
        String customDomain = this.branchAppConfig.optString("short_url_domain");
        return TextUtils.isEmpty((CharSequence)customDomain) || this.checkIfIntentAddedForLinkDomain(customDomain);
    }

    @Override
    public String GetOutput(Context context, boolean didTestSucceed) {
        didTestSucceed = this.RunTests(context);
        return super.GetOutput(context, didTestSucceed);
    }

    private boolean checkIfIntentAddedForLinkDomain(String domainName) {
        boolean foundIntentFilterMatchingDomainName = false;
        if (!TextUtils.isEmpty((CharSequence)domainName)) {
            for (String host : this.integrationModel.applinkScheme) {
                if (!domainName.equals(host)) continue;
                foundIntentFilterMatchingDomainName = true;
                break;
            }
        }
        return foundIntentFilterMatchingDomainName;
    }
}

