/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.DeviceInfo;
import io.branch.referral.ServerRequestInitSession;
import io.branch.referral.ServerResponse;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestRegisterOpen
extends ServerRequestInitSession {
    ServerRequestRegisterOpen(Context context, Branch.BranchReferralInitListener callback, boolean isAutoInitialization) {
        super(context, Defines.RequestPath.RegisterOpen, isAutoInitialization);
        this.callback_ = callback;
        JSONObject openPost = new JSONObject();
        try {
            openPost.put(Defines.Jsonkey.RandomizedDeviceToken.getKey(), (Object)this.prefHelper_.getRandomizedDeviceToken());
            openPost.put(Defines.Jsonkey.RandomizedBundleToken.getKey(), (Object)this.prefHelper_.getRandomizedBundleToken());
            this.setPost(openPost);
        }
        catch (JSONException ex) {
            BranchLogger.w("Caught JSONException " + ex.getMessage());
            this.constructError_ = true;
        }
    }

    ServerRequestRegisterOpen(Defines.RequestPath requestPath, JSONObject post, Context context, boolean isAutoInitialization) {
        super(requestPath, post, context, isAutoInitialization);
    }

    @Override
    public void onPreExecute() {
        super.onPreExecute();
        if (Branch.getInstance().isInstantDeepLinkPossible()) {
            if (this.callback_ != null) {
                this.callback_.onInitFinished(Branch.getInstance().getLatestReferringParams(), null);
            }
            Branch.getInstance().requestQueue_.addExtraInstrumentationData(Defines.Jsonkey.InstantDeepLinkSession.getKey(), "true");
            Branch.getInstance().setInstantDeepLinkPossible(false);
        }
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        super.onRequestSucceeded(resp, branch);
        BranchLogger.v("onRequestSucceeded " + this + " " + resp + " on callback " + this.callback_);
        try {
            if (resp.getObject().has(Defines.Jsonkey.LinkClickID.getKey())) {
                this.prefHelper_.setLinkClickID(resp.getObject().getString(Defines.Jsonkey.LinkClickID.getKey()));
            } else {
                this.prefHelper_.setLinkClickID("bnc_no_value");
            }
            if (resp.getObject().has(Defines.Jsonkey.Invoke_Features.getKey()) && resp.getObject().getJSONObject(Defines.Jsonkey.Invoke_Features.getKey()).has("enhanced_web_link_ux")) {
                JSONObject invokeFeaturesJson = resp.getObject().getJSONObject(Defines.Jsonkey.Invoke_Features.getKey());
                BranchLogger.v("Opening browser from open request.");
                branch.openBrowserExperience(invokeFeaturesJson);
            } else {
                if (resp.getObject().has(Defines.Jsonkey.Data.getKey())) {
                    String params = resp.getObject().getString(Defines.Jsonkey.Data.getKey());
                    this.prefHelper_.setSessionParams(params);
                } else {
                    this.prefHelper_.setSessionParams("bnc_no_value");
                }
                if (this.callback_ != null && !Branch.getInstance().isIDLSession()) {
                    this.callback_.onInitFinished(branch.getLatestReferringParams(), null);
                }
            }
            this.prefHelper_.setAppVersion(DeviceInfo.getInstance().getAppVersion());
        }
        catch (Exception ex) {
            BranchLogger.w("Caught Exception ServerRequestRegisterOpen onRequestSucceeded: " + ex.getMessage());
        }
        this.onInitSessionCompleted(resp, branch);
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null && !Branch.getInstance().isIDLSession()) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("error_message", (Object)"Trouble reaching server. Please try again in a few minutes");
            }
            catch (JSONException ex) {
                BranchLogger.w("Caught JSONException " + ex.getMessage());
            }
            this.callback_.onInitFinished(obj, new BranchError("Trouble initializing Branch. " + this + " failed. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null && !Branch.getInstance().isIDLSession()) {
                this.callback_.onInitFinished(null, new BranchError("Trouble initializing Branch.", -102));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        BranchLogger.v(this + " clearCallbacks " + this.callback_);
        this.callback_ = null;
    }

    @Override
    public String getRequestActionName() {
        return "open";
    }

    @Override
    public boolean shouldRetryOnFail() {
        return false;
    }
}

