/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.AppStoreReferrer;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.DeviceInfo;
import io.branch.referral.ServerRequestInitSession;
import io.branch.referral.ServerResponse;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestRegisterInstall
extends ServerRequestInitSession {
    ServerRequestRegisterInstall(Context context, Branch.BranchReferralInitListener callback, boolean isAutoInitialization) {
        super(context, Defines.RequestPath.RegisterInstall, isAutoInitialization);
        this.callback_ = callback;
        try {
            this.setPost(new JSONObject());
        }
        catch (JSONException ex) {
            BranchLogger.w("Caught JSONException " + ex.getMessage());
            this.constructError_ = true;
        }
    }

    ServerRequestRegisterInstall(Defines.RequestPath requestPath, JSONObject post, Context context, boolean isAutoInitialization) {
        super(requestPath, post, context, isAutoInitialization);
    }

    @Override
    public void onPreExecute() {
        super.onPreExecute();
        long clickedReferrerTS = this.prefHelper_.getLong("bnc_referrer_click_ts");
        long installBeginTS = this.prefHelper_.getLong("bnc_install_begin_ts");
        long clickedReferrerServerTS = this.prefHelper_.getLong("bnc_referrer_click_server_ts");
        long installReferrerServerTS = this.prefHelper_.getLong("bnc_install_begin_server_ts");
        try {
            if (clickedReferrerTS > 0L) {
                this.getPost().put(Defines.Jsonkey.ClickedReferrerTimeStamp.getKey(), clickedReferrerTS);
            }
            if (installBeginTS > 0L) {
                this.getPost().put(Defines.Jsonkey.InstallBeginTimeStamp.getKey(), installBeginTS);
            }
            if (!AppStoreReferrer.getInstallationID().equals("bnc_no_value")) {
                this.getPost().put(Defines.Jsonkey.LinkClickID.getKey(), (Object)AppStoreReferrer.getInstallationID());
            }
            if (clickedReferrerServerTS > 0L) {
                this.getPost().put(Defines.Jsonkey.ClickedReferrerServerTimeStamp.getKey(), clickedReferrerServerTS);
            }
            if (installReferrerServerTS > 0L) {
                this.getPost().put(Defines.Jsonkey.InstallBeginServerTimeStamp.getKey(), installReferrerServerTS);
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        super.onRequestSucceeded(resp, branch);
        try {
            JSONObject dataObj;
            this.prefHelper_.setUserURL(resp.getObject().getString(Defines.Jsonkey.Link.getKey()));
            if (resp.getObject().has(Defines.Jsonkey.Data.getKey()) && (dataObj = new JSONObject(resp.getObject().getString(Defines.Jsonkey.Data.getKey()))).has(Defines.Jsonkey.Clicked_Branch_Link.getKey()) && dataObj.getBoolean(Defines.Jsonkey.Clicked_Branch_Link.getKey()) && this.prefHelper_.getInstallParams().equals("bnc_no_value")) {
                String params = resp.getObject().getString(Defines.Jsonkey.Data.getKey());
                this.prefHelper_.setInstallParams(params);
            }
            if (resp.getObject().has(Defines.Jsonkey.LinkClickID.getKey())) {
                this.prefHelper_.setLinkClickID(resp.getObject().getString(Defines.Jsonkey.LinkClickID.getKey()));
            } else {
                this.prefHelper_.setLinkClickID("bnc_no_value");
            }
            if (resp.getObject().has(Defines.Jsonkey.Invoke_Features.getKey()) && resp.getObject().getJSONObject(Defines.Jsonkey.Invoke_Features.getKey()).has("enhanced_web_link_ux")) {
                JSONObject invokeFeaturesJson = resp.getObject().getJSONObject(Defines.Jsonkey.Invoke_Features.getKey());
                BranchLogger.v("Opening browser from install request.");
                branch.openBrowserExperience(invokeFeaturesJson);
            } else {
                if (resp.getObject().has(Defines.Jsonkey.Data.getKey())) {
                    String params = resp.getObject().getString(Defines.Jsonkey.Data.getKey());
                    this.prefHelper_.setSessionParams(params);
                } else {
                    this.prefHelper_.setSessionParams("bnc_no_value");
                }
                if (this.callback_ != null) {
                    this.callback_.onInitFinished(branch.getLatestReferringParams(), null);
                }
            }
            this.prefHelper_.setAppVersion(DeviceInfo.getInstance().getAppVersion());
        }
        catch (Exception ex) {
            BranchLogger.w("Caught Exception ServerRequestRegisterInstall onRequestSucceeded: " + ex.getMessage());
        }
        this.onInitSessionCompleted(resp, branch);
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("error_message", (Object)"Trouble reaching server. Please try again in a few minutes");
            }
            catch (JSONException ex) {
                BranchLogger.w("Caught JSONException " + ex.getMessage());
            }
            this.callback_.onInitFinished(obj, new BranchError("Trouble initializing Branch. " + this + " failed. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onInitFinished(null, new BranchError("Trouble initializing Branch.", -102));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        BranchLogger.v(this + " clearCallbacks");
        this.callback_ = null;
    }

    @Override
    public String getRequestActionName() {
        return "install";
    }

    @Override
    public boolean shouldRetryOnFail() {
        return false;
    }
}

