/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.text.TextUtils;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.DeviceInfo;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import io.branch.referral.validators.DeepLinkRoutingValidator;
import org.json.JSONException;
import org.json.JSONObject;

abstract class ServerRequestInitSession
extends ServerRequest {
    static final String ACTION_OPEN = "open";
    static final String ACTION_INSTALL = "install";
    private final Context context_;
    private static final int STATE_FRESH_INSTALL = 0;
    private static final int STATE_NO_CHANGE = 1;
    private static final int STATE_UPDATE = 2;
    static final String INITIATED_BY_CLIENT = "INITIATED_BY_CLIENT";
    Branch.BranchReferralInitListener callback_;
    boolean initiatedByClient;

    ServerRequestInitSession(Context context, Defines.RequestPath requestPath, boolean isAutoInitialization) {
        super(context, requestPath);
        this.context_ = context;
        this.initiatedByClient = !isAutoInitialization;
    }

    ServerRequestInitSession(Defines.RequestPath requestPath, JSONObject post, Context context, boolean isAutoInitialization) {
        super(requestPath, post, context);
        this.context_ = context;
        this.initiatedByClient = !isAutoInitialization;
    }

    @Override
    protected void setPost(JSONObject post) throws JSONException {
        super.setPost(post);
        this.prefHelper_.loadPartnerParams(post);
        String appVersion = DeviceInfo.getInstance().getAppVersion();
        if (!DeviceInfo.isNullOrEmptyOrBlank(appVersion)) {
            post.put(Defines.Jsonkey.AppVersion.getKey(), (Object)appVersion);
        }
        this.updateInstallStateAndTimestamps(post);
        this.updateEnvironment(this.context_, post);
        String identity = Branch.installDeveloperId;
        if (!TextUtils.isEmpty((CharSequence)identity) && !identity.equals("bnc_no_value")) {
            post.put(Defines.Jsonkey.Identity.getKey(), (Object)identity);
        }
    }

    @Override
    protected boolean shouldUpdateLimitFacebookTracking() {
        return true;
    }

    @Override
    protected boolean shouldAddDMAParams() {
        return true;
    }

    public abstract String getRequestActionName();

    static boolean isInitSessionAction(String actionName) {
        boolean isInitSessionAction = false;
        if (actionName != null) {
            isInitSessionAction = actionName.equalsIgnoreCase(ACTION_OPEN) || actionName.equalsIgnoreCase(ACTION_INSTALL);
        }
        return isInitSessionAction;
    }

    @Override
    public void onRequestSucceeded(ServerResponse response, Branch branch) {
        Branch.getInstance().unlockSDKInitWaitLock();
    }

    void onInitSessionCompleted(ServerResponse response, Branch branch) {
        DeepLinkRoutingValidator.validate(branch.currentActivityReference_);
        branch.updateSkipURLFormats();
        BranchLogger.v("onInitSessionCompleted on thread " + Thread.currentThread().getName());
    }

    void updateLinkReferrerParams() {
        String appStore;
        String googlePlayReferrer;
        String googleSearchInstallIdentifier;
        String linkIdentifier = this.prefHelper_.getLinkClickIdentifier();
        if (!linkIdentifier.equals("bnc_no_value")) {
            try {
                this.getPost().put(Defines.Jsonkey.LinkIdentifier.getKey(), (Object)linkIdentifier);
            }
            catch (JSONException e) {
                BranchLogger.w("Caught JSONException " + e.getMessage());
            }
        }
        if (!(googleSearchInstallIdentifier = this.prefHelper_.getGoogleSearchInstallIdentifier()).equals("bnc_no_value")) {
            try {
                this.getPost().put(Defines.Jsonkey.GoogleSearchInstallReferrer.getKey(), (Object)googleSearchInstallIdentifier);
            }
            catch (JSONException e) {
                BranchLogger.w("Caught JSONException " + e.getMessage());
            }
        }
        if (!(googlePlayReferrer = this.prefHelper_.getAppStoreReferrer()).equals("bnc_no_value")) {
            try {
                this.getPost().put(Defines.Jsonkey.GooglePlayInstallReferrer.getKey(), (Object)googlePlayReferrer);
            }
            catch (JSONException e) {
                BranchLogger.w("Caught JSONException " + e.getMessage());
            }
        }
        if (!"bnc_no_value".equals(appStore = this.prefHelper_.getAppStoreSource())) {
            try {
                if (appStore.equals(Defines.Jsonkey.Meta_Install_Referrer.getKey())) {
                    this.getPost().put(Defines.Jsonkey.App_Store.getKey(), (Object)Defines.Jsonkey.Google_Play_Store.getKey());
                    this.getPost().put(Defines.Jsonkey.Is_Meta_Click_Through.getKey(), this.prefHelper_.getIsMetaClickThrough());
                } else {
                    this.getPost().put(Defines.Jsonkey.App_Store.getKey(), (Object)appStore);
                }
            }
            catch (JSONException e) {
                BranchLogger.w("Caught JSONException " + e.getMessage());
            }
        }
        if (this.prefHelper_.isFullAppConversion()) {
            try {
                this.getPost().put(Defines.Jsonkey.AndroidAppLinkURL.getKey(), (Object)this.prefHelper_.getAppLink());
                this.getPost().put(Defines.Jsonkey.IsFullAppConv.getKey(), true);
            }
            catch (JSONException e) {
                BranchLogger.w("Caught JSONException " + e.getMessage());
            }
        }
    }

    @Override
    public void onPreExecute() {
        super.onPreExecute();
        JSONObject post = this.getPost();
        try {
            String initialReferrer;
            String externalIntentExtra;
            String externalIntentUri;
            String pushIdentifier;
            String appLink = this.prefHelper_.getAppLink();
            if (!appLink.equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.AndroidAppLinkURL.getKey(), (Object)appLink);
            }
            if (!(pushIdentifier = this.prefHelper_.getPushIdentifier()).equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.AndroidPushIdentifier.getKey(), (Object)pushIdentifier);
            }
            if (!(externalIntentUri = this.prefHelper_.getExternalIntentUri()).equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.External_Intent_URI.getKey(), (Object)externalIntentUri);
            }
            if (!(externalIntentExtra = this.prefHelper_.getExternalIntentExtra()).equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.External_Intent_Extra.getKey(), (Object)externalIntentExtra);
            }
            if (!TextUtils.isEmpty((CharSequence)(initialReferrer = this.prefHelper_.getInitialReferrer())) && !initialReferrer.equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.InitialReferrer.getKey(), (Object)initialReferrer);
            }
            String lastUsedWebLinkType = this.prefHelper_.getWebLinkUxTypeUsed();
            long lastWebLinkLoadTs = this.prefHelper_.getWebLinkLoadTime();
            if (!TextUtils.isEmpty((CharSequence)lastUsedWebLinkType) && !"bnc_no_value".equals(lastUsedWebLinkType)) {
                JSONObject web_link_context = new JSONObject();
                web_link_context.put(Defines.Jsonkey.UX_Type.getKey(), (Object)lastUsedWebLinkType);
                web_link_context.put(Defines.Jsonkey.URL_Load_MS.getKey(), lastWebLinkLoadTs);
                post.put(Defines.Jsonkey.Web_Link_Context.getKey(), (Object)web_link_context);
                this.prefHelper_.setWebLinkUxTypeUsed(null);
                this.prefHelper_.setWebLinkLoadTime(0L);
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
        Branch.expectDelayedSessionInitialization(false);
    }

    private void updateInstallStateAndTimestamps(JSONObject post) throws JSONException {
        int installOrUpdateState = 1;
        String currAppVersion = DeviceInfo.getInstance().getAppVersion();
        long updateBufferTime = 86400000L;
        long firstInstallTime = DeviceInfo.getInstance().getFirstInstallTime();
        long lastUpdateTime = DeviceInfo.getInstance().getLastUpdateTime();
        if ("bnc_no_value".equals(this.prefHelper_.getAppVersion())) {
            installOrUpdateState = 0;
            if (lastUpdateTime - firstInstallTime >= updateBufferTime) {
                installOrUpdateState = 2;
            }
        } else if (!this.prefHelper_.getAppVersion().equals(currAppVersion)) {
            installOrUpdateState = 2;
        }
        post.put(Defines.Jsonkey.Update.getKey(), installOrUpdateState);
        post.put(Defines.Jsonkey.FirstInstallTime.getKey(), firstInstallTime);
        post.put(Defines.Jsonkey.LastUpdateTime.getKey(), lastUpdateTime);
        long originalInstallTime = this.prefHelper_.getLong("bnc_original_install_time");
        if (originalInstallTime == 0L) {
            originalInstallTime = firstInstallTime;
            this.prefHelper_.setLong("bnc_original_install_time", firstInstallTime);
        }
        post.put(Defines.Jsonkey.OriginalInstallTime.getKey(), originalInstallTime);
        long lastKnownUpdateTime = this.prefHelper_.getLong("bnc_last_known_update_time");
        if (lastKnownUpdateTime < lastUpdateTime) {
            this.prefHelper_.setLong("bnc_previous_update_time", lastKnownUpdateTime);
            this.prefHelper_.setLong("bnc_last_known_update_time", lastUpdateTime);
        }
        post.put(Defines.Jsonkey.PreviousUpdateTime.getKey(), this.prefHelper_.getLong("bnc_previous_update_time"));
    }

    @Override
    protected boolean prepareExecuteWithoutTracking() {
        JSONObject post = this.getPost();
        if (post.has(Defines.Jsonkey.AndroidAppLinkURL.getKey()) || post.has(Defines.Jsonkey.AndroidPushIdentifier.getKey()) || post.has(Defines.Jsonkey.LinkIdentifier.getKey())) {
            post.remove(Defines.Jsonkey.RandomizedDeviceToken.getKey());
            post.remove(Defines.Jsonkey.RandomizedBundleToken.getKey());
            post.remove(Defines.Jsonkey.External_Intent_Extra.getKey());
            post.remove(Defines.Jsonkey.External_Intent_URI.getKey());
            post.remove(Defines.Jsonkey.FirstInstallTime.getKey());
            post.remove(Defines.Jsonkey.LastUpdateTime.getKey());
            post.remove(Defines.Jsonkey.OriginalInstallTime.getKey());
            post.remove(Defines.Jsonkey.PreviousUpdateTime.getKey());
            post.remove(Defines.Jsonkey.InstallBeginTimeStamp.getKey());
            post.remove(Defines.Jsonkey.ClickedReferrerTimeStamp.getKey());
            post.remove(Defines.Jsonkey.HardwareID.getKey());
            post.remove(Defines.Jsonkey.IsHardwareIDReal.getKey());
            post.remove(Defines.Jsonkey.LocalIP.getKey());
            post.remove(Defines.Jsonkey.ReferrerGclid.getKey());
            post.remove(Defines.Jsonkey.Identity.getKey());
            post.remove(Defines.Jsonkey.AnonID.getKey());
            try {
                post.put(Defines.Jsonkey.TrackingDisabled.getKey(), true);
            }
            catch (JSONException e) {
                BranchLogger.w("Caught JSONException " + e.getMessage());
            }
            return true;
        }
        return super.prepareExecuteWithoutTracking();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject r = super.toJSON();
        try {
            r.put(INITIATED_BY_CLIENT, this.initiatedByClient);
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
        return r;
    }
}

