/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.BranchPartnerParameters;
import io.branch.referral.BranchUtil;
import io.branch.referral.Defines;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class PrefHelper {
    private static final String TAG = "BranchSDK";
    static final String BRANCH_BASE_URL_V2 = "https://api2.branch.io/";
    static final String BRANCH_BASE_URL_V1 = "https://api.branch.io/";
    static final String BRANCH_EU_BASE_URL_V3 = "https://api3-eu.branch.io/";
    static final String BRANCH_CDN_BASE_URL = "https://cdn.branch.io/";
    public static final String NO_STRING_VALUE = "bnc_no_value";
    private static final int INTERVAL_RETRY = 1000;
    private static final int MAX_RETRIES = 3;
    static final int TIMEOUT = 5500;
    static final int CONNECT_TIMEOUT = 10000;
    static final int TASK_TIMEOUT = 15500;
    static final long DEFAULT_VALID_WINDOW_FOR_REFERRER_GCLID = 2592000000L;
    static final long MAX_VALID_WINDOW_FOR_REFERRER_GCLID = 100000000000L;
    static final long MIN_VALID_WINDOW_FOR_REFERRER_GCLID = 0L;
    static final int DEFAULT_NO_CONNECTION_RETRY_MAX = 3;
    private static final String SHARED_PREF_FILE = "branch_referral_shared_pref";
    private static final String KEY_BRANCH_KEY = "bnc_branch_key";
    private static final String KEY_APP_VERSION = "bnc_app_version";
    private static final String KEY_DEVICE_FINGERPRINT_ID = "bnc_device_fingerprint_id";
    private static final String KEY_RANDOMIZED_DEVICE_TOKEN = "bnc_randomized_device_token";
    private static final String KEY_SESSION_ID = "bnc_session_id";
    private static final String KEY_IDENTITY_ID = "bnc_identity_id";
    private static final String KEY_RANDOMIZED_BUNDLE_TOKEN = "bnc_randomized_bundle_token";
    private static final String KEY_IDENTITY = "bnc_identity";
    private static final String KEY_LINK_CLICK_ID = "bnc_link_click_id";
    private static final String KEY_LINK_CLICK_IDENTIFIER = "bnc_link_click_identifier";
    private static final String KEY_GOOGLE_SEARCH_INSTALL_IDENTIFIER = "bnc_google_search_install_identifier";
    private static final String KEY_GOOGLE_PLAY_INSTALL_REFERRER_EXTRA = "bnc_google_play_install_referrer_extras";
    private static final String KEY_APP_STORE_SOURCE = "bnc_app_store_source";
    private static final String KEY_GCLID_JSON_OBJECT = "bnc_gclid_json_object";
    private static final String KEY_GCLID_VALUE = "bnc_gclid_value";
    private static final String KEY_GCLID_EXPIRATION_DATE = "bnc_gclid_expiration_date";
    private static final String KEY_GCLID_VALID_FOR_WINDOW = "bnc_gclid_expiration_window";
    private static final String KEY_APP_LINK = "bnc_app_link";
    private static final String KEY_PUSH_IDENTIFIER = "bnc_push_identifier";
    private static final String KEY_SESSION_PARAMS = "bnc_session_params";
    private static final String KEY_INSTALL_PARAMS = "bnc_install_params";
    private static final String KEY_USER_URL = "bnc_user_url";
    private static final String KEY_LATD_ATTRIBUTION_WINDOW = "bnc_latd_attributon_window";
    private static final String KEY_INITIAL_REFERRER = "bnc_initial_referrer";
    private static final String KEY_ACTIONS = "bnc_actions";
    private static final String KEY_TOTAL_BASE = "bnc_total_base_";
    private static final String KEY_UNIQUE_BASE = "bnc_balance_base_";
    private static final String KEY_RETRY_COUNT = "bnc_retry_count";
    private static final String KEY_RETRY_INTERVAL = "bnc_retry_interval";
    private static final String KEY_TIMEOUT = "bnc_timeout";
    private static final String KEY_TASK_TIMEOUT = "bnc_task_timeout";
    private static final String KEY_CONNECT_TIMEOUT = "bnc_connect_timeout";
    private static final String KEY_NO_CONNECTION_RETRY_MAX = "bnc_no_connection_retry_max";
    private static final String KEY_LAST_READ_SYSTEM = "bnc_system_read_date";
    private static final String KEY_EXTERNAL_INTENT_URI = "bnc_external_intent_uri";
    private static final String KEY_EXTERNAL_INTENT_EXTRA = "bnc_external_intent_extra";
    private static final String KEY_BRANCH_VIEW_NUM_OF_USE = "bnc_branch_view_use";
    private static final String KEY_INSTALL_REFERRER = "bnc_install_referrer";
    private static final String KEY_IS_FULL_APP_CONVERSION = "bnc_is_full_app_conversion";
    private static final String KEY_LIMIT_FACEBOOK_TRACKING = "bnc_limit_facebook_tracking";
    private static final String KEY_DMA_EEA = "bnc_dma_eea";
    private static final String KEY_DMA_AD_PERSONALIZATION = "bnc_dma_ad_personalization";
    private static final String KEY_DMA_AD_USER_DATA = "bnc_dma_ad_user_data";
    private static final String KEY_LOG_IAP_AS_EVENTS = "bnc_log_iap_as_events";
    private static final String KEY_CONSUMER_PROTECTION_ATTRIBUTION_LEVEL = "bnc_consumer_protection_attribution_level";
    static final String KEY_ORIGINAL_INSTALL_TIME = "bnc_original_install_time";
    static final String KEY_LAST_KNOWN_UPDATE_TIME = "bnc_last_known_update_time";
    static final String KEY_PREVIOUS_UPDATE_TIME = "bnc_previous_update_time";
    static final String KEY_REFERRER_CLICK_TS = "bnc_referrer_click_ts";
    static final String KEY_REFERRER_CLICK_SERVER_TS = "bnc_referrer_click_server_ts";
    static final String KEY_INSTALL_BEGIN_TS = "bnc_install_begin_ts";
    static final String KEY_INSTALL_BEGIN_SERVER_TS = "bnc_install_begin_server_ts";
    static final String KEY_TRACKING_STATE = "bnc_tracking_state";
    static final String KEY_AD_NETWORK_CALLOUTS_DISABLED = "bnc_ad_network_callouts_disabled";
    static final String KEY_RANDOMLY_GENERATED_UUID = "bnc_randomly_generated_uuid";
    static final String KEY_REFERRING_URL_QUERY_PARAMETERS = "bnc_referringUrlQueryParameters";
    static final String KEY_ANON_ID = "bnc_anon_id";
    static final String KEY_IS_META_CLICKTHROUGH = "bnc_is_meta_clickthrough";
    static final String KEY_ENHANCED_WEB_LINK_UX_USED = "bnc_enhanced_web_link_ux_used";
    static final String KEY_URL_LOAD_MS = "bnc_url_load_ms";
    private static PrefHelper prefHelper_;
    private final SharedPreferences appSharedPrefs_;
    private SharedPreferences.Editor prefsEditor_;
    private final JSONObject requestMetadata = new JSONObject();
    private final JSONObject installMetadata = new JSONObject();
    private final JSONObject secondaryRequestMetadata = new JSONObject();
    private static String customServerURL_;
    private static String customCDNBaseURL_;
    final BranchPartnerParameters partnerParams_ = new BranchPartnerParameters();
    private static boolean enableLogging_;
    private static boolean useEUEndpoint_;
    public static String fbAppId_;

    private PrefHelper(Context context) {
        this.appSharedPrefs_ = context.getSharedPreferences(SHARED_PREF_FILE, 0);
        this.prefsEditor_ = this.appSharedPrefs_.edit();
    }

    public static PrefHelper getInstance(Context context) {
        if (prefHelper_ == null) {
            prefHelper_ = new PrefHelper(context);
        }
        return prefHelper_;
    }

    static void shutDown() {
        if (prefHelper_ != null) {
            PrefHelper.prefHelper_.prefsEditor_ = null;
        }
        enableLogging_ = false;
        prefHelper_ = null;
        customCDNBaseURL_ = null;
        customServerURL_ = null;
        useEUEndpoint_ = false;
    }

    static void setAPIUrl(String url) {
        customServerURL_ = url;
    }

    public String getAPIBaseUrl() {
        if (URLUtil.isHttpsUrl((String)customServerURL_)) {
            return customServerURL_;
        }
        if (useEUEndpoint_) {
            return BRANCH_EU_BASE_URL_V3;
        }
        if (Build.VERSION.SDK_INT >= 20) {
            return BRANCH_BASE_URL_V2;
        }
        return BRANCH_BASE_URL_V1;
    }

    static void setCDNBaseUrl(String url) {
        customCDNBaseURL_ = url;
    }

    static String getCDNBaseUrl() {
        if (!TextUtils.isEmpty((CharSequence)customCDNBaseURL_)) {
            return customCDNBaseURL_;
        }
        return BRANCH_CDN_BASE_URL;
    }

    public void setTimeout(int timeout) {
        this.setInteger(KEY_TIMEOUT, timeout);
    }

    public int getTimeout() {
        return this.getInteger(KEY_TIMEOUT, 5500);
    }

    public int getTaskTimeout() {
        return this.getInteger(KEY_TIMEOUT, 5500) + this.getInteger(KEY_CONNECT_TIMEOUT, 10000);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.setInteger(KEY_CONNECT_TIMEOUT, connectTimeout);
    }

    public int getConnectTimeout() {
        return this.getInteger(KEY_CONNECT_TIMEOUT, 10000);
    }

    public void setRetryCount(int retry) {
        this.setInteger(KEY_RETRY_COUNT, retry);
    }

    public int getRetryCount() {
        return this.getInteger(KEY_RETRY_COUNT, 3);
    }

    public void setRetryInterval(int retryInt) {
        this.setInteger(KEY_RETRY_INTERVAL, retryInt);
    }

    public int getRetryInterval() {
        return this.getInteger(KEY_RETRY_INTERVAL, 1000);
    }

    public void setNoConnectionRetryMax(int retryInt) {
        this.setInteger(KEY_NO_CONNECTION_RETRY_MAX, retryInt);
    }

    public int getNoConnectionRetryMax() {
        return this.getInteger(KEY_NO_CONNECTION_RETRY_MAX, 3);
    }

    public void setAppVersion(String version) {
        this.setString(KEY_APP_VERSION, version);
    }

    public String getAppVersion() {
        return this.getString(KEY_APP_VERSION);
    }

    public boolean setBranchKey(String key) {
        String currentBranchKey = this.getString(KEY_BRANCH_KEY);
        if (!currentBranchKey.equals(key)) {
            this.clearPrefOnBranchKeyChange();
            this.setString(KEY_BRANCH_KEY, key);
            if (Branch.getInstance() != null) {
                Branch.getInstance().linkCache_.clear();
                Branch.getInstance().requestQueue_.clear();
            }
            return true;
        }
        return false;
    }

    public String getBranchKey() {
        return this.getString(KEY_BRANCH_KEY);
    }

    public void setRandomizedDeviceToken(String randomized_device_token) {
        this.setString(KEY_RANDOMIZED_DEVICE_TOKEN, randomized_device_token);
    }

    public String getRandomizedDeviceToken() {
        String rdt = this.getString(KEY_RANDOMIZED_DEVICE_TOKEN);
        if (!TextUtils.isEmpty((CharSequence)rdt) && !rdt.equals(NO_STRING_VALUE)) {
            return rdt;
        }
        return this.getString(KEY_DEVICE_FINGERPRINT_ID);
    }

    public void setSessionID(String session_id) {
        this.setString(KEY_SESSION_ID, session_id);
    }

    public String getSessionID() {
        return this.getString(KEY_SESSION_ID);
    }

    public void setRandomizedBundleToken(String randomized_bundle_token) {
        this.setString(KEY_RANDOMIZED_BUNDLE_TOKEN, randomized_bundle_token);
    }

    public String getRandomizedBundleToken() {
        String rbt = this.getString(KEY_RANDOMIZED_BUNDLE_TOKEN);
        if (!TextUtils.isEmpty((CharSequence)rbt) && !rbt.equals(NO_STRING_VALUE)) {
            return rbt;
        }
        return this.getString(KEY_IDENTITY_ID);
    }

    public void setIdentity(String identity) {
        this.setString(KEY_IDENTITY, identity);
    }

    public String getIdentity() {
        return this.getString(KEY_IDENTITY);
    }

    public void setLinkClickID(String link_click_id) {
        this.setString(KEY_LINK_CLICK_ID, link_click_id);
    }

    public void setRandomlyGeneratedUuid(String uuid) {
        this.setString(KEY_RANDOMLY_GENERATED_UUID, uuid);
    }

    public String getRandomlyGeneratedUuid() {
        return this.getString(KEY_RANDOMLY_GENERATED_UUID);
    }

    public void setAnonID(String uuid) {
        this.setString(KEY_ANON_ID, uuid);
    }

    public String getAnonID() {
        return this.getString(KEY_ANON_ID);
    }

    public String getLinkClickID() {
        return this.getString(KEY_LINK_CLICK_ID);
    }

    public void setAdNetworkCalloutsDisabled(boolean disabled) {
        this.setBool(KEY_AD_NETWORK_CALLOUTS_DISABLED, disabled);
    }

    public boolean getAdNetworkCalloutsDisabled() {
        return this.getBool(KEY_AD_NETWORK_CALLOUTS_DISABLED);
    }

    public void setExternalIntentUri(String uri) {
        this.setString(KEY_EXTERNAL_INTENT_URI, uri);
    }

    public String getExternalIntentUri() {
        return this.getString(KEY_EXTERNAL_INTENT_URI);
    }

    public void setExternalIntentExtra(String extras) {
        this.setString(KEY_EXTERNAL_INTENT_EXTRA, extras);
    }

    public String getExternalIntentExtra() {
        return this.getString(KEY_EXTERNAL_INTENT_EXTRA);
    }

    public void setLinkClickIdentifier(String identifier) {
        this.setString(KEY_LINK_CLICK_IDENTIFIER, identifier);
    }

    public String getLinkClickIdentifier() {
        return this.getString(KEY_LINK_CLICK_IDENTIFIER);
    }

    public void setGoogleSearchInstallIdentifier(String identifier) {
        this.setString(KEY_GOOGLE_SEARCH_INSTALL_IDENTIFIER, identifier);
    }

    public String getGoogleSearchInstallIdentifier() {
        return this.getString(KEY_GOOGLE_SEARCH_INSTALL_IDENTIFIER);
    }

    public void setAppStoreReferrer(String referrer) {
        this.setString(KEY_GOOGLE_PLAY_INSTALL_REFERRER_EXTRA, referrer);
    }

    public String getAppStoreReferrer() {
        return this.getString(KEY_GOOGLE_PLAY_INSTALL_REFERRER_EXTRA);
    }

    public void setAppStoreSource(String store) {
        if (!TextUtils.isEmpty((CharSequence)store)) {
            this.setString(KEY_APP_STORE_SOURCE, store);
        }
    }

    public String getAppStoreSource() {
        return this.getString(KEY_APP_STORE_SOURCE);
    }

    public void setIsMetaClickThrough(boolean isMetaClickThrough) {
        this.setBool(KEY_IS_META_CLICKTHROUGH, isMetaClickThrough);
    }

    public boolean getIsMetaClickThrough() {
        return this.getBool(KEY_IS_META_CLICKTHROUGH);
    }

    public void setReferringUrlQueryParameters(JSONObject referringUrlQueryParameters) {
        if (referringUrlQueryParameters == null || referringUrlQueryParameters.length() == 0) {
            this.setString(KEY_REFERRING_URL_QUERY_PARAMETERS, NO_STRING_VALUE);
        } else {
            this.setString(KEY_REFERRING_URL_QUERY_PARAMETERS, referringUrlQueryParameters.toString());
        }
    }

    public JSONObject getReferringURLQueryParameters() {
        String string = this.getString(KEY_REFERRING_URL_QUERY_PARAMETERS);
        JSONObject params = new JSONObject();
        if (!TextUtils.isEmpty((CharSequence)string) && !NO_STRING_VALUE.equals(string)) {
            try {
                params = new JSONObject(string);
            }
            catch (JSONException e) {
                BranchLogger.w("Unable to get URL query parameters as string: " + (Object)((Object)e));
            }
        }
        return params;
    }

    public void setReferrerGclid(String referrerGclid) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(KEY_GCLID_VALUE, (Object)referrerGclid);
            jsonObject.put(KEY_GCLID_EXPIRATION_DATE, System.currentTimeMillis() + this.getReferrerGclidValidForWindow());
            this.setString(KEY_GCLID_JSON_OBJECT, jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getReferrerGclid() {
        String gclidObjectString = this.getString(KEY_GCLID_JSON_OBJECT);
        if (gclidObjectString.equals(NO_STRING_VALUE)) {
            return NO_STRING_VALUE;
        }
        String gclid = null;
        try {
            JSONObject gclidJsonObject = new JSONObject(gclidObjectString);
            long expiryDate = (Long)gclidJsonObject.get(KEY_GCLID_EXPIRATION_DATE);
            if (expiryDate - System.currentTimeMillis() > 0L) {
                gclid = gclidJsonObject.getString(KEY_GCLID_VALUE);
            } else {
                this.removePrefValue(KEY_GCLID_JSON_OBJECT);
            }
        }
        catch (JSONException e) {
            this.removePrefValue(KEY_GCLID_JSON_OBJECT);
            e.printStackTrace();
        }
        return gclid;
    }

    public void clearGclid() {
        this.removePrefValue(KEY_GCLID_JSON_OBJECT);
    }

    public void setReferrerGclidValidForWindow(long window) {
        if (100000000000L > window && window >= 0L) {
            this.setLong(KEY_GCLID_VALID_FOR_WINDOW, window);
        }
    }

    public long getReferrerGclidValidForWindow() {
        return this.getLong(KEY_GCLID_VALID_FOR_WINDOW, 2592000000L);
    }

    public void setAppLink(String appLinkUrl) {
        this.setString(KEY_APP_LINK, appLinkUrl);
    }

    public String getAppLink() {
        return this.getString(KEY_APP_LINK);
    }

    public void setIsFullAppConversion(boolean isFullAppConversion) {
        this.setBool(KEY_IS_FULL_APP_CONVERSION, isFullAppConversion);
    }

    public boolean isFullAppConversion() {
        return this.getBool(KEY_IS_FULL_APP_CONVERSION);
    }

    public void setPushIdentifier(String pushIdentifier) {
        this.setString(KEY_PUSH_IDENTIFIER, pushIdentifier);
    }

    public String getPushIdentifier() {
        return this.getString(KEY_PUSH_IDENTIFIER);
    }

    public String getSessionParams() {
        return this.getString(KEY_SESSION_PARAMS);
    }

    public void setSessionParams(String params) {
        this.setString(KEY_SESSION_PARAMS, params);
    }

    public String getInstallParams() {
        return this.getString(KEY_INSTALL_PARAMS);
    }

    public void setInstallParams(String params) {
        this.setString(KEY_INSTALL_PARAMS, params);
    }

    public void setInstallReferrerParams(String params) {
        this.setString(KEY_INSTALL_REFERRER, params);
    }

    public String getInstallReferrerParams() {
        return this.getString(KEY_INSTALL_REFERRER);
    }

    public void setUserURL(String user_url) {
        this.setString(KEY_USER_URL, user_url);
    }

    public String getUserURL() {
        return this.getString(KEY_USER_URL);
    }

    public void clearSystemReadStatus() {
        Calendar c = Calendar.getInstance();
        this.setLong(KEY_LAST_READ_SYSTEM, c.getTimeInMillis() / 1000L);
    }

    void setLimitFacebookTracking(boolean isLimitFBAppTracking) {
        this.setBool(KEY_LIMIT_FACEBOOK_TRACKING, isLimitFBAppTracking);
    }

    boolean isAppTrackingLimited() {
        return this.getBool(KEY_LIMIT_FACEBOOK_TRACKING);
    }

    boolean isDMAParamsInitialized() {
        return this.hasPrefValue(KEY_DMA_EEA);
    }

    void setEEARegion(boolean isEEARegion) {
        this.setBool(KEY_DMA_EEA, isEEARegion);
    }

    boolean getEEARegion() {
        return this.getBool(KEY_DMA_EEA);
    }

    void setAdPersonalizationConsent(boolean hasAdPersonalizationConsent) {
        this.setBool(KEY_DMA_AD_PERSONALIZATION, hasAdPersonalizationConsent);
    }

    boolean getAdPersonalizationConsent() {
        return this.getBool(KEY_DMA_AD_PERSONALIZATION);
    }

    void setAdUserDataUsageConsent(boolean hasAdUserDataUsageConsent) {
        this.setBool(KEY_DMA_AD_USER_DATA, hasAdUserDataUsageConsent);
    }

    boolean getAdUserDataUsageConsent() {
        return this.getBool(KEY_DMA_AD_USER_DATA);
    }

    public void clearUserValues() {
        ArrayList<String> actions = this.getActions();
        for (String action : actions) {
            this.setActionTotalCount(action, 0);
            this.setActionUniqueCount(action, 0);
        }
        this.setActions(new ArrayList<String>());
    }

    private ArrayList<String> getActions() {
        String actionList = this.getString(KEY_ACTIONS);
        if (actionList.equals(NO_STRING_VALUE)) {
            return new ArrayList<String>();
        }
        return this.deserializeString(actionList);
    }

    private void setActions(ArrayList<String> actions) {
        if (actions.size() == 0) {
            this.setString(KEY_ACTIONS, NO_STRING_VALUE);
        } else {
            this.setString(KEY_ACTIONS, this.serializeArrayList(actions));
        }
    }

    public void setActionTotalCount(String action, int count) {
        ArrayList<String> actions = this.getActions();
        if (!actions.contains(action)) {
            actions.add(action);
            this.setActions(actions);
        }
        this.setInteger(KEY_TOTAL_BASE + action, count);
    }

    public void setActionUniqueCount(String action, int count) {
        this.setInteger(KEY_UNIQUE_BASE + action, count);
    }

    public int getActionTotalCount(String action) {
        return this.getInteger(KEY_TOTAL_BASE + action);
    }

    public int getActionUniqueCount(String action) {
        return this.getInteger(KEY_UNIQUE_BASE + action);
    }

    public void setLATDAttributionWindow(int attributionWindow) {
        this.setInteger(KEY_LATD_ATTRIBUTION_WINDOW, attributionWindow);
    }

    public int getLATDAttributionWindow() {
        return this.getInteger(KEY_LATD_ATTRIBUTION_WINDOW, -1);
    }

    public void setInitialReferrer(String initialReferrer) {
        BranchLogger.v("setInitialReferrer " + initialReferrer);
        this.setString(KEY_INITIAL_REFERRER, initialReferrer);
    }

    public String getInitialReferrer() {
        String initialReferrer = this.getString(KEY_INITIAL_REFERRER);
        BranchLogger.v("getInitialReferrer " + initialReferrer);
        return initialReferrer;
    }

    private String serializeArrayList(ArrayList<String> strings) {
        String retString = "";
        for (String value : strings) {
            retString = retString + value + ",";
        }
        retString = retString.substring(0, retString.length() - 1);
        return retString;
    }

    private ArrayList<String> deserializeString(String list) {
        ArrayList<String> strings = new ArrayList<String>();
        String[] stringArr = list.split(",");
        Collections.addAll(strings, stringArr);
        return strings;
    }

    public boolean hasPrefValue(String key) {
        return this.appSharedPrefs_.contains(key);
    }

    public void removePrefValue(String key) {
        this.prefsEditor_.remove(key).apply();
    }

    public int getInteger(String key) {
        return this.getInteger(key, 0);
    }

    public int getInteger(String key, int defaultValue) {
        return this.appSharedPrefs_.getInt(key, defaultValue);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        return this.appSharedPrefs_.getLong(key, defaultValue);
    }

    public float getFloat(String key) {
        return this.appSharedPrefs_.getFloat(key, 0.0f);
    }

    public String getString(String key) {
        return this.appSharedPrefs_.getString(key, NO_STRING_VALUE);
    }

    public boolean getBool(String key) {
        return this.appSharedPrefs_.getBoolean(key, false);
    }

    public void setInteger(String key, int value) {
        this.prefsEditor_.putInt(key, value).apply();
    }

    public void setLong(String key, long value) {
        this.prefsEditor_.putLong(key, value).apply();
    }

    public void setFloat(String key, float value) {
        this.prefsEditor_.putFloat(key, value).apply();
    }

    public void setString(String key, String value) {
        this.prefsEditor_.putString(key, value).apply();
    }

    public void setBool(String key, Boolean value) {
        this.prefsEditor_.putBoolean(key, value.booleanValue()).apply();
    }

    private void clearPrefOnBranchKeyChange() {
        String linkClickID = this.getLinkClickID();
        String linkClickIdentifier = this.getLinkClickIdentifier();
        String appLink = this.getAppLink();
        String pushIdentifier = this.getPushIdentifier();
        this.prefsEditor_.clear();
        this.setLinkClickID(linkClickID);
        this.setLinkClickIdentifier(linkClickIdentifier);
        this.setAppLink(appLink);
        this.setPushIdentifier(pushIdentifier);
        this.prefsEditor_.apply();
    }

    public void setRequestMetadata(@NonNull String key, @NonNull String value) {
        if (key == null) {
            return;
        }
        if (this.requestMetadata.has(key) && value == null) {
            this.requestMetadata.remove(key);
        }
        try {
            this.requestMetadata.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public JSONObject getRequestMetadata() {
        return this.requestMetadata;
    }

    void addInstallMetadata(String key, String value) {
        if (key == null) {
            return;
        }
        try {
            this.installMetadata.putOpt(key, (Object)value);
        }
        catch (JSONException e) {
            BranchLogger.d(e.getMessage());
        }
    }

    String getInstallMetaData(String key) {
        if (key == null) {
            return null;
        }
        try {
            return this.installMetadata.get(key).toString();
        }
        catch (JSONException e) {
            BranchLogger.d(e.getMessage());
            return null;
        }
    }

    public JSONObject getInstallMetadata() {
        return this.installMetadata;
    }

    boolean shouldAddModules() {
        try {
            return this.secondaryRequestMetadata.length() != 0;
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
            return false;
        }
    }

    static void enableLogging(boolean fEnable) {
        enableLogging_ = fEnable;
    }

    static void useEUEndpoint(boolean enable) {
        useEUEndpoint_ = enable;
    }

    boolean hasValidBranchKey() {
        return PrefHelper.isValidBranchKey(this.getBranchKey());
    }

    static boolean isValidBranchKey(String branchKey) {
        return branchKey != null && branchKey.startsWith(BranchUtil.isTestModeEnabled() ? "key_test_" : "key_");
    }

    public void loadPartnerParams(JSONObject body) throws JSONException {
        PrefHelper.loadPartnerParams(body, this.partnerParams_);
    }

    static void loadPartnerParams(JSONObject body, BranchPartnerParameters partnerParams) throws JSONException {
        if (body == null) {
            return;
        }
        JSONObject partnerData = new JSONObject();
        for (Map.Entry<String, ConcurrentHashMap<String, String>> e : partnerParams.allParams().entrySet()) {
            JSONObject individualPartnerParams = new JSONObject();
            for (Map.Entry<String, String> p : e.getValue().entrySet()) {
                individualPartnerParams.put(p.getKey(), (Object)p.getValue());
            }
            partnerData.put(e.getKey(), (Object)individualPartnerParams);
        }
        body.put(Defines.Jsonkey.PartnerData.getKey(), (Object)partnerData);
    }

    public Defines.BranchAttributionLevel getConsumerProtectionAttributionLevel() {
        String levelString = this.getString(KEY_CONSUMER_PROTECTION_ATTRIBUTION_LEVEL);
        if (levelString.equals(NO_STRING_VALUE)) {
            return Defines.BranchAttributionLevel.FULL;
        }
        return Defines.BranchAttributionLevel.valueOf(levelString);
    }

    public void setConsumerProtectionAttributionLevel(Defines.BranchAttributionLevel preference) {
        this.setString(KEY_CONSUMER_PROTECTION_ATTRIBUTION_LEVEL, preference.toString());
    }

    boolean isAttributionLevelInitialized() {
        return this.hasPrefValue(KEY_CONSUMER_PROTECTION_ATTRIBUTION_LEVEL);
    }

    public void setWebLinkUxTypeUsed(String key) {
        this.setString(KEY_ENHANCED_WEB_LINK_UX_USED, key);
    }

    public void setWebLinkLoadTime(long l) {
        this.setLong(KEY_URL_LOAD_MS, l);
    }

    public String getWebLinkUxTypeUsed() {
        return this.getString(KEY_ENHANCED_WEB_LINK_UX_USED);
    }

    public long getWebLinkLoadTime() {
        return this.getLong(KEY_URL_LOAD_MS);
    }

    static {
        customServerURL_ = null;
        customCDNBaseURL_ = null;
        enableLogging_ = false;
        useEUEndpoint_ = false;
        fbAppId_ = null;
    }
}

