/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import io.branch.referral.ApkParser;
import io.branch.referral.Branch;
import io.branch.referral.BranchJsonConfig;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchUtil {
    private static boolean isTestModeEnabled_ = false;
    private static Boolean testModeEnabledViaCompileTimeConfiguration = null;

    static void shutDown() {
        isTestModeEnabled_ = false;
        testModeEnabledViaCompileTimeConfiguration = null;
    }

    static boolean checkTestMode(Context context) {
        if (!isTestModeEnabled_ && testModeEnabledViaCompileTimeConfiguration == null) {
            Boolean r;
            BranchJsonConfig jsonConfig = BranchJsonConfig.getInstance(context);
            isTestModeEnabled_ = jsonConfig.isValid(BranchJsonConfig.BranchJsonKey.useTestInstance) ? ((r = jsonConfig.getUseTestInstance()) != null ? r : false) : BranchUtil.readTestMode(context);
            testModeEnabledViaCompileTimeConfiguration = isTestModeEnabled_;
        }
        return isTestModeEnabled_;
    }

    private static boolean readTestMode(Context context) {
        boolean result = isTestModeEnabled_;
        String testModeKey = "io.branch.sdk.TestMode";
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (ai.metaData != null && ai.metaData.containsKey(testModeKey)) {
                result = ai.metaData.getBoolean(testModeKey, false);
            } else {
                Resources resources = context.getResources();
                result = Boolean.parseBoolean(resources.getString(resources.getIdentifier(testModeKey, "string", context.getPackageName())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String readBranchKey(Context context) {
        String branchKey = null;
        BranchJsonConfig jsonConfig = BranchJsonConfig.getInstance(context);
        if (jsonConfig.isValid()) {
            branchKey = jsonConfig.getBranchKey();
        }
        if (branchKey != null) {
            return branchKey;
        }
        String metaDataKey = BranchUtil.isTestModeEnabled() ? "io.branch.sdk.BranchKey.test" : "io.branch.sdk.BranchKey";
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (ai.metaData != null && (branchKey = ai.metaData.getString(metaDataKey)) == null && BranchUtil.isTestModeEnabled()) {
                branchKey = ai.metaData.getString("io.branch.sdk.BranchKey");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            BranchLogger.d(e.getMessage());
        }
        if (branchKey != null) {
            return branchKey;
        }
        Resources resources = context.getResources();
        branchKey = resources.getString(resources.getIdentifier(metaDataKey, "string", context.getPackageName()));
        return branchKey;
    }

    public static boolean getEnableLoggingConfig(Context context) {
        BranchJsonConfig jsonConfig = BranchJsonConfig.getInstance(context);
        boolean enableLogging = false;
        if (jsonConfig.isValid()) {
            enableLogging = Boolean.TRUE.equals(jsonConfig.getEnableLogging());
        }
        return enableLogging;
    }

    public static boolean getDeferInitForPluginRuntimeConfig(Context context) {
        BranchJsonConfig jsonConfig = BranchJsonConfig.getInstance(context);
        boolean deferInitForPluginRuntime = false;
        if (jsonConfig.isValid()) {
            deferInitForPluginRuntime = Boolean.TRUE.equals(jsonConfig.getDeferInitForPluginRuntime());
        }
        return deferInitForPluginRuntime;
    }

    public static void setAPIBaseUrlFromConfig(Context context) {
        BranchJsonConfig jsonConfig = BranchJsonConfig.getInstance(context);
        String apiUrl = jsonConfig.getAPIUrl();
        if (!TextUtils.isEmpty((CharSequence)apiUrl)) {
            Branch.setAPIUrl(apiUrl);
        }
    }

    public static void setFbAppIdFromConfig(Context context) {
        BranchJsonConfig jsonConfig = BranchJsonConfig.getInstance(context);
        String fbAppId = jsonConfig.getFbAppId();
        if (!TextUtils.isEmpty((CharSequence)fbAppId)) {
            Branch.setFBAppID(fbAppId);
        }
    }

    public static void setCPPLevelFromConfig(Context context) {
        BranchJsonConfig jsonConfig = BranchJsonConfig.getInstance(context);
        String jsonString = jsonConfig.getConsumerProtectionAttributionLevel();
        if (!TextUtils.isEmpty((CharSequence)jsonString)) {
            Defines.BranchAttributionLevel cppLevel = Defines.BranchAttributionLevel.valueOf(jsonString);
            Branch.getInstance().setConsumerProtectionAttributionLevel(cppLevel);
        }
    }

    public static boolean isTestModeEnabled() {
        return isTestModeEnabled_;
    }

    static void setTestMode(boolean testMode) {
        isTestModeEnabled_ = testMode;
    }

    public static String decodeResourceId(Context context, int resourceId) {
        try {
            if (resourceId != -1) {
                return context.getResources().getString(resourceId);
            }
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
        return null;
    }

    public static Drawable getDrawable(@NonNull Context context, @DrawableRes int drawableID) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(drawableID, context.getTheme());
        }
        return context.getResources().getDrawable(drawableID);
    }

    public static int dpToPx(Context context, int dp) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
    }

    public static boolean isLowOnMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(mi);
        return mi.lowMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getDeepLinkSchemes(Context context) {
        JSONObject obj = null;
        if (!BranchUtil.isLowOnMemory(context)) {
            ZipFile jf = null;
            InputStream is = null;
            try {
                jf = new JarFile(context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).publicSourceDir);
                is = ((JarFile)jf).getInputStream(((JarFile)jf).getEntry("AndroidManifest.xml"));
                byte[] xml = new byte[is.available()];
                is.read(xml);
                obj = new ApkParser().decompressXMLForValidator(xml, context);
            }
            catch (Exception e) {
                BranchLogger.d(e.getMessage());
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                        is = null;
                    }
                    if (jf != null) {
                        jf.close();
                    }
                }
                catch (IOException e) {
                    BranchLogger.d(e.getMessage());
                }
            }
        }
        return obj;
    }

    public static class JsonReader {
        private final JSONObject jsonObject;

        public JsonReader(JSONObject jsonObject) {
            JSONObject tempJsonObj = new JSONObject();
            try {
                tempJsonObj = new JSONObject(jsonObject.toString());
            }
            catch (JSONException e) {
                BranchLogger.d(e.getMessage());
            }
            this.jsonObject = tempJsonObj;
        }

        public JSONObject getJsonObject() {
            return this.jsonObject;
        }

        public int readOutInt(String key) {
            int val = this.jsonObject.optInt(key);
            this.jsonObject.remove(key);
            return val;
        }

        public Integer readOutInt(String key, Integer fallback) {
            Integer val = fallback;
            if (this.jsonObject.has(key)) {
                val = this.jsonObject.optInt(key);
                this.jsonObject.remove(key);
            }
            return val;
        }

        public String readOutString(String key) {
            String val = this.jsonObject.optString(key);
            this.jsonObject.remove(key);
            return val;
        }

        public String readOutString(String key, String fallback) {
            String val = this.jsonObject.optString(key, fallback);
            this.jsonObject.remove(key);
            return val;
        }

        public long readOutLong(String key) {
            long val = this.jsonObject.optLong(key);
            this.jsonObject.remove(key);
            return val;
        }

        public double readOutDouble(String key) {
            double val = this.jsonObject.optDouble(key);
            this.jsonObject.remove(key);
            return val;
        }

        public Double readOutDouble(String key, Double fallback) {
            Double val = fallback;
            if (this.jsonObject.has(key)) {
                val = this.jsonObject.optDouble(key);
                this.jsonObject.remove(key);
            }
            return val;
        }

        public boolean readOutBoolean(String key) {
            boolean val = this.jsonObject.optBoolean(key);
            this.jsonObject.remove(key);
            return val;
        }

        public JSONArray readOutJsonArray(String key) {
            JSONArray val = this.jsonObject.optJSONArray(key);
            this.jsonObject.remove(key);
            return val;
        }

        public Object readOut(String key) {
            Object val = this.jsonObject.opt(key);
            this.jsonObject.remove(key);
            return val;
        }

        public boolean has(String key) {
            return this.jsonObject.has(key);
        }

        public Iterator<String> keys() {
            return this.jsonObject.keys();
        }
    }
}

